/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.project;

import com.jstatcom.component.TopFrame;
import com.jstatcom.io.FileSupport;
import com.jstatcom.io.FileSupportSettings;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.project.ProjectManager;
import com.jstatcom.project.ProjectTree;
import com.jstatcom.project.ProjectTreeNode;
import com.jstatcom.project.Settings;
import com.jstatcom.project.SettingsElement;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javolution37.javolution.xml.ObjectReader;
import javolution37.javolution.xml.ObjectWriter;
import org.apache.log4j.Logger;

public final class SettingsManager {
    private static final Logger log = Logger.getLogger(SettingsManager.class);
    private final String settingsFileName = "." + TopFrame.TITLE.toLowerCase() + "_settings";
    private final String lastStateFileName = "." + TopFrame.TITLE.toLowerCase() + "_laststate";
    private final String settingsPath = JSCConstants.getUserHome() + File.separator + this.settingsFileName;
    public final String LAST_STATE_PATH = JSCConstants.getUserHome() + File.separator + this.lastStateFileName;
    private static final SettingsManager INSTANCE = new SettingsManager();

    private SettingsManager() {
    }

    public static SettingsManager getInstance() {
        return INSTANCE;
    }

    public void restoreSettings() {
        ObjectReader constructor = new ObjectReader();
        File file = new File(this.settingsPath);
        if (!file.canRead()) {
            return;
        }
        Settings settings = null;
        try {
            settings = (Settings)constructor.read(new FileInputStream(file));
        }
        catch (Throwable t) {
            log.error((Object)("Failed to read settings from " + file.getAbsolutePath()), t);
            return;
        }
        Iterator iter = settings.getSettingsIterator();
        while (iter.hasNext()) {
            SettingsElement element = (SettingsElement)iter.next();
            element.setElement();
        }
    }

    public void saveSettings() {
        FileSupport fSupport;
        SettingsElement element;
        Settings settings = new Settings();
        Iterator iter = ProjectTree.getInstance().getProjectNodesIterator();
        while (iter.hasNext()) {
            element = (ProjectTreeNode)iter.next();
            if (element.isLastState()) continue;
            settings.addSettingsElement(element);
        }
        TopFrame topFrame = ProjectManager.getInstance().getTopFrame();
        if (topFrame != null) {
            element = topFrame.getTopFrameSettings();
            settings.addSettingsElement(element);
        }
        if (topFrame != null) {
            element = topFrame.getAppSettings();
            settings.addSettingsElement(element);
        }
        if ((fSupport = FileSupport.getInstance()) != null) {
            FileSupportSettings element2 = fSupport.getFileSupportSettings();
            settings.addSettingsElement(element2);
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.settingsPath));
            ObjectWriter<Settings> objectWriter = new ObjectWriter<Settings>();
            objectWriter.setPackagePrefix("", "com.jstatcom.model");
            objectWriter.setPackagePrefix("jstatcom", "com.jstatcom");
            objectWriter.write(settings, out);
        }
        catch (IOException ivjExc) {
            log.error((Object)("XML serialization failed to file " + this.settingsPath), (Throwable)ivjExc);
        }
    }

    public void saveLastState() {
        ProjectManager.getInstance().serializeProject(new File(this.LAST_STATE_PATH), "LAST STATE", null);
    }

    public void restoreLastState() {
        File lastStateFile = new File(this.LAST_STATE_PATH);
        if (lastStateFile.canRead()) {
            ProjectTreeNode node = ProjectManager.getInstance().deSerializeProject(lastStateFile);
            node.setLastState(true);
        }
    }
}

