/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.parser;

import com.jstatcom.model.JSCConstants;
import com.jstatcom.parser.CalcEngineConstants;
import com.jstatcom.parser.CalcEngineTokenManager;
import com.jstatcom.parser.CalcFunctions;
import com.jstatcom.parser.ParseException;
import com.jstatcom.parser.SimpleCharStream;
import com.jstatcom.parser.Token;
import com.jstatcom.parser.TokenMgrError;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

public class CalcEngine
implements CalcEngineConstants {
    private final Map variableMap = new HashMap(){

        @Override
        public Object put(Object keyName, Object varArray) {
            if (keyName != null) {
                keyName = keyName.toString().toLowerCase();
            }
            return super.put(keyName, varArray);
        }

        @Override
        public Object get(Object keyName) {
            if (keyName != null) {
                keyName = keyName.toString().toLowerCase();
            }
            return super.get(keyName);
        }

        @Override
        public boolean containsKey(Object keyName) {
            if (keyName != null) {
                keyName = keyName.toString().toLowerCase();
            }
            return super.containsKey(keyName);
        }
    };
    private final Stack argStack = new Stack();
    private final StringBuffer outputBuffer = new StringBuffer();
    public CalcEngineTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private int jj_gen;
    private final int[] jj_la1 = new int[12];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) {
        CalcEngine parser = new CalcEngine(System.in);
        parser.putVariable("a", new double[2]);
        parser.putVariable("b", new double[4]);
    }

    public CalcEngine() {
        this(new StringReader(""));
    }

    public void clearVariableMap() {
        this.variableMap.clear();
    }

    public void putVariable(String keyName, double[] dataArray) {
        String error = JSCConstants.isValidName(keyName);
        if (error != null) {
            throw new IllegalArgumentException("Bad key: " + error);
        }
        if (dataArray == null) {
            throw new IllegalArgumentException("Data array was null.");
        }
        double[] varArray = new double[dataArray.length];
        for (int i = 0; i < dataArray.length; ++i) {
            varArray[i] = dataArray[i];
        }
        this.variableMap.put(keyName, varArray);
    }

    public String[] getVariableNames() {
        Set keys = this.variableMap.keySet();
        String[] varNames = new String[keys.size()];
        int i = 0;
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            varNames[i++] = iter.next().toString();
        }
        return varNames;
    }

    public double[] getVariable(String variableName) {
        return (double[])this.variableMap.get(variableName);
    }

    public String getOutput() {
        String output = "";
        if (this.outputBuffer.length() > 0) {
            output = this.outputBuffer.toString();
        }
        this.outputBuffer.delete(0, this.outputBuffer.length());
        return output;
    }

    public void parseString(String inputString) throws ParseException, TokenMgrError {
        if (!inputString.endsWith(";")) {
            inputString = inputString + ";";
        }
        this.ReInit(new StringReader(inputString));
        this.outputBuffer.delete(0, this.outputBuffer.length());
        this.toeval();
    }

    private void callFunctionForName(String functName, int argNum) throws ParseException {
        try {
            CalcFunctions.callFunctionForName(functName, argNum, this.argStack);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException(ex.getMessage());
        }
    }

    public final int toeval() throws ParseException {
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(5);
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 12: 
                case 16: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block10;
                }
            }
            this.equation();
            block11: while (true) {
                this.jj_consume_token(5);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[2] = this.jj_gen;
        }
        this.jj_consume_token(0);
        return 1;
    }

    public final void equation() throws ParseException {
        String currentLHS = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                String lhs = this.token.image;
                currentLHS = lhs.substring(0, lhs.lastIndexOf(61)).trim();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.sum();
        double[] result = (double[])this.argStack.peek();
        if (currentLHS != null) {
            double[] assignedArray = new double[result.length];
            for (int i = 0; i < result.length; ++i) {
                assignedArray[i] = result[i];
            }
            this.variableMap.put(currentLHS, assignedArray);
            currentLHS = null;
        } else {
            double[] x = (double[])this.argStack.pop();
            for (int i = 0; i < x.length; ++i) {
                this.outputBuffer.append(x[i] + "\n");
            }
            this.outputBuffer.append("\n");
        }
    }

    public final void sum() throws ParseException {
        this.term();
        block9: while (true) {
            int i;
            Token x;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    x = this.jj_consume_token(6);
                    break;
                }
                case 7: {
                    x = this.jj_consume_token(7);
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.term();
            double[] bb = (double[])this.argStack.pop();
            double[] aa = (double[])this.argStack.pop();
            int length = 1;
            try {
                length = CalcFunctions.getLength(aa, bb);
            }
            catch (IllegalArgumentException ex) {
                throw new ParseException(ex.getMessage());
            }
            double[] result = new double[length];
            if (x.kind == 6) {
                for (i = 0; i < result.length; ++i) {
                    result[i] = (aa.length == 1 ? aa[0] : aa[i]) + (bb.length == 1 ? bb[0] : bb[i]);
                }
            } else {
                for (i = 0; i < result.length; ++i) {
                    result[i] = (aa.length == 1 ? aa[0] : aa[i]) - (bb.length == 1 ? bb[0] : bb[i]);
                }
            }
            this.argStack.push(result);
        }
    }

    public final void term() throws ParseException {
        this.exp();
        block10: while (true) {
            int i;
            Token x;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block10;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    x = this.jj_consume_token(8);
                    break;
                }
                case 9: {
                    x = this.jj_consume_token(9);
                    break;
                }
                case 11: {
                    x = this.jj_consume_token(11);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.exp();
            double[] bb = (double[])this.argStack.pop();
            double[] aa = (double[])this.argStack.pop();
            int length = 1;
            double[] result = null;
            if (x.kind == 8 || x.kind == 9) {
                try {
                    length = CalcFunctions.getLength(aa, bb);
                }
                catch (IllegalArgumentException ex) {
                    throw new ParseException(ex.getMessage());
                }
                result = new double[length];
            } else {
                result = new double[aa.length + bb.length];
            }
            if (x.kind == 8) {
                for (i = 0; i < result.length; ++i) {
                    result[i] = (aa.length == 1 ? aa[0] : aa[i]) * (bb.length == 1 ? bb[0] : bb[i]);
                }
            } else if (x.kind == 9) {
                for (i = 0; i < result.length; ++i) {
                    result[i] = (aa.length == 1 ? aa[0] : aa[i]) / (bb.length == 1 ? bb[0] : bb[i]);
                }
            } else {
                int index = 0;
                int i2 = 0;
                while (i2 < aa.length) {
                    result[index] = aa[i2];
                    ++i2;
                    ++index;
                }
                i2 = 0;
                while (i2 < bb.length) {
                    result[index] = bb[i2];
                    ++i2;
                    ++index;
                }
            }
            this.argStack.push(result);
        }
    }

    public final void exp() throws ParseException {
        this.unary();
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(10);
            this.exp();
            double[] bb = (double[])this.argStack.pop();
            double[] aa = (double[])this.argStack.pop();
            int length = 1;
            try {
                length = CalcFunctions.getLength(aa, bb);
            }
            catch (IllegalArgumentException ex) {
                throw new ParseException(ex.getMessage());
            }
            double[] result = new double[length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Math.pow(aa[i], bb.length == 1 ? bb[0] : bb[i]);
            }
            this.argStack.push(result);
        }
    }

    public final void unary() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                this.element();
                double[] aa = (double[])this.argStack.pop();
                double[] result = new double[aa.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = -aa[i];
                }
                this.argStack.push(result);
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 20: {
                this.element();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void element() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                double[] result = new double[1];
                try {
                    result[0] = Double.valueOf(this.token.image);
                }
                catch (NumberFormatException ee) {
                    result[0] = Double.NaN;
                }
                this.argStack.push(result);
                break;
            }
            case 18: {
                this.function();
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                this.sum();
                this.jj_consume_token(21);
                break;
            }
            case 16: {
                this.variable();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void variable() throws ParseException {
        String var;
        this.jj_consume_token(16);
        String varName = var = this.token.image;
        double[] result = null;
        if (this.variableMap.containsKey(varName)) {
            double[] values = (double[])this.variableMap.get(varName);
            result = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                result[i] = values[i];
            }
        } else {
            throw new ParseException("Variable \"" + varName + "\" is not available.");
        }
        this.argStack.push(result);
    }

    public final void function() throws ParseException {
        int args = 0;
        this.jj_consume_token(18);
        String funcName = this.token.image;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 12: 
            case 16: 
            case 18: 
            case 20: {
                this.sum();
                ++args;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 22: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(22);
                    this.sum();
                    ++args;
                }
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(21);
        funcName = funcName.substring(0, funcName.indexOf("(")).trim();
        this.callFunctionForName(funcName, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_3_1() {
        return this.jj_scan_token(10);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{32, 1904768, 32, 524288, 192, 192, 2816, 2816, 1380480, 0x151000, 0x400000, 1380480};
    }

    public CalcEngine(InputStream stream) {
        this(stream, null);
    }

    public CalcEngine(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CalcEngineTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CalcEngine(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CalcEngineTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CalcEngine(CalcEngineTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CalcEngineTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[23];
        for (i = 0; i < 23; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 12; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 23; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        CalcEngine.jj_la1_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

