/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model.control;

import com.jstatcom.component.CardDisplayPanel;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.control.DefaultSymbolPanel;
import com.jstatcom.model.control.JSCNArrayPanel;
import com.jstatcom.model.control.JSCSArrayPanel;
import com.jstatcom.model.control.SymbolPanel;
import com.jstatcom.model.control.SymbolTree;
import com.jstatcom.model.control.SymbolTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class SymbolFrame
extends JFrame {
    private JSplitPane jSplitPane = null;
    private JScrollPane jScrollPane = null;
    private SymbolTree symbolTree = SymbolTree.getInstance();
    private JPanel jPanel = null;
    private JPanel topPanel = null;
    private CardDisplayPanel cardDisplayPanel = null;
    private JLabel nameLabel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel typeLabel = null;
    private JScrollPane jScrollPane1 = null;
    private JTextArea jTextArea = null;
    private final Map<JSCTypes, SymbolPanel> symbolPanelMap = new HashMap<JSCTypes, SymbolPanel>();
    private SymbolPanel defaultSymbolPanel;

    public SymbolFrame() {
        super("Symbol Control");
        this.initialize();
    }

    public final void addSymbolPanel(JSCTypes type, SymbolPanel panel) {
        if (type == null || panel == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.symbolPanelMap.put(type, panel);
    }

    private void initialize() {
        this.setContentPane(this.getJSplitPane());
        this.setSize(600, 400);
        URL url = this.getClass().getResource("/images/scontrol.gif");
        if (url != null) {
            this.setIconImage(new ImageIcon(url).getImage());
        }
        this.defaultSymbolPanel = new DefaultSymbolPanel();
        this.getCardDisplayPanel().showCard(this.defaultSymbolPanel);
        this.symbolTree.addTreeSelectionListener(new TreeSelectionListener(){
            private Symbol currentSymbol = null;

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                Object item = evt.getPath().getLastPathComponent();
                if (item instanceof SymbolTreeNode) {
                    Symbol symbol = ((SymbolTreeNode)item).symbol;
                    SymbolFrame.this.getNameLabel().setText(symbol.NAME);
                    SymbolFrame.this.getTypeLabel().setText(symbol.type + "");
                    SymbolFrame.this.getDescriptionArea().setText(symbol.getDescription());
                    SymbolFrame.this.getDescriptionArea().setCaretPosition(0);
                    if (SymbolFrame.this.symbolPanelMap.containsKey(symbol.type)) {
                        SymbolPanel sPanel = (SymbolPanel)SymbolFrame.this.symbolPanelMap.get(symbol.type);
                        if (this.currentSymbol != null) {
                            this.currentSymbol.removeSymbolListener(sPanel);
                        }
                        this.currentSymbol = symbol;
                        this.currentSymbol.addSymbolListener(sPanel);
                        sPanel.setSymbol(symbol);
                        SymbolFrame.this.getCardDisplayPanel().showCard(sPanel);
                    } else {
                        if (this.currentSymbol != null) {
                            this.currentSymbol.removeSymbolListener(SymbolFrame.this.defaultSymbolPanel);
                        }
                        this.currentSymbol = symbol;
                        this.currentSymbol.addSymbolListener(SymbolFrame.this.defaultSymbolPanel);
                        SymbolFrame.this.defaultSymbolPanel.setSymbol(symbol);
                        SymbolFrame.this.getCardDisplayPanel().showCard(SymbolFrame.this.defaultSymbolPanel);
                    }
                }
            }
        });
        this.addSymbolPanel(JSCTypes.NARRAY, new JSCNArrayPanel());
        this.addSymbolPanel(JSCTypes.SARRAY, new JSCSArrayPanel());
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setLeftComponent(this.getJScrollPane());
            this.jSplitPane.setRightComponent(this.getJPanel());
        }
        return this.jSplitPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.symbolTree);
            this.jScrollPane.setPreferredSize(new Dimension(150, 363));
            this.jScrollPane.setMinimumSize(new Dimension(100, 300));
        }
        return this.jScrollPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getTopPanel(), "North");
            this.jPanel.add((Component)this.getCardDisplayPanel(), "Center");
            this.jPanel.setMinimumSize(new Dimension(300, 300));
        }
        return this.jPanel;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            GridBagConstraints consGridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints7 = new GridBagConstraints();
            consGridBagConstraints7.fill = 1;
            consGridBagConstraints7.weighty = 1.0;
            consGridBagConstraints7.weightx = 1.0;
            consGridBagConstraints7.gridy = 2;
            consGridBagConstraints7.gridx = 0;
            consGridBagConstraints7.insets = new Insets(0, 0, 0, 0);
            consGridBagConstraints7.gridwidth = 2;
            consGridBagConstraints3.gridy = 0;
            consGridBagConstraints3.gridx = 0;
            consGridBagConstraints3.fill = 2;
            consGridBagConstraints4.gridy = 1;
            consGridBagConstraints4.gridx = 0;
            consGridBagConstraints4.fill = 2;
            consGridBagConstraints5.gridy = 1;
            consGridBagConstraints5.gridx = 1;
            consGridBagConstraints5.fill = 2;
            consGridBagConstraints2.gridy = 0;
            consGridBagConstraints2.gridx = 1;
            consGridBagConstraints2.fill = 2;
            consGridBagConstraints2.insets = new Insets(2, 0, 0, 5);
            consGridBagConstraints5.insets = new Insets(2, 0, 0, 5);
            consGridBagConstraints3.insets = new Insets(2, 5, 0, 0);
            consGridBagConstraints4.insets = new Insets(2, 5, 0, 0);
            this.topPanel.setLayout(new GridBagLayout());
            this.topPanel.add((Component)this.getNameLabel(), consGridBagConstraints2);
            this.topPanel.add((Component)this.getJLabel(), consGridBagConstraints3);
            this.topPanel.add((Component)this.getJLabel1(), consGridBagConstraints4);
            this.topPanel.add((Component)this.getTypeLabel(), consGridBagConstraints5);
            this.topPanel.add((Component)this.getJScrollPane1(), consGridBagConstraints7);
            this.topPanel.setPreferredSize(new Dimension(10, 130));
            this.topPanel.setMinimumSize(new Dimension(10, 130));
            this.topPanel.setBorder(new BevelBorder(1));
        }
        return this.topPanel;
    }

    private CardDisplayPanel getCardDisplayPanel() {
        if (this.cardDisplayPanel == null) {
            this.cardDisplayPanel = new CardDisplayPanel();
        }
        return this.cardDisplayPanel;
    }

    private JLabel getNameLabel() {
        if (this.nameLabel == null) {
            this.nameLabel = new JLabel();
            this.nameLabel.setText("");
            this.nameLabel.setPreferredSize(new Dimension(77, 20));
        }
        return this.nameLabel;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Name");
            this.jLabel.setPreferredSize(new Dimension(60, 20));
            this.jLabel.setMinimumSize(new Dimension(60, 20));
        }
        return this.jLabel;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Type");
            this.jLabel1.setPreferredSize(new Dimension(38, 20));
            this.jLabel1.setMinimumSize(new Dimension(70, 20));
        }
        return this.jLabel1;
    }

    private JLabel getTypeLabel() {
        if (this.typeLabel == null) {
            this.typeLabel = new JLabel();
            this.typeLabel.setText("");
            this.typeLabel.setPreferredSize(new Dimension(38, 20));
        }
        return this.typeLabel;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getDescriptionArea());
            this.jScrollPane1.setBorder(new TitledBorder(new BevelBorder(1), "Description", 3, 2));
            this.jScrollPane1.setPreferredSize(new Dimension(13, 80));
            this.jScrollPane1.setMinimumSize(new Dimension(22, 80));
        }
        return this.jScrollPane1;
    }

    private JTextArea getDescriptionArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setEditable(false);
            this.jTextArea.setMargin(new Insets(2, 5, 2, 5));
        }
        return this.jTextArea;
    }

    public void setDataEditable(boolean editable) {
        for (SymbolPanel val : this.symbolPanelMap.values()) {
            val.setSymbolEditable(editable);
        }
    }
}

