/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

public class NumberRangeTypes {
    public final String leftBracket;
    public final String rightBracket;
    public final boolean leftOpen;
    public final boolean rightOpen;
    private final String name;
    public static final NumberRangeTypes CLOSED = new NumberRangeTypes("CLOSED", false, false);
    public static final NumberRangeTypes OPEN = new NumberRangeTypes("OPEN", true, true);
    public static final NumberRangeTypes LEFT_OPEN = new NumberRangeTypes("LEFT_OPEN", true, false);
    public static final NumberRangeTypes RIGHT_OPEN = new NumberRangeTypes("RIGHT_OPEN", false, true);

    private NumberRangeTypes(String name, boolean leftOpen, boolean rightOpen) {
        this.name = name;
        this.leftOpen = leftOpen;
        this.rightOpen = rightOpen;
        this.leftBracket = leftOpen ? "(" : "[";
        this.rightBracket = rightOpen ? ")" : "]";
    }

    public final String leftBracket() {
        return this.leftBracket;
    }

    public final String name() {
        return this.name;
    }

    public final String rightBracket() {
        return this.rightBracket;
    }

    public static final NumberRangeTypes getTypeForBounds(boolean leftOpen, boolean rightOpen) {
        if (leftOpen && rightOpen) {
            return OPEN;
        }
        if (!leftOpen && !rightOpen) {
            return CLOSED;
        }
        if (!leftOpen && rightOpen) {
            return RIGHT_OPEN;
        }
        if (leftOpen && !rightOpen) {
            return LEFT_OPEN;
        }
        throw new RuntimeException("Code should never be reached.");
    }

    public final boolean isLeftOpen() {
        return this.leftOpen;
    }

    public final boolean isRightOpen() {
        return this.rightOpen;
    }

    public final String toString() {
        return this.name + " " + this.leftBracket + "lower, upper" + this.rightBracket;
    }
}

