/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import com.jstatcom.component.CompSettings;
import com.jstatcom.component.TopFrameReference;
import com.jstatcom.io.DataHandler;
import com.jstatcom.io.ImportTypes;
import com.jstatcom.io.TSDataDialog;
import com.jstatcom.io.TSImportTypes;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDate;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCString;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSDateRange;
import com.jstatcom.util.UMatrix;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.log4j.Logger;

public final class TSMatlabHandler
implements DataHandler {
    private static final Logger log = Logger.getLogger(TSMatlabHandler.class);
    private boolean noDialog = false;
    private static final TSMatlabHandler handler = new TSMatlabHandler();
    private static final int miINT8 = 1;
    private static final int miUINT8 = 2;
    private static final int miINT16 = 3;
    private static final int miUINT16 = 4;
    private static final int miINT32 = 5;
    private static final int miUINT32 = 6;
    private static final int miSINGLE = 7;
    private static final int miDOUBLE = 9;
    private static final int miINT64 = 12;
    private static final int miMATRIX = 14;
    private static final int miCOMPRESSED = 15;
    private static final int mxDOUBLE_CLASS = 6;
    private static final int mxUINT32_CLASS = 13;
    private TSDataDialog dialog = null;
    private boolean cancelled = false;
    private boolean isLittleEndian = false;
    private final List<String> namesList = new ArrayList<String>();
    private final List<JSCNArray> dataList = new ArrayList<JSCNArray>();
    private final SymbolTable symbolTable = new SymbolTable("TSMatlabHandler", false);

    public static TSMatlabHandler getInstance() {
        return handler;
    }

    @Override
    public boolean importData(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Invalid data file " + file + ".");
        }
        this.cancelled = false;
        this.namesList.clear();
        this.dataList.clear();
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            byte[] toRead = new byte[116];
            in.read(toRead);
            if (toRead[0] == 0 && toRead[2] == 0 || toRead[3] == 0 || toRead[4] == 0) {
                throw new RuntimeException("Cannot read Matlab Level 4 files. Please use newer Level 5 format.");
            }
            String description = new String(toRead).trim();
            in.skip(10L);
            toRead = new byte[2];
            in.read(toRead);
            String endianTest = new String(toRead);
            this.isLittleEndian = endianTest.equalsIgnoreCase("IM");
            int skippedBytes = 128;
            while (in.available() > 0) {
                toRead = new byte[4];
                in.read(toRead);
                boolean isSmallData = !(toRead[0] == 0 && toRead[1] == 0 || toRead[2] == 0 && toRead[3] == 0);
                in.close();
                in = new DataInputStream(new FileInputStream(file));
                in.skip(skippedBytes);
                if (isSmallData) {
                    in.skip(8L);
                    skippedBytes += 8;
                    continue;
                }
                skippedBytes += this.readData(in);
            }
            in.close();
            if (this.namesList.isEmpty()) {
                throw new RuntimeException("Import failed because none of the stored Matlab data types is supported.");
            }
            this.setDataToSymbolTable(description);
            return !this.cancelled;
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    private int readData(DataInputStream in) throws Exception {
        int type = in.readInt();
        if (this.isLittleEndian) {
            type = Integer.reverseBytes(type);
        }
        int numOfBytes = in.readInt();
        if (this.isLittleEndian) {
            numOfBytes = Integer.reverseBytes(numOfBytes);
        }
        if (type == 15) {
            DataInputStream inflatedIn = this.miCompressed(in, numOfBytes);
            this.readData(inflatedIn);
            inflatedIn.close();
            return 8 + numOfBytes;
        }
        if (type == 14) {
            byte[] data = new byte[numOfBytes];
            in.read(data);
            this.miMatrix(data);
        } else {
            in.skipBytes(numOfBytes);
        }
        return 8 + numOfBytes + TSMatlabHandler.skipPaddingBytes(in, 8, numOfBytes);
    }

    private void miMatrix(byte[] data) throws IOException {
        short typeShort;
        int index;
        ByteArrayInputStream inBytes = new ByteArrayInputStream(data);
        DataInputStream inDat = new DataInputStream(inBytes);
        inDat.skip(8L);
        byte[] flags_class = new byte[4];
        inDat.read(flags_class);
        byte array_class = flags_class[3];
        if (this.isLittleEndian) {
            array_class = flags_class[0];
        }
        inDat.skip(4L);
        if (array_class < 6 || array_class > 13) {
            inDat.close();
            inBytes.close();
            return;
        }
        inDat.skip(4L);
        int n = 0;
        int nBytes = inDat.readInt();
        if (this.isLittleEndian) {
            nBytes = Integer.reverseBytes(nBytes);
        }
        if ((n = nBytes / 4) > 2) {
            return;
        }
        int rows = inDat.readInt();
        if (this.isLittleEndian) {
            rows = Integer.reverseBytes(rows);
        }
        int cols = inDat.readInt();
        if (this.isLittleEndian) {
            cols = Integer.reverseBytes(cols);
        }
        boolean isSmallData = !(data[index = 24 + (nBytes += TSMatlabHandler.skipPaddingBytes(inDat, 8, nBytes))] == 0 && data[index + 1] == 0 || data[index + 2] == 0 && data[index + 3] == 0);
        String name = "";
        if (isSmallData) {
            inDat.skip(4L);
            byte[] nam = new byte[4];
            inDat.read(nam);
            name = new String(nam).trim().toLowerCase();
            index += 8;
        } else {
            inDat.skip(4L);
            int nameBytes = inDat.readInt();
            if (this.isLittleEndian) {
                nameBytes = Integer.reverseBytes(nameBytes);
            }
            byte[] nam = new byte[nameBytes];
            inDat.read(nam);
            name = new String(nam).trim().toLowerCase();
            index += 8 + nameBytes + TSMatlabHandler.skipPaddingBytes(inDat, 8, nameBytes);
        }
        for (int i = 0; i < cols; ++i) {
            String toAdd = name;
            if (cols > 1) {
                toAdd = name + "_" + (i + 1);
            }
            if (JSCConstants.isValidName(toAdd) != null || this.namesList.contains(toAdd)) {
                toAdd = "var_" + (this.namesList.size() + 1);
            }
            this.namesList.add(toAdd);
        }
        isSmallData = !(data[index] == 0 && data[index + 1] == 0 || data[index + 2] == 0 && data[index + 3] == 0);
        int type = 0;
        if (!isSmallData) {
            type = inDat.readInt();
            if (this.isLittleEndian) {
                type = Integer.reverseBytes(type);
            }
            int realPartBytes = inDat.readInt();
            if (this.isLittleEndian) {
                realPartBytes = Integer.reverseBytes(realPartBytes);
            }
        } else if (this.isLittleEndian) {
            typeShort = Short.reverseBytes(inDat.readShort());
            type = typeShort;
            inDat.skip(2L);
        } else {
            inDat.skip(2L);
            typeShort = inDat.readShort();
            type = typeShort;
        }
        double[][] dataArray = new double[rows][cols];
        for (int i = 0; i < cols; ++i) {
            for (int j = 0; j < rows; ++j) {
                dataArray[j][i] = this.readNumber(inDat, type, this.isLittleEndian);
            }
        }
        String arrayName = "realPart";
        if (JSCConstants.isValidName(name) == null) {
            arrayName = name;
        }
        JSCNArray realPart = new JSCNArray(arrayName, dataArray);
        this.dataList.add(realPart);
        inDat.close();
        inBytes.close();
    }

    private double readNumber(DataInputStream inDat, int mLabNumberType, boolean littleEndian) throws IOException {
        double number = Double.NaN;
        if (littleEndian) {
            switch (mLabNumberType) {
                case 9: {
                    number = Double.longBitsToDouble(Long.reverseBytes(inDat.readLong()));
                    break;
                }
                case 7: {
                    number = Float.intBitsToFloat(Integer.reverseBytes(inDat.readInt()));
                    break;
                }
                case 1: {
                    number = inDat.readByte();
                    break;
                }
                case 2: {
                    number = inDat.readUnsignedByte();
                    break;
                }
                case 3: {
                    short snum = Short.reverseBytes(inDat.readShort());
                    number = snum;
                    break;
                }
                case 4: {
                    byte[] numBytesS = new byte[2];
                    inDat.read(numBytesS);
                    int uinum16 = (numBytesS[1] & 0xFF) << 8 | numBytesS[0] & 0xFF;
                    number = uinum16;
                    break;
                }
                case 5: {
                    int inum = Integer.reverseBytes(inDat.readInt());
                    number = inum;
                    break;
                }
                case 6: {
                    byte[] numBytes = new byte[4];
                    inDat.read(numBytes);
                    long uinum32 = (long)(numBytes[3] & 0xFF) << 24 | (long)(numBytes[2] & 0xFF) << 16 | (long)(numBytes[1] & 0xFF) << 8 | (long)(numBytes[0] & 0xFF);
                    number = Double.longBitsToDouble(uinum32);
                    break;
                }
                case 12: {
                    number = Double.longBitsToDouble(Long.reverseBytes(inDat.readLong()));
                    break;
                }
            }
        } else {
            switch (mLabNumberType) {
                case 9: {
                    number = inDat.readDouble();
                    break;
                }
                case 7: {
                    number = inDat.readFloat();
                    break;
                }
                case 1: {
                    number = inDat.readByte();
                    break;
                }
                case 2: {
                    number = inDat.readUnsignedByte();
                    break;
                }
                case 3: {
                    number = inDat.readShort();
                    break;
                }
                case 4: {
                    number = inDat.readUnsignedShort();
                    break;
                }
                case 5: {
                    number = inDat.readInt();
                    break;
                }
                case 6: {
                    byte[] numBytes = new byte[4];
                    inDat.read(numBytes);
                    long num = (long)(numBytes[0] & 0xFF) << 24 | (long)(numBytes[1] & 0xFF) << 16 | (long)(numBytes[2] & 0xFF) << 8 | (long)(numBytes[3] & 0xFF);
                    number = Double.longBitsToDouble(num);
                    break;
                }
                case 12: {
                    number = inDat.readLong();
                    break;
                }
            }
        }
        return number;
    }

    public static int skipPaddingBytes(DataInputStream in, int padding, int bytes) throws IOException {
        int rest = bytes % padding;
        int toSkip = 0;
        if (rest > 0) {
            toSkip = padding - rest;
        }
        if (in != null) {
            in.skipBytes(toSkip);
        }
        return toSkip;
    }

    private DataInputStream miCompressed(DataInputStream in, int numOfCompressedBytes) throws Exception {
        byte[] readCompressed = new byte[numOfCompressedBytes];
        in.read(readCompressed);
        Inflater decompresser = new Inflater();
        decompresser.setInput(readCompressed, 0, numOfCompressedBytes);
        byte[] dataTags = new byte[8];
        decompresser.inflate(dataTags);
        decompresser.end();
        ByteArrayInputStream inBytes = new ByteArrayInputStream(dataTags);
        DataInputStream inDat = new DataInputStream(inBytes);
        int type = 0;
        int numOfBytes = 0;
        try {
            type = inDat.readInt();
            if (this.isLittleEndian) {
                type = Integer.reverseBytes(type);
            }
            numOfBytes = inDat.readInt();
            if (this.isLittleEndian) {
                numOfBytes = Integer.reverseBytes(numOfBytes);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Reading bytes failed.", t);
        }
        inBytes.close();
        inDat.close();
        decompresser = new Inflater();
        decompresser.setInput(readCompressed, 0, numOfCompressedBytes);
        byte[] data = new byte[8 + numOfBytes];
        decompresser.inflate(data);
        decompresser.end();
        inBytes = new ByteArrayInputStream(data);
        inDat = new DataInputStream(inBytes);
        return inDat;
    }

    @Override
    public JSCData getData(ImportTypes type) {
        if (this.symbolTable == null) {
            throw new IllegalStateException("There was nothing imported yet.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        return this.symbolTable.getJSCData(new JSCTypeDef(type.name(), type.type()));
    }

    private TSDataDialog getDataDialog() {
        if (this.dialog == null) {
            this.dialog = new TSDataDialog((Frame)TopFrameReference.getTopFrameRef(), true);
        }
        this.dialog.setLocationRelativeTo(TopFrameReference.getTopFrameRef());
        return this.dialog;
    }

    private void setDataToSymbolTable(String description) {
        String[] namArray = new String[this.namesList.size()];
        for (int i = 0; i < namArray.length; ++i) {
            namArray[i] = this.namesList.get(i) + "";
        }
        this.getDataDialog().setVariableNames(namArray);
        if (!this.noDialog) {
            this.getDataDialog().setVisible(true);
            if (this.getDataDialog().isCanceled()) {
                this.cancelled = true;
                return;
            }
        }
        int allCols = 0;
        int maxRows = 0;
        JSCNArray[] arrays = new JSCNArray[this.dataList.size()];
        for (int i = 0; i < this.dataList.size(); ++i) {
            arrays[i] = this.dataList.get(i);
            allCols += arrays[i].cols();
            int rows = arrays[i].rows();
            if (rows <= maxRows) continue;
            maxRows = rows;
        }
        double[][] values = UMatrix.multiply(new double[maxRows][allCols], Double.NaN);
        int colIndex = 0;
        for (int i = 0; i < arrays.length; ++i) {
            int j = 0;
            while (j < arrays[i].cols()) {
                for (int k = 0; k < arrays[i].rows(); ++k) {
                    values[k][colIndex] = arrays[i].doubleAt(k, j);
                }
                ++j;
                ++colIndex;
            }
        }
        this.symbolTable.set(new JSCNArray(TSImportTypes.DATA.name(), values));
        this.symbolTable.set(new JSCDate(TSImportTypes.STARTDATE.name(), this.getDataDialog().getTSDate()));
        this.symbolTable.set(new JSCString(TSImportTypes.DESCRIPTION.name(), description));
        StringTokenizer st = new StringTokenizer(this.getDataDialog().getVariableNames());
        String[] stringArray = new String[st.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = st.nextToken();
        }
        this.symbolTable.set(new JSCSArray(TSImportTypes.VARNAMES.name(), stringArray));
    }

    @Override
    public void exportTS(File file, TS[] ts, String description) {
        if (file == null) {
            throw new IllegalArgumentException("File argument was null.");
        }
        if (ts == null) {
            throw new IllegalArgumentException("Time series argument was null.");
        }
        if (ts.length == 0) {
            return;
        }
        TSDateRange mergedRange = TSDateRange.getMergedRange(ts);
        String[] names = new String[ts.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ts[i].name();
        }
        double[][] values = new double[mergedRange.numOfObs()][ts.length];
        for (int i = 0; i < mergedRange.numOfObs(); ++i) {
            TSDate currentDate = mergedRange.dateForIndex(i);
            for (int j = 0; j < ts.length; ++j) {
                values[i][j] = ts[j].valueAt(currentDate);
            }
        }
        this.export(values, names, description, file);
    }

    @Override
    public void exportData(File file, JSCData data, String description) {
        if (file == null) {
            throw new IllegalArgumentException("File argument was null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("Data argument was null.");
        }
        if (data.type() != JSCTypes.NARRAY) {
            throw new IllegalArgumentException("Data of type \"" + data.type() + "\" cannot be stored in Excel format.");
        }
        if (data.isEmpty()) {
            return;
        }
        JSCNArray narray = (JSCNArray)data;
        this.export(narray.doubleArray(), new String[]{narray.name()}, description, file);
    }

    private void writeDataHeader(DataOutputStream dataOut, int rows, int cols, String name) throws IOException {
        dataOut.writeInt(14);
        int numOfChars = name.length();
        int skip = TSMatlabHandler.skipPaddingBytes(null, 8, numOfChars);
        int arraySize = 8 * rows * cols;
        int numOfBytes = 40 + numOfChars + skip + 8 + arraySize;
        dataOut.writeInt(numOfBytes);
        dataOut.writeInt(6);
        dataOut.writeInt(8);
        byte[] toWrite = new byte[2];
        dataOut.write(toWrite);
        dataOut.writeByte(0);
        dataOut.writeByte(6);
        toWrite = new byte[4];
        dataOut.write(toWrite);
        dataOut.writeInt(5);
        dataOut.writeInt(8);
        dataOut.writeInt(rows);
        dataOut.writeInt(cols);
        dataOut.writeInt(1);
        dataOut.writeInt(numOfChars);
        dataOut.write(name.getBytes());
        toWrite = new byte[skip];
        dataOut.write(toWrite);
        dataOut.writeInt(9);
        dataOut.writeInt(arraySize);
    }

    private void deflateDataAndWrite(ByteArrayOutputStream byteOut, DataOutputStream out) throws IOException {
        Deflater compresser = new Deflater();
        compresser.setInput(byteOut.toByteArray());
        compresser.finish();
        int numOfCompressedBytes = 0;
        byte[] compressed = new byte[]{};
        int k = 0;
        while (!compresser.finished()) {
            if (k > 0) {
                compresser = new Deflater();
                compresser.setInput(byteOut.toByteArray());
                compresser.finish();
            }
            compressed = new byte[byteOut.size() + 100 * k];
            numOfCompressedBytes = compresser.deflate(compressed);
            ++k;
        }
        out.writeInt(15);
        out.writeInt(numOfCompressedBytes);
        out.write(compressed, 0, numOfCompressedBytes);
    }

    private void export(double[][] values, String[] names, String description, File file) {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
            byte[] toWrite = new byte[116];
            if (description == null) {
                description = "";
            }
            String des = "MATLAB 5.0 MAT-file, Created with JStatCom: " + CompSettings.getDateString() + ",\n" + description;
            byte[] sArray = des.getBytes();
            for (int j = 0; j < sArray.length && j < toWrite.length; ++j) {
                toWrite[j] = sArray[j];
            }
            out.write(toWrite);
            toWrite = new byte[8];
            out.write(toWrite);
            out.writeByte(1);
            out.writeByte(0);
            out.writeByte(77);
            out.writeByte(73);
            if (values[0].length == names.length) {
                for (int i = 0; i < names.length; ++i) {
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    DataOutputStream dataOut = new DataOutputStream(byteOut);
                    int rows = values.length;
                    this.writeDataHeader(dataOut, rows, 1, names[i]);
                    for (int j = 0; j < rows; ++j) {
                        dataOut.writeDouble(values[j][i]);
                    }
                    this.deflateDataAndWrite(byteOut, out);
                    dataOut.close();
                    byteOut.close();
                }
            } else {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                DataOutputStream dataOut = new DataOutputStream(byteOut);
                int rows = values.length;
                int cols = values[0].length;
                this.writeDataHeader(dataOut, rows, cols, names[0]);
                for (int i = 0; i < cols; ++i) {
                    for (int j = 0; j < rows; ++j) {
                        dataOut.writeDouble(values[j][i]);
                    }
                }
                this.deflateDataAndWrite(byteOut, out);
                dataOut.close();
                byteOut.close();
            }
            out.close();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void setTestMode(boolean noDialog) {
        this.noDialog = noDialog;
    }
}

