/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import com.jstatcom.component.TopFrameReference;
import com.jstatcom.io.DataHandler;
import com.jstatcom.io.ImportTypes;
import com.jstatcom.io.TSDataDialog;
import com.jstatcom.io.TSGaussFMTHandler;
import com.jstatcom.io.TSImportTypes;
import com.jstatcom.io.TSMatlabHandler;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDate;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSDateRange;
import com.jstatcom.util.UStringArray;
import java.awt.Frame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public final class TSGaussDATHandler
implements DataHandler {
    private boolean noDialog = false;
    private static final TSGaussDATHandler handler = new TSGaussDATHandler();
    private File selectedFile = null;
    private TSDataDialog dialog = null;
    private boolean canceled = false;
    private final SymbolTable symbolTable = new SymbolTable("TSGaussDATHandler", false);

    public static TSGaussDATHandler getInstance() {
        return handler;
    }

    private TSGaussDATHandler() {
    }

    @Override
    public boolean importData(File file) {
        return this.importData(file, true);
    }

    public boolean importData(File file, boolean showError) {
        if (file == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Invalid data file " + file + ".");
        }
        this.selectedFile = file;
        this.canceled = false;
        try {
            File dht;
            String dhtFile0;
            String dhtFile1 = dhtFile0 = this.selectedFile.getAbsolutePath();
            int index = dhtFile0.lastIndexOf(".");
            if (index > -1) {
                dhtFile0 = dhtFile0.substring(0, index) + ".dht";
                dhtFile1 = dhtFile1.substring(1, index) + ".DHT";
            }
            if (!(dht = new File(dhtFile0)).canRead()) {
                dht = new File(dhtFile1);
            }
            if (dht.canRead()) {
                DataInputStream dhtin = new DataInputStream(new FileInputStream(dht));
                int size = dhtin.available();
                byte[] header = new byte[size];
                dhtin.read(header);
                dhtin.close();
                if (header[0] == -38 && header[1] == -38) {
                    DataInputStream in = new DataInputStream(new FileInputStream(file));
                    dhtin = new DataInputStream(new FileInputStream(dht));
                    this.importSmallDATv89(in, dhtin);
                    in.close();
                    dhtin.close();
                    return !this.canceled;
                }
                if (header[0] == -38 && header[1] == -18 || header[0] == -18 && header[1] == -38) {
                    DataInputStream in = new DataInputStream(new FileInputStream(file));
                    dhtin = new DataInputStream(new FileInputStream(dht));
                    this.importExtendedDATv89(in, dhtin);
                    in.close();
                    dhtin.close();
                    return !this.canceled;
                }
                throw new RuntimeException("Unrecognized version from header file \"" + dht.getName() + "\".");
            }
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            int size = in.available();
            byte[] header = new byte[size];
            in.read(header);
            in.close();
            in = new DataInputStream(new FileInputStream(file));
            if (header[0] == -1) {
                this.importDATv96(in, header);
                in.close();
                return !this.canceled;
            }
            if (header[0] == 0) {
                this.importDATv92(in, header);
                in.close();
                return !this.canceled;
            }
            throw new RuntimeException("Unrecognized Gauss data set version (neiter v89, v92, v96).");
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    private void importSmallDATv89(DataInputStream in, DataInputStream dhtIn) throws IOException {
        int j;
        dhtIn.skipBytes(6);
        int cols = Short.reverseBytes(dhtIn.readShort());
        dhtIn.skipBytes(4);
        short type = Short.reverseBytes(dhtIn.readShort());
        dhtIn.skipBytes(8);
        byte[] flags = new byte[2];
        dhtIn.read(flags);
        boolean isComplex = flags[0] == 1;
        dhtIn.skipBytes(104);
        String[] names = new String[cols];
        for (int i = 0; i < names.length; ++i) {
            byte[] nam = new byte[8];
            dhtIn.read(nam);
            int length = 0;
            for (j = 0; j < nam.length; ++j) {
                if (nam[j] != 0) continue;
                length = j;
                break;
            }
            names[i] = new String(nam, 0, length).trim();
        }
        int rows = new Long(this.selectedFile.length() / (long)(type * cols)).intValue();
        double[][] val = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (j = 0; j < cols; ++j) {
                if (type == 2) {
                    val[i][j] = Double.longBitsToDouble(Short.reverseBytes(in.readShort()));
                }
                if (type == 4) {
                    val[i][j] = Double.longBitsToDouble(Integer.reverseBytes(in.readInt()));
                }
                if (type == 8) {
                    val[i][j] = Double.longBitsToDouble(Long.reverseBytes(in.readLong()));
                }
                if (!isComplex) continue;
                in.skipBytes(type);
            }
        }
        this.setDataToSymbolTable(val, names);
    }

    private void importExtendedDATv89(DataInputStream in, DataInputStream dhtIn) throws IOException {
        int j;
        dhtIn.skipBytes(2);
        short type = Short.reverseBytes(dhtIn.readShort());
        dhtIn.skipBytes(4);
        int cols = Integer.reverseBytes(dhtIn.readInt());
        dhtIn.skipBytes(16);
        byte[] flags = new byte[2];
        dhtIn.read(flags);
        boolean isComplex = flags[0] == 1;
        dhtIn.skipBytes(98);
        String[] names = new String[cols];
        for (int i = 0; i < names.length; ++i) {
            byte[] nam = new byte[8];
            dhtIn.read(nam);
            int length = 0;
            for (j = 0; j < nam.length; ++j) {
                if (nam[j] != 0) continue;
                length = j;
                break;
            }
            names[i] = new String(nam, 0, length).trim();
        }
        int rows = new Long(this.selectedFile.length() / (long)(type * cols)).intValue();
        double[][] val = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (j = 0; j < cols; ++j) {
                if (type == 2) {
                    val[i][j] = Double.longBitsToDouble(Short.reverseBytes(in.readShort()));
                }
                if (type == 4) {
                    val[i][j] = Double.longBitsToDouble(Integer.reverseBytes(in.readInt()));
                }
                if (type == 8) {
                    val[i][j] = Double.longBitsToDouble(Long.reverseBytes(in.readLong()));
                }
                if (!isComplex) continue;
                in.skipBytes(type);
            }
        }
        this.setDataToSymbolTable(val, names);
    }

    private void importDATv92(DataInputStream in, byte[] header) throws IOException {
        boolean isLittleEndian = header[4] == -54;
        in.skipBytes(20);
        int rows = in.readInt();
        if (isLittleEndian) {
            rows = Integer.reverseBytes(rows);
        }
        int cols = in.readInt();
        if (isLittleEndian) {
            cols = Integer.reverseBytes(cols);
        }
        int complex = in.readInt();
        if (isLittleEndian) {
            complex = Integer.reverseBytes(complex);
        }
        int type = in.readInt();
        if (isLittleEndian) {
            type = Integer.reverseBytes(type);
        }
        in.skipBytes(92);
        String[] names = new String[cols];
        for (int i = 0; i < names.length; ++i) {
            byte[] nam = new byte[8];
            in.read(nam);
            int length = 0;
            for (int j = 0; j < nam.length; ++j) {
                if (nam[j] != 0) continue;
                length = j;
                break;
            }
            names[i] = new String(nam, 0, length).trim();
        }
        int[] selNum = new int[cols];
        byte[] index = new byte[cols];
        in.read(index);
        for (int i = 0; i < cols; ++i) {
            selNum[i] = index[i];
        }
        TSMatlabHandler.skipPaddingBytes(in, 8, cols);
        names = UStringArray.selRowsIf(names, selNum);
        double[][] val = new double[rows][names.length];
        for (int i = 0; i < rows; ++i) {
            int colCounter = 0;
            for (int j = 0; j < cols; ++j) {
                if (selNum[j] == 1) {
                    if (isLittleEndian) {
                        if (type == 2) {
                            val[i][colCounter++] = Double.longBitsToDouble(Short.reverseBytes(in.readShort()));
                        }
                        if (type == 4) {
                            val[i][colCounter++] = Double.longBitsToDouble(Integer.reverseBytes(in.readInt()));
                        }
                        if (type == 8) {
                            val[i][colCounter++] = Double.longBitsToDouble(Long.reverseBytes(in.readLong()));
                        }
                    } else {
                        if (type == 2) {
                            val[i][colCounter++] = in.readShort();
                        }
                        if (type == 4) {
                            val[i][colCounter++] = in.readFloat();
                        }
                        if (type == 8) {
                            val[i][colCounter++] = in.readDouble();
                        }
                    }
                } else {
                    in.skipBytes(type);
                }
                if (complex != 1) continue;
                in.skipBytes(type);
            }
        }
        this.setDataToSymbolTable(val, names);
    }

    private void importDATv96(DataInputStream in, byte[] header) throws IOException {
        int j;
        boolean isLittleEndian = header[20] == 0;
        in.skipBytes(48);
        int type = in.readInt();
        if (isLittleEndian) {
            type = Integer.reverseBytes(type);
        }
        int complex = in.readInt();
        if (isLittleEndian) {
            complex = Integer.reverseBytes(complex);
        }
        int imagStyle = in.readInt();
        if (isLittleEndian) {
            imagStyle = Integer.reverseBytes(imagStyle);
        }
        in.skipBytes(4);
        int major = in.readInt();
        if (isLittleEndian) {
            major = Integer.reverseBytes(major);
        }
        in.skipBytes(12);
        int rows = in.readInt();
        if (isLittleEndian) {
            rows = Integer.reverseBytes(rows);
        }
        int cols = in.readInt();
        if (isLittleEndian) {
            cols = Integer.reverseBytes(cols);
        }
        in.skipBytes(40);
        String[] names = new String[cols];
        for (int i = 0; i < cols; ++i) {
            byte[] nam = new byte[32];
            in.read(nam);
            int length = 32;
            for (j = 0; j < nam.length; ++j) {
                if (nam[j] != 0) continue;
                length = j;
                break;
            }
            names[i] = new String(nam, 0, length).trim();
        }
        int[] selNum = new int[cols];
        byte[] index = new byte[cols];
        in.read(index);
        for (int i = 0; i < cols; ++i) {
            selNum[i] = index[i];
        }
        TSMatlabHandler.skipPaddingBytes(in, 8, cols);
        names = UStringArray.selRowsIf(names, selNum);
        double[][] val = new double[rows][names.length];
        if (major == 1) {
            for (int i = 0; i < rows; ++i) {
                int colCounter = 0;
                for (int j2 = 0; j2 < cols; ++j2) {
                    if (selNum[j2] == 1) {
                        if (isLittleEndian) {
                            if (type == 2) {
                                val[i][colCounter++] = Double.longBitsToDouble(Short.reverseBytes(in.readShort()));
                            }
                            if (type == 4) {
                                val[i][colCounter++] = Double.longBitsToDouble(Integer.reverseBytes(in.readInt()));
                            }
                            if (type == 8) {
                                val[i][colCounter++] = Double.longBitsToDouble(Long.reverseBytes(in.readLong()));
                            }
                        } else {
                            if (type == 2) {
                                val[i][colCounter++] = in.readShort();
                            }
                            if (type == 4) {
                                val[i][colCounter++] = in.readFloat();
                            }
                            if (type == 8) {
                                val[i][colCounter++] = in.readDouble();
                            }
                        }
                    } else {
                        in.skipBytes(type);
                    }
                    if (complex != 1 || imagStyle != 2) continue;
                    in.skipBytes(type);
                }
            }
        } else {
            int colCounter = 0;
            for (j = 0; j < cols; ++j) {
                if (selNum[j] == 1) {
                    for (int i = 0; i < rows; ++i) {
                        if (isLittleEndian) {
                            if (type == 2) {
                                val[i][colCounter] = Double.longBitsToDouble(Short.reverseBytes(in.readShort()));
                            }
                            if (type == 4) {
                                val[i][colCounter] = Double.longBitsToDouble(Integer.reverseBytes(in.readInt()));
                            }
                            if (type == 8) {
                                val[i][colCounter] = Double.longBitsToDouble(Long.reverseBytes(in.readLong()));
                            }
                        } else {
                            if (type == 2) {
                                val[i][colCounter] = in.readShort();
                            }
                            if (type == 4) {
                                val[i][colCounter] = in.readFloat();
                            }
                            if (type == 8) {
                                val[i][colCounter] = in.readDouble();
                            }
                        }
                        if (complex != 1 || imagStyle != 2) continue;
                        in.skipBytes(type);
                    }
                    ++colCounter;
                    continue;
                }
                in.skipBytes(rows * type);
            }
        }
        this.setDataToSymbolTable(val, names);
    }

    private void setDataToSymbolTable(double[][] values, String[] names) {
        this.getDataDialog().setVariableNames(names);
        if (!this.noDialog) {
            this.getDataDialog().setVisible(true);
            if (this.getDataDialog().isCanceled()) {
                this.canceled = true;
                return;
            }
        }
        this.symbolTable.set(new JSCNArray(TSImportTypes.DATA.name(), values));
        this.symbolTable.set(new JSCDate(TSImportTypes.STARTDATE.name(), this.getDataDialog().getTSDate()));
        if (values.length > 0) {
            names = TSGaussFMTHandler.getNamesArray(this.selectedFile, values[0].length, this.getDataDialog().getVariableNames());
        }
        this.symbolTable.set(new JSCSArray(TSImportTypes.VARNAMES.name(), names));
    }

    @Override
    public JSCData getData(ImportTypes type) {
        if (this.symbolTable == null) {
            throw new IllegalStateException("There was nothing imported yet.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        return this.symbolTable.getJSCData(new JSCTypeDef(type.name(), type.type()));
    }

    private TSDataDialog getDataDialog() {
        if (this.dialog == null) {
            this.dialog = new TSDataDialog((Frame)TopFrameReference.getTopFrameRef(), true);
        }
        this.dialog.setLocationRelativeTo(TopFrameReference.getTopFrameRef());
        return this.dialog;
    }

    @Override
    public void exportTS(File file, TS[] ts, String description) {
        if (file == null) {
            throw new IllegalArgumentException("File argument was null.");
        }
        if (ts == null) {
            throw new IllegalArgumentException("Time series argument was null.");
        }
        if (ts.length == 0) {
            return;
        }
        TSDateRange mergedRange = TSDateRange.getMergedRange(ts);
        String[] names = new String[ts.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ts[i].name();
        }
        double[][] values = new double[mergedRange.numOfObs()][ts.length];
        for (int i = 0; i < mergedRange.numOfObs(); ++i) {
            TSDate currentDate = mergedRange.dateForIndex(i);
            for (int j = 0; j < ts.length; ++j) {
                values[i][j] = ts[j].valueAt(currentDate);
            }
        }
        this.export(values, names, file);
    }

    @Override
    public void exportData(File file, JSCData data, String description) {
        if (file == null) {
            throw new IllegalArgumentException("File argument was null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("Data argument was null.");
        }
        if (data.type() != JSCTypes.NARRAY) {
            throw new IllegalArgumentException("Data of type \"" + data.type() + "\" cannot be stored in Excel format.");
        }
        if (data.isEmpty()) {
            return;
        }
        String[] names = new String[]{data.name()};
        JSCNArray narray = (JSCNArray)data;
        if (narray.cols() > 1) {
            names = new String[narray.cols()];
            String nam = narray.name();
            for (int i = 0; i < names.length; ++i) {
                names[i] = nam + "_" + (i + 1);
            }
        }
        this.export(narray.doubleArray(), names, file);
    }

    private void export(double[][] values, String[] names, File file) {
        try {
            int i;
            int i2;
            DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
            byte[] toWrite = new byte[40];
            for (i2 = 0; i2 < 4; ++i2) {
                toWrite[i2] = -1;
            }
            for (i2 = 4; i2 < 8; ++i2) {
                toWrite[i2] = 0;
            }
            for (i2 = 8; i2 < 12; ++i2) {
                toWrite[i2] = -1;
            }
            for (i2 = 12; i2 < 16; ++i2) {
                toWrite[i2] = 0;
            }
            for (i2 = 16; i2 < 20; ++i2) {
                toWrite[i2] = -1;
            }
            for (i2 = 20; i2 < 24; ++i2) {
                toWrite[i2] = -1;
            }
            for (i2 = 24; i2 < 28; ++i2) {
                toWrite[i2] = 0;
            }
            toWrite[28] = -85;
            toWrite[29] = -51;
            toWrite[30] = -17;
            toWrite[31] = 2;
            toWrite[32] = 0;
            toWrite[33] = 0;
            toWrite[34] = 0;
            toWrite[35] = 1;
            out.write(toWrite);
            out.writeInt(1);
            out.writeInt(1008);
            out.writeInt(8);
            out.writeInt(0);
            out.writeInt(1);
            out.writeInt(2);
            out.writeInt(1);
            out.writeInt(0);
            int info = names.length * 33;
            int toSkip = TSMatlabHandler.skipPaddingBytes(null, 8, names.length);
            int headerSize = 128 + info + toSkip;
            out.writeInt(headerSize);
            toWrite = new byte[4];
            out.write(toWrite);
            out.writeInt(values.length);
            out.writeInt(names.length);
            toWrite = new byte[40];
            out.write(toWrite);
            for (i = 0; i < names.length; ++i) {
                byte[] sArray = names[i].getBytes();
                byte[] aName = new byte[32];
                for (int j = 0; j < sArray.length && j < aName.length; ++j) {
                    aName[j] = sArray[j];
                }
                out.write(aName);
            }
            for (i = 0; i < names.length; ++i) {
                out.writeByte(1);
            }
            toWrite = new byte[toSkip];
            out.write(toWrite);
            for (i = 0; i < values.length; ++i) {
                for (int j = 0; j < values[0].length; ++j) {
                    out.writeDouble(values[i][j]);
                }
            }
            out.close();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void setTestMode(boolean noDialog) {
        this.noDialog = noDialog;
    }
}

