/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import com.jstatcom.component.TopFrameReference;
import com.jstatcom.io.DataHandler;
import com.jstatcom.io.FileSupport;
import com.jstatcom.io.ImportTypes;
import com.jstatcom.io.TSDataDialog;
import com.jstatcom.io.TSGaussDATHandler;
import com.jstatcom.io.TSImportTypes;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDate;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCString;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSDateRange;
import com.jstatcom.util.UString;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class TSASCIIHandler
implements DataHandler {
    private boolean noDialog = false;
    private String contents = null;
    private ArrayList<Double> observations = null;
    private TSDate startDate = null;
    private TSDataDialog dialog = null;
    private double[] startInfo = new double[3];
    private String[] names = null;
    private String description = null;
    private boolean observationsOnly = false;
    private String fileName = null;
    private boolean canceled = false;
    private final SymbolTable symbolTable = new SymbolTable("TSASCIIHandler", false);
    private static final TSASCIIHandler handler = new TSASCIIHandler();

    private TSASCIIHandler() {
    }

    public static TSASCIIHandler getInstance() {
        return handler;
    }

    @Override
    public boolean importData(File dataFile) {
        if (dataFile == null || !dataFile.isFile()) {
            throw new IllegalArgumentException("Invalid data file " + dataFile + ".");
        }
        this.symbolTable.clear();
        this.startDate = null;
        this.contents = "";
        this.startInfo = new double[3];
        try {
            this.parseContents(this.readFile(dataFile), dataFile);
        }
        catch (Throwable t) {
            TSGaussDATHandler handler = TSGaussDATHandler.getInstance();
            boolean rtn = false;
            try {
                rtn = handler.importData(dataFile, false);
            }
            catch (Throwable e) {
                throw new RuntimeException(t.getMessage() + "\nAlso tried to parse it as Gauss data set (binary) without success.");
            }
            if (rtn) {
                this.symbolTable.set(TSImportTypes.DATA.name(), handler.getData(TSImportTypes.DATA));
                this.symbolTable.set(TSImportTypes.STARTDATE.name(), handler.getData(TSImportTypes.STARTDATE));
                this.symbolTable.set(TSImportTypes.VARNAMES.name(), handler.getData(TSImportTypes.VARNAMES));
            }
            return false;
        }
        return !this.symbolTable.isEmpty();
    }

    @Override
    public JSCData getData(ImportTypes type) {
        if (this.symbolTable == null) {
            throw new IllegalStateException("There was nothing imported yet.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        return this.symbolTable.getJSCData(new JSCTypeDef(type.name(), type.type()));
    }

    private TSDataDialog getDataDialog() {
        if (this.dialog == null) {
            this.dialog = new TSDataDialog((Frame)TopFrameReference.getTopFrameRef(), true);
        }
        this.dialog.setLocationRelativeTo(TopFrameReference.getTopFrameRef());
        return this.dialog;
    }

    private void parseTokens(String token, int tokenIndex) {
        token = token.replaceAll(",", ".");
        if (this.startDate != null) {
            this.parseTokensDAT2(token, tokenIndex);
        } else {
            this.parseTokensDAT1_RAW(token, tokenIndex);
        }
    }

    private void parseTokensDAT2(String token, int tokenIndex) {
        Double val = UString.parseToNumber(token);
        if (tokenIndex == 0) {
            if (val != null) {
                this.observationsOnly = true;
            }
            String numTest = this.contents.substring(0, this.contents.indexOf("\n"));
            StringTokenizer st0 = new StringTokenizer(numTest);
            this.startInfo[0] = st0.countTokens();
            if (this.startInfo[0] < 1.0) {
                throw new RuntimeException("Invalid number of variables " + this.startInfo[0] + ".");
            }
            this.names = new String[(int)this.startInfo[0]];
            if (this.fileName.indexOf(46) > -1) {
                this.fileName = this.fileName.substring(0, this.fileName.lastIndexOf(".")) + "_";
            }
            if (JSCConstants.isValidName(this.fileName) != null) {
                this.fileName = "var_";
            }
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i] = this.fileName + (i + 1);
            }
        }
        if (this.observationsOnly) {
            if (val == null) {
                throw new RuntimeException("Token \"" + token + "\" could not be parsed to a number.");
            }
            this.observations.add(val);
            return;
        }
        if (!this.observationsOnly && tokenIndex >= 0 && (double)tokenIndex < this.startInfo[0]) {
            if (val == null) {
                if (JSCConstants.isValidName(token) == null) {
                    this.names[tokenIndex] = token;
                }
            } else {
                this.observationsOnly = true;
                this.observations.add(val);
                return;
            }
            if ((double)tokenIndex == this.startInfo[0] - 1.0) {
                this.observationsOnly = true;
            }
        }
    }

    private void parseTokensDAT1_RAW(String token, int tokenIndex) {
        Double val = UString.parseToNumber(token);
        if (tokenIndex < 3) {
            if (val == null) {
                throw new RuntimeException("Token:\n\"" + token.substring(0, token.length() < 128 ? token.length() : 64) + "\"\ncould not be parsed to a number.");
            }
            this.startInfo[tokenIndex] = val;
            return;
        }
        if (tokenIndex == 3) {
            if (val != null) {
                this.observationsOnly = true;
                this.observations.add(new Double(this.startInfo[0]));
                this.observations.add(new Double(this.startInfo[1]));
                this.observations.add(new Double(this.startInfo[2]));
                if (!this.noDialog) {
                    this.getDataDialog().setVisible(true);
                    if (this.getDataDialog().isCanceled()) {
                        this.canceled = true;
                        return;
                    }
                }
                this.startDate = this.getDataDialog().getTSDate();
                this.startInfo[1] = -1.0;
                this.startInfo[2] = -1.0;
                String numTest = this.contents.substring(0, this.contents.indexOf("\n"));
                StringTokenizer st0 = new StringTokenizer(numTest);
                this.startInfo[0] = st0.countTokens();
            }
            if (this.startInfo[0] < 1.0) {
                throw new RuntimeException("Invalid number of variables " + this.startInfo[0] + ".");
            }
            this.names = new String[(int)this.startInfo[0]];
            if (this.fileName.indexOf(46) > -1) {
                this.fileName = this.fileName.substring(0, this.fileName.lastIndexOf(".")) + "_";
            }
            if (JSCConstants.isValidName(this.fileName) != null) {
                this.fileName = "var_";
            }
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i] = this.fileName + (i + 1);
            }
            if (this.observationsOnly) {
                this.setNamesFromDialog(this.getDataDialog().getVariableNames());
            }
        }
        if (this.observationsOnly) {
            if (val == null) {
                throw new RuntimeException("Token \"" + token + "\" could not be parsed to a number.");
            }
            this.observations.add(val);
            return;
        }
        if (!this.observationsOnly && tokenIndex > 2 && (double)tokenIndex < this.startInfo[0] + 3.0) {
            if (val == null) {
                if (JSCConstants.isValidName(token) == null) {
                    this.names[tokenIndex - 3] = token;
                }
            } else {
                this.observationsOnly = true;
                this.observations.add(val);
                return;
            }
            if ((double)tokenIndex == this.startInfo[0] + 2.0) {
                this.observationsOnly = true;
            }
        }
    }

    private void setNamesFromDialog(String namesFromDialog) {
        StringTokenizer st = new StringTokenizer(namesFromDialog);
        String[] stringArray = new String[st.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = st.nextToken();
        }
        int length = stringArray.length;
        if (this.names.length < stringArray.length) {
            length = this.names.length;
        }
        for (int i = 0; i < length; ++i) {
            if (JSCConstants.isValidName(stringArray[i]) != null) continue;
            this.names[i] = stringArray[i];
        }
    }

    private void parseContents(String[] stringArray, File file) {
        this.observations = new ArrayList();
        this.observationsOnly = false;
        this.names = null;
        this.fileName = file.getName();
        this.canceled = false;
        int index = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringArray[i] = stringArray[i].trim();
            if (stringArray[i].length() > 0) {
                this.parseTokens(stringArray[i], index++);
            }
            if (!this.canceled) continue;
            return;
        }
        if (this.startDate == null) {
            this.startDate = new TSDate(this.startInfo[1], (int)this.startInfo[2]);
        }
        if (this.observations.size() == 0) {
            throw new RuntimeException("File contains no numbers.");
        }
        if (this.startInfo[0] < 1.0) {
            throw new RuntimeException("Invalid number of variables " + this.startInfo[0] + ".");
        }
        double[][] values = new double[(int)((double)this.observations.size() / this.startInfo[0])][(int)this.startInfo[0]];
        int index2 = 0;
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[0].length; ++j) {
                values[i][j] = this.observations.get(index2++);
            }
        }
        this.symbolTable.set(new JSCNArray(TSImportTypes.DATA.name(), values));
        this.symbolTable.set(new JSCDate(TSImportTypes.STARTDATE.name(), this.startDate));
        this.symbolTable.set(new JSCSArray(TSImportTypes.VARNAMES.name(), this.names));
        this.symbolTable.set(new JSCString(TSImportTypes.DESCRIPTION.name(), this.description.trim()));
    }

    private String[] readFile(File file) {
        String str = null;
        StringBuffer buffer = new StringBuffer();
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                if (str.length() <= 0) continue;
                buffer.append(str.trim() + "\n");
            }
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        int descriptionStart = buffer.indexOf("/*");
        StringBuffer des = new StringBuffer();
        while (descriptionStart > -1) {
            int descriptionEnd = buffer.indexOf("*/");
            if (descriptionEnd < descriptionStart + 2) {
                throw new RuntimeException("There is an open comment /*.");
            }
            des.append(buffer.substring(descriptionStart + 2, descriptionEnd));
            buffer = buffer.delete(descriptionStart, descriptionEnd + 2);
            descriptionStart = buffer.indexOf("/*");
        }
        this.description = des.toString();
        this.contents = buffer.toString().trim() + "\n";
        buffer = new StringBuffer(this.contents);
        String dateString = "";
        if (this.contents.startsWith("<")) {
            int index = this.contents.indexOf(">");
            dateString = this.contents.substring(1, index);
            this.contents = this.contents.substring(index + 1).trim() + "\n";
            this.startDate = TSDate.valueOf(dateString);
        }
        StringTokenizer st = new StringTokenizer(this.contents);
        String[] stringArray = new String[st.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = st.nextToken();
        }
        return stringArray;
    }

    @Override
    public void exportTS(File file, TS[] ts, String description) {
        int i;
        if (file == null) {
            throw new IllegalArgumentException("File argument was null.");
        }
        if (ts == null) {
            throw new IllegalArgumentException("Time series argument was null.");
        }
        if (ts.length == 0) {
            return;
        }
        if (description == null) {
            description = "";
        }
        StringBuffer buffer = new StringBuffer();
        if (description.length() > 0) {
            buffer.append("/*\r\n" + description + "\r\n*/\r\n");
        }
        TSDateRange mergedRange = TSDateRange.getMergedRange(ts);
        buffer.append("<" + mergedRange.lowerBound() + ">");
        buffer.append("\n");
        for (i = 0; i < ts.length; ++i) {
            buffer.append(ts[i].name() + "  ");
        }
        buffer.append("\n");
        for (i = 0; i < mergedRange.numOfObs(); ++i) {
            TSDate currentDate = mergedRange.dateForIndex(i);
            for (int j = 0; j < ts.length; ++j) {
                buffer.append(ts[j].valueAt(currentDate) + "  ");
            }
            buffer.append("\n");
        }
        String toWrite = buffer.toString().replaceAll("\n", "\r\n");
        FileSupport.getInstance().saveStringToFile(file, toWrite, false);
    }

    @Override
    public void exportData(File file, JSCData data, String description) {
        if (file == null) {
            throw new IllegalArgumentException("File argument was null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("Data argument was null.");
        }
        if (data.isEmpty()) {
            return;
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            String toSave = data.display();
            PrintStream pStream = new PrintStream(out);
            if (description != null) {
                pStream.print("/*\r\n" + description + "\r\n*/\r\n");
            }
            pStream.print(toSave);
            out.flush();
            out.close();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void setTestMode(boolean noDialog) {
        this.noDialog = noDialog;
    }
}

