/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import com.jstatcom.io.DataHandlerTypes;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.filechooser.FileFilter;

public final class ExtensionFileFilter
extends FileFilter {
    private DataHandlerTypes type = null;
    private Map<String, ExtensionFileFilter> filters = new HashMap<String, ExtensionFileFilter>();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public ExtensionFileFilter() {
    }

    public ExtensionFileFilter(String[] filters) {
        this(filters, null);
    }

    public ExtensionFileFilter(String[] filters, String description) {
        this();
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public ExtensionFileFilter(String extension) {
        this(extension, null);
    }

    public ExtensionFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public ExtensionFileFilter(String extension, String description, DataHandlerTypes type) {
        this(extension, description);
        this.type = type;
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filters.get(this.getExtension(f)) != null) {
                return true;
            }
        }
        return false;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new HashMap<String, ExtensionFileFilter>(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Iterator<String> extensions = this.filters.keySet().iterator();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "." + extensions.next();
                    while (extensions.hasNext()) {
                        this.fullDescription = this.fullDescription + ", " + extensions.next();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public DataHandlerTypes getHandlerType() {
        return this.type;
    }
}

