/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.io;

import java.util.List;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;

public final class ExcelHelper {
    public static double[][] extractNumberArray(Workbook w, int sheetIndex, boolean firstAsDateCol, List<Object> firstColList, List<String> labelsList) {
        if (w == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (sheetIndex < 0) {
            throw new IllegalArgumentException("Sheet index < 0.");
        }
        int sheetNum = w.getNumberOfSheets();
        String[] sheetNames = w.getSheetNames();
        if (sheetIndex >= sheetNum) {
            throw new IllegalArgumentException("Specified sheet index " + sheetIndex + " not contained.");
        }
        Sheet s = w.getSheet(sheetIndex);
        int highestIndex = ExcelHelper.getHighestIndexWithNumber(s);
        if (highestIndex < 0) {
            throw new RuntimeException("Excel sheet \"" + sheetNames[sheetIndex] + "\" contains no numbers.");
        }
        int lowestIndex = ExcelHelper.getLowestIndexWithNumber(s);
        int dataLength = highestIndex - lowestIndex + 1;
        int first = firstAsDateCol ? 1 : 0;
        int dataCols = s.getColumns() - first;
        double[][] data = new double[dataLength][dataCols];
        for (int i = first; i < s.getColumns(); ++i) {
            Cell[] col = s.getColumn(i);
            for (int j = lowestIndex; j <= highestIndex; ++j) {
                data[j - lowestIndex][i - first] = j < col.length && (col[j].getType() == CellType.NUMBER || col[j].getType() == CellType.NUMBER_FORMULA) ? ((NumberCell)col[j]).getValue() : Double.NaN;
            }
            if (labelsList == null) continue;
            String toAdd = "var" + (i + 1);
            for (int j = 0; j < col.length; ++j) {
                if (col[j].getType() != CellType.LABEL) continue;
                toAdd = col[j].getContents().trim();
                break;
            }
            labelsList.add(toAdd);
        }
        Cell[] firstColCells = s.getColumn(0);
        if (firstAsDateCol && firstColList != null) {
            for (int j = lowestIndex; j <= highestIndex; ++j) {
                if (firstColCells[j].getType() == CellType.DATE) {
                    firstColList.add(((DateCell)firstColCells[j]).getDate());
                    continue;
                }
                firstColList.add(firstColCells[j].getContents());
            }
        }
        return data;
    }

    private static int getHighestIndexWithNumber(Sheet s) {
        if (s == null) {
            throw new IllegalArgumentException("Sheet was null.");
        }
        int highestIndex = -1;
        block0: for (int i = 0; i < s.getColumns(); ++i) {
            Cell[] col = s.getColumn(i);
            for (int j = col.length - 1; j >= 0; --j) {
                if (col[j].getType() != CellType.NUMBER && col[j].getType() != CellType.NUMBER_FORMULA) continue;
                if (highestIndex >= j) continue block0;
                highestIndex = j;
                continue block0;
            }
        }
        return highestIndex;
    }

    private static int getLowestIndexWithNumber(Sheet s) {
        if (s == null) {
            throw new IllegalArgumentException("Sheet was null.");
        }
        int lowestIndex = s.getRows();
        block0: for (int i = 0; i < s.getColumns(); ++i) {
            Cell[] col = s.getColumn(i);
            for (int j = 0; j < col.length; ++j) {
                if (col[j].getType() != CellType.NUMBER && col[j].getType() != CellType.NUMBER_FORMULA) continue;
                if (j >= lowestIndex) continue block0;
                lowestIndex = j;
                continue block0;
            }
        }
        return lowestIndex;
    }
}

