/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.equation;

import com.jstatcom.component.MatrixBorder;
import com.jstatcom.equation.CoeffTable;
import com.jstatcom.table.JSCCellRendererTypes;
import com.jstatcom.table.JSCSArrayTable;
import javax.swing.event.TableModelEvent;

public final class VarNamesVector
extends JSCSArrayTable {
    public static final String VARIABLE_NAME_CONSTANT = "CONST";
    public static final String VARIABLE_NAME_TREND = "TREND";
    private int index;
    private CoeffTable coeffTable = null;
    private boolean showingTimeIndex = true;

    public VarNamesVector() {
        this(0);
    }

    public VarNamesVector(int index) {
        this.index = index;
        this.setBorder(new MatrixBorder());
        this.setCellRenderer(JSCCellRendererTypes.VARIABLE_NAMES);
        this.setRowSelectionAllowed(false);
        this.setDynamicColumnWidth(true);
    }

    public int getIndex() {
        return this.index;
    }

    public String getIndexString() {
        String str = this.index == 0 ? "(t)" : "(t" + (this.index < 0 ? "" + this.index : "+" + this.index) + ")";
        return str;
    }

    public boolean isShowingTimeIndex() {
        return this.showingTimeIndex;
    }

    public void setCoeffTable(CoeffTable newCoeffTable) {
        this.coeffTable = newCoeffTable;
    }

    public void setIndex(int newIndex) {
        this.index = newIndex;
    }

    public void setShowingTimeIndex(boolean isShowingTimeIndex) {
        this.showingTimeIndex = isShowingTimeIndex;
    }

    @Override
    public void setVisible(boolean aFlag) {
        boolean oldValue = this.isVisible();
        super.setVisible(aFlag);
        this.firePropertyChange("visible", oldValue, this.isVisible());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.getColumnCount() < 1 && this.isVisible()) {
            this.setVisible(false);
        }
        if (this.getColumnCount() > 0 && !this.isVisible()) {
            this.setVisible(true);
        }
        if (this.coeffTable != null) {
            this.coeffTable.setColumnCount(this.getRowCount());
        }
    }
}

