/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.equation;

import com.jstatcom.equation.CoeffTable;
import com.jstatcom.equation.EqTerm;
import com.jstatcom.equation.VarNamesVector;
import com.jstatcom.model.Scope;
import com.jstatcom.table.JSCPopupTypes;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;

public class EqTermDefault
extends EqTerm
implements PropertyChangeListener {
    private CoeffTable coeff;
    private VarNamesVector variables;
    private JLabel leadingSign;
    private boolean coeffMatRequired = false;
    private MouseListener mouseListenerCoeff = null;
    private JPopupMenu tablePopup = JSCPopupTypes.PRECISION;
    private MouseListener triggerPopUp = null;

    public EqTermDefault() {
        this(-1, 0);
    }

    public EqTermDefault(int subMatrixIndex) {
        this(subMatrixIndex, 0);
    }

    public EqTermDefault(int subMatrixIndex, int lagIndex) {
        super(new FlowLayout(0, 0, 0));
        this.leadingSign = new JLabel(" + ");
        this.coeff = new CoeffTable(subMatrixIndex);
        this.coeff.setVisible(false);
        this.variables = new VarNamesVector(lagIndex);
        this.variables.setCoeffTable(this.coeff);
        this.variables.setVisible(false);
        this.coeff.addPropertyChangeListener(this);
        this.variables.addPropertyChangeListener(this);
        this.add(this.leadingSign);
        this.add(this.coeff);
        this.add(this.variables);
        this.coeff.setTablePopup(null);
        this.setTablePopup(this.tablePopup);
    }

    public int getColumnWidth() {
        return this.coeff.getColumnWidth();
    }

    public int getLagIndex() {
        return this.variables.getIndex();
    }

    public MouseListener getMouseListenerCoeff() {
        return this.mouseListenerCoeff;
    }

    public int getPrecision() {
        return this.coeff.getPrecision();
    }

    public TableCellRenderer getRendererCoeff() {
        return this.coeff.getCellRenderer();
    }

    public String getSymbolNameCoeff() {
        return this.coeff.getSymbolName();
    }

    public String getSymbolNameSubsetRes() {
        return this.coeff.getSymbolNameSubsetRes();
    }

    public String getSymbolNameVariables() {
        return this.variables.getSymbolName();
    }

    public JPopupMenu getTablePopup() {
        return this.tablePopup;
    }

    public boolean isCoeffMatRequired() {
        return this.coeffMatRequired;
    }

    public boolean isEditable() {
        return this.coeff.isEditable();
    }

    public boolean isMatrixCentered() {
        return this.getLayout() instanceof FlowLayout;
    }

    public boolean isShowingTimeIndex() {
        return this.variables.isShowingTimeIndex();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "visible") {
            boolean b = true;
            if (this.coeffMatRequired) {
                b = this.coeff.isVisible();
            }
            boolean bl = b = b && this.variables.isVisible();
            if (b != this.isVisible()) {
                this.setDataAvailable(b);
            }
        }
    }

    public void setCoeffMatRequired(boolean isCoeffMatRequired) {
        this.coeffMatRequired = isCoeffMatRequired;
    }

    public void setColumnWidth(int colWidth) {
        this.coeff.setColumnWidth(colWidth);
    }

    public void setEditable(boolean isEditable) {
        this.coeff.setEditable(isEditable);
    }

    public void setLagIndex(int index) {
        this.variables.setIndex(index);
    }

    @Override
    public void setLeadingSignVisible(boolean isVisible) {
        this.leadingSign.setVisible(isVisible);
    }

    public void setMatrixCentered(boolean centered) {
        if (centered) {
            this.setLayout(new FlowLayout(0, 0, 0));
        } else {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 3;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            gridBagLayout.setConstraints(this.leadingSign, c);
            c.fill = 0;
            c.gridx = 1;
            c.anchor = 11;
            gridBagLayout.setConstraints(this.coeff, c);
            c.gridx = 2;
            c.anchor = 11;
            gridBagLayout.setConstraints(this.variables, c);
        }
    }

    public void setMouseListenerCoeff(MouseListener listener) {
        this.coeff.setMouseListener(listener);
        this.mouseListenerCoeff = listener;
    }

    public void setPrecision(int precision) {
        this.coeff.setPrecision(precision);
    }

    public void setRendererCoeff(TableCellRenderer renderer) {
        this.coeff.setCellRenderer(renderer);
    }

    public void setShowingTimeIndex(boolean isShowingTimeIndex) {
        this.variables.setShowingTimeIndex(isShowingTimeIndex);
    }

    public void setSymbolNameCoeff(String symbolName) {
        this.coeff.setSymbolName(symbolName);
    }

    public void setSymbolNameSubsetRes(String symbolName) {
        this.coeff.setSymbolNameSubsetRes(symbolName);
    }

    public void setSymbolNameVariables(String symbolName) {
        this.variables.setSymbolName(symbolName);
    }

    public void setTablePopup(JPopupMenu newTablePopup) {
        this.tablePopup = newTablePopup;
        if (this.tablePopup == null) {
            this.coeff.removeMouseListener(this.triggerPopUp);
        } else {
            this.triggerPopUp = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    EqTermDefault.this.tablePopup.processMouseEvent(e, null, null);
                }
            };
            this.coeff.addMouseListener(this.triggerPopUp);
        }
    }

    @Override
    public void setSymbolScope(Scope scope) {
        super.setSymbolScope(scope);
        this.coeff.setSymbolScope(scope);
        this.variables.setSymbolScope(scope);
    }
}

