/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.mlab;

import com.jstatcom.engine.CFunc;
import com.jstatcom.engine.CMalloc;
import com.jstatcom.engine.CPtr;
import com.jstatcom.engine.ConfigHolder;
import com.jstatcom.engine.Engine;
import com.jstatcom.engine.EngineTypes;
import com.jstatcom.engine.LoadTypes;
import com.jstatcom.engine.mlab.StubMlabConfigKeys;
import com.jstatcom.engine.mlab.StubMlabLoadTypes;
import com.jstatcom.model.AbstractJSCData;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCInt;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCNumber;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCString;
import com.jstatcom.model.JSCTypes;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public final class StubMlabEngine
implements Engine {
    private static final Logger log = Logger.getLogger(StubMlabEngine.class);
    private final ConfigHolder cf;
    private final List<CPtr> pointerHolder = new ArrayList<CPtr>();
    private static StubMlabEngine mlab = null;
    private String mlabLib = null;
    private String systemLib = null;
    private String modName = null;

    private CPtr getSArrayPtr(JSCSArray sArray) {
        String[] values = new String[sArray.rows() * sArray.cols()];
        int index = 0;
        for (int j = 0; j < sArray.cols(); ++j) {
            for (int k = 0; k < sArray.rows(); ++k) {
                String el = sArray.stringAt(k, j);
                if (el == null) {
                    throw new IllegalArgumentException("Argument " + sArray.name() + " contains null element at index [" + k + "," + j + "].");
                }
                values[index++] = el;
            }
        }
        CMalloc argPtr = new CMalloc(CPtr.SIZE * values.length);
        this.pointerHolder.add(argPtr);
        CMalloc[] argsi = new CMalloc[values.length];
        for (int j = 0; j < values.length; ++j) {
            argsi[j] = new CMalloc(values[j].length() + 1);
            this.pointerHolder.add(argsi[j]);
            argsi[j].setString(0, values[j]);
            argPtr.setCPtr(CPtr.SIZE * j, argsi[j]);
        }
        return argPtr;
    }

    private StubMlabEngine() {
        this.cf = ConfigHolder.valueOf(EngineTypes.MLAB);
        String compiler_version = this.cf.getConfig(StubMlabConfigKeys.MATLAB_COMPILER_VERSION);
        String libname = "jmlab_v3";
        if (compiler_version.startsWith("4")) {
            libname = "jmlab_v4";
            throw new RuntimeException("Currently Matlab compiler version 4.0 generated dlls cannot be called due to lack of JNI support.");
        }
        this.mlabLib = EngineTypes.MLAB.DIR_NAME + File.separator + System.mapLibraryName(libname);
        File f = new File(this.mlabLib);
        if (!f.isFile()) {
            throw new RuntimeException("The system library " + f.getAbsolutePath() + " does not exist.");
        }
        String mlabPathLib = EngineTypes.MLAB.DIR_NAME + File.separator + System.mapLibraryName("jmlabpath");
        f = new File(mlabPathLib);
        if (!f.isFile()) {
            throw new RuntimeException("The system library " + f.getAbsolutePath() + " does not exist.");
        }
        Runtime.getRuntime().load(f.getAbsolutePath());
        if (!compiler_version.startsWith("4")) {
            return;
        }
        CFunc mlabInitCall = new CFunc(this.mlabLib, "jmlab_init");
        if (mlabInitCall.callInt(new Object[0]) < 0) {
            throw new RuntimeException("Could not initialize Matlab via \"mclInitializeApplication\".");
        }
    }

    public static StubMlabEngine getInstance() {
        if (mlab == null) {
            mlab = new StubMlabEngine();
        }
        return mlab;
    }

    @Override
    public void call(String procName, JSCData[] args, JSCData[] retData) {
        if (this.systemLib == null) {
            throw new IllegalStateException("No system library was loaded.");
        }
        if (procName == null || procName.length() == 0) {
            throw new IllegalArgumentException("Procedure name was empty.");
        }
        if (args == null) {
            args = new JSCData[]{};
        }
        if (retData == null) {
            retData = new JSCData[]{};
        }
        procName = procName.toLowerCase();
        String procFunc = "mlx" + procName.substring(0, 1).toUpperCase() + procName.substring(1);
        String initFunc = this.modName + "Initialize";
        String terminateFunc = this.modName + "Terminate";
        CFunc funcPtr = null;
        CFunc initPtr = null;
        CFunc terminatePtr = null;
        String current = null;
        try {
            current = initFunc;
            try {
                initPtr = new CFunc(this.systemLib, current);
            }
            catch (Throwable t) {
                current = "_" + current;
                initPtr = new CFunc(this.systemLib, current);
            }
            current = procFunc;
            try {
                funcPtr = new CFunc(this.systemLib, current);
            }
            catch (Throwable t) {
                current = "_" + current;
                funcPtr = new CFunc(this.systemLib, current);
            }
            current = terminateFunc;
            try {
                terminatePtr = new CFunc(this.systemLib, current);
            }
            catch (Throwable t) {
                current = "_" + current;
                terminatePtr = new CFunc(this.systemLib, current);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("The procedure\n\"" + current + "\"\ncould not be found in library\n" + this.systemLib);
        }
        CPtr[] argArray = this.prepareInputArgs(args);
        CPtr[] retArray = this.prepareOutputArgs(retData);
        CMalloc outMxPtr = new CMalloc(CPtr.SIZE * retArray.length);
        this.pointerHolder.add(outMxPtr);
        for (int i = 0; i < retArray.length; ++i) {
            outMxPtr.setCPtr(CPtr.SIZE * i, retArray[i]);
        }
        CMalloc argMxPtr = new CMalloc(CPtr.SIZE * argArray.length);
        this.pointerHolder.add(argMxPtr);
        for (int i = 0; i < argArray.length; ++i) {
            argMxPtr.setCPtr(CPtr.SIZE * i, argArray[i]);
        }
        Object[] callObject = new Object[]{new Integer(retArray.length), outMxPtr, new Integer(argArray.length), argMxPtr};
        initPtr.callVoid(new Object[0]);
        funcPtr.callVoid(callObject);
        terminatePtr.callVoid(new Object[0]);
        for (int i = 0; i < retArray.length; ++i) {
            retArray[i] = outMxPtr.getCPtr(CPtr.SIZE * i);
        }
        this.getDataFromPtr(retArray, retData);
        CFunc mlabCall = new CFunc(this.mlabLib, "jmlab_mxArrayFree");
        mlabCall.callVoid(new Object[]{new Integer(retArray.length), outMxPtr});
        mlabCall.callVoid(new Object[]{new Integer(argArray.length), argMxPtr});
        Iterator<CPtr> iter = this.pointerHolder.iterator();
        while (iter.hasNext()) {
            ((CMalloc)iter.next()).free();
        }
        this.pointerHolder.clear();
    }

    private CPtr[] prepareOutputArgs(JSCData[] args) {
        CPtr[] oArray = new CPtr[args.length];
        for (int i = 0; i < args.length; ++i) {
            CPtr mxPtr;
            if (args[i] == null) {
                throw new IllegalArgumentException("Return at array position [" + i + "] is null.");
            }
            JSCTypes type = args[i].type();
            if (!this.isValid(type)) {
                throw new IllegalArgumentException("Return " + args[i].type() + " at array position [" + i + "] cannot be handled by MLabEngine.");
            }
            oArray[i] = mxPtr = CPtr.NULL;
        }
        return oArray;
    }

    private CPtr[] prepareInputArgs(JSCData[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (args.length == 0) {
            return new CPtr[0];
        }
        CPtr[] oArray = new CPtr[args.length];
        for (int i = 0; i < args.length; ++i) {
            CPtr mxPtr;
            CFunc mlabCall;
            CPtr ptr;
            AbstractJSCData num;
            CPtr mxPtr2;
            CFunc mlabCall2;
            if (args[i] == null) {
                throw new IllegalArgumentException("Argument at array position [" + i + "] is null.");
            }
            JSCTypes type = args[i].type();
            if (!this.isValid(type)) {
                throw new IllegalArgumentException("Argument " + args[i].type() + " at array position [" + i + "] cannot be handled by MLabEngine.");
            }
            if (args[i].isEmpty()) {
                throw new IllegalArgumentException("Argument " + args[i].name() + " at array position [" + i + "] is empty.");
            }
            if (type == JSCTypes.STRING) {
                JSCString s = (JSCString)args[i];
                mlabCall2 = new CFunc(this.mlabLib, "jmlab_mxArrayForString");
                oArray[i] = mxPtr2 = mlabCall2.callCPtr(new Object[]{s.value()});
                continue;
            }
            if (type == JSCTypes.INT) {
                num = (JSCInt)args[i];
                mlabCall2 = new CFunc(this.mlabLib, "jmlab_mxArrayForInt");
                oArray[i] = mxPtr2 = mlabCall2.callCPtr(new Object[]{((JSCInt)num).value()});
                continue;
            }
            if (type == JSCTypes.NUMBER) {
                num = (JSCNumber)args[i];
                mlabCall2 = new CFunc(this.mlabLib, "jmlab_mxArrayForNumber");
                oArray[i] = mxPtr2 = mlabCall2.callCPtr(new Object[]{((JSCNumber)num).value()});
                continue;
            }
            if (type == JSCTypes.NARRAY) {
                JSCNArray nArray = (JSCNArray)args[i];
                ptr = this.getNArrayVecPtr(nArray);
                mlabCall = new CFunc(this.mlabLib, "jmlab_mxArrayForNArray");
                oArray[i] = mxPtr = mlabCall.callCPtr(new Object[]{ptr, new Integer(nArray.rows()), new Integer(nArray.cols())});
                continue;
            }
            if (type == JSCTypes.SARRAY) {
                JSCSArray sArray = (JSCSArray)args[i];
                ptr = this.getSArrayPtr(sArray);
                mlabCall = new CFunc(this.mlabLib, "jmlab_mxArrayForSArray");
                oArray[i] = mxPtr = mlabCall.callCPtr(new Object[]{ptr, new Integer(sArray.rows()), new Integer(sArray.cols())});
                continue;
            }
            throw new RuntimeException("Unsupported type " + type + ". Code should not be reached.");
        }
        return oArray;
    }

    private CPtr getNArrayVecPtr(JSCNArray nArray) {
        CMalloc argPtr = null;
        argPtr = new CMalloc(8 * nArray.cols() * nArray.rows());
        this.pointerHolder.add(argPtr);
        int index = 0;
        for (int i = 0; i < nArray.cols(); ++i) {
            for (int j = 0; j < nArray.rows(); ++j) {
                argPtr.setDouble(8 * index++, nArray.doubleAt(j, i));
            }
        }
        return argPtr;
    }

    private void getDataFromPtr(CPtr[] args, JSCData[] rtns) {
        if (args == null || rtns == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (args.length != rtns.length) {
            throw new IllegalArgumentException("Array lengths do not match.");
        }
        for (int i = 0; i < args.length; ++i) {
            AbstractJSCData num;
            CFunc mlabCall;
            if (rtns[i] == null) {
                throw new RuntimeException("Argument at index " + i + " was null.");
            }
            JSCTypes type = rtns[i].type();
            CPtr ptr = args[i];
            if (ptr.equals(CPtr.NULL)) {
                throw new RuntimeException("Pointer at index " + i + " was null.");
            }
            CFunc mlabCallEmpty = new CFunc(this.mlabLib, "jmlab_mxIsEmpty");
            if (mlabCallEmpty.callInt(new Object[]{ptr}) == 1) {
                rtns[i].clear();
                continue;
            }
            if (type == JSCTypes.NARRAY) {
                JSCNArray nArray = (JSCNArray)rtns[i];
                this.setNArrayFromPtr(nArray, ptr);
                continue;
            }
            if (type == JSCTypes.SARRAY) {
                JSCSArray sArray = (JSCSArray)rtns[i];
                this.setSArrayFromPtr(sArray, ptr);
                continue;
            }
            if (type == JSCTypes.STRING) {
                JSCString s = (JSCString)rtns[i];
                mlabCall = new CFunc(this.mlabLib, "jmlab_mxIsChar");
                if (mlabCall.callInt(new Object[]{ptr}) == 0) {
                    throw new RuntimeException("Return from matlab is not of type " + type + ".");
                }
                mlabCall = new CFunc(this.mlabLib, "jmlab_mxGetString");
                CPtr ret = mlabCall.callCPtr(new Object[]{ptr});
                s.setVal(ret.getString(0));
                continue;
            }
            if (type == JSCTypes.INT) {
                num = (JSCInt)rtns[i];
                mlabCall = new CFunc(this.mlabLib, "jmlab_mxIsNumber");
                if (mlabCall.callInt(new Object[]{ptr}) == 0) {
                    throw new RuntimeException("Return from matlab is not of type " + type + ".");
                }
                mlabCall = new CFunc(this.mlabLib, "jmlab_mxGetInt");
                int val = mlabCall.callInt(new Object[]{ptr});
                ((JSCInt)num).setVal(val);
                continue;
            }
            if (type != JSCTypes.NUMBER) continue;
            num = (JSCNumber)rtns[i];
            mlabCall = new CFunc(this.mlabLib, "jmlab_mxIsNumber");
            if (mlabCall.callInt(new Object[]{ptr}) == 0) {
                throw new RuntimeException("Return from matlab is not of type " + type + ".");
            }
            mlabCall = new CFunc(this.mlabLib, "jmlab_mxGetDouble");
            double val = mlabCall.callDouble(new Object[]{ptr});
            ((JSCNumber)num).setVal(val);
        }
    }

    private void setNArrayFromPtr(JSCNArray nArray, CPtr ptr) {
        CFunc mlabCall = new CFunc(this.mlabLib, "jmlab_mxIsNumber");
        if (mlabCall.callInt(new Object[]{ptr}) == 0) {
            throw new RuntimeException("Return from matlab for " + nArray.name() + " is not of type " + nArray.type() + ".");
        }
        mlabCall = new CFunc(this.mlabLib, "jmlab_mxGetRows");
        int rows = mlabCall.callInt(new Object[]{ptr});
        mlabCall = new CFunc(this.mlabLib, "jmlab_mxGetCols");
        int cols = mlabCall.callInt(new Object[]{ptr});
        mlabCall = new CFunc(this.mlabLib, "jmlab_mxGetRealDouble");
        CPtr ret = mlabCall.callCPtr(new Object[]{ptr});
        double[][] vals = new double[rows][cols];
        double[] values = new double[rows * cols];
        ret.copyOut(0, values, 0, values.length);
        int index = 0;
        for (int j = 0; j < cols; ++j) {
            for (int k = 0; k < rows; ++k) {
                vals[k][j] = values[index++];
            }
        }
        nArray.setVal(vals);
    }

    private void setSArrayFromPtr(JSCSArray sArray, CPtr ptr) {
        CFunc mlabCall = new CFunc(this.mlabLib, "jmlab_mxIsCell");
        if (mlabCall.callInt(new Object[]{ptr}) == 0) {
            throw new RuntimeException("Return from matlab for " + sArray.name() + " is not of type " + sArray.type() + ".");
        }
        mlabCall = new CFunc(this.mlabLib, "jmlab_mxGetRows");
        int rows = mlabCall.callInt(new Object[]{ptr});
        mlabCall = new CFunc(this.mlabLib, "jmlab_mxGetCols");
        int cols = mlabCall.callInt(new Object[]{ptr});
        String[][] vals = new String[rows][cols];
        mlabCall = new CFunc(this.mlabLib, "jmlab_mxGetSArray");
        CPtr ret = mlabCall.callCPtr(new Object[]{ptr});
        int index = 0;
        for (int j = 0; j < cols; ++j) {
            for (int k = 0; k < rows; ++k) {
                CPtr ptri = ret.getCPtr(CPtr.SIZE * index++);
                vals[k][j] = ptri.getString(0);
            }
        }
        sArray.setVal(vals);
    }

    @Override
    public boolean isValid(JSCTypes type) {
        return type == JSCTypes.NARRAY || type == JSCTypes.NUMBER || type == JSCTypes.INT || type == JSCTypes.STRING || type == JSCTypes.SARRAY;
    }

    @Override
    public void load(String module, LoadTypes loadType, JSCData ... args) {
        if (module == null || loadType == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (module.length() == 0) {
            throw new IllegalArgumentException("Library name was empty.");
        }
        this.modName = module.toLowerCase();
        if (loadType == StubMlabLoadTypes.USERLIB) {
            File f = new File(EngineTypes.MLAB.DIR_NAME + File.separator + System.mapLibraryName(module));
            if (!f.isFile()) {
                throw new RuntimeException("The system library " + f.getAbsolutePath() + " does not exist.");
            }
            this.systemLib = f.getAbsolutePath();
            return;
        }
        if (loadType == StubMlabLoadTypes.SYSLIB) {
            this.systemLib = System.mapLibraryName(module);
            return;
        }
        if (loadType == StubMlabLoadTypes.EXE) {
            StringBuffer exec = new StringBuffer();
            File f = new File(EngineTypes.MLAB.DIR_NAME + File.separator + module);
            exec.append(f.getAbsolutePath());
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof JSCString)) {
                        throw new IllegalArgumentException("EXE argument at position " + i + " is not of type " + JSCTypes.STRING + ".");
                    }
                    exec.append(" \"" + args[i].value() + "\" ");
                }
            }
            try {
                Process proc = Runtime.getRuntime().exec(exec.toString());
                int exitVal = proc.waitFor();
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = br.readLine();
                while (line != null) {
                    log.info((Object)line);
                    line = br.readLine();
                }
                br.close();
                if (exitVal != 0) {
                    throw new RuntimeException("Execution failed for\n" + exec.toString());
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Execution failed for\n" + exec.toString());
            }
            return;
        }
    }

    public String getCurrentSysLib() {
        return this.systemLib;
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException(this.toString() + " tasks cannot be stopped.");
    }

    @Override
    public void shutdown() {
        String compiler_version = this.cf.getConfig(StubMlabConfigKeys.MATLAB_COMPILER_VERSION);
        if (!compiler_version.startsWith("4")) {
            return;
        }
        CFunc mlabTermCall = new CFunc(this.mlabLib, "jmlab_terminate");
        mlabTermCall.callVoid(new Object[0]);
    }
}

