/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.gauss;

import com.jstatcom.engine.AbstractConfigPanel;
import com.jstatcom.engine.ConfigHolder;
import com.jstatcom.engine.ConfigKeys;
import com.jstatcom.engine.Engine;
import com.jstatcom.engine.EngineTypes;
import com.jstatcom.engine.gauss.GaussConfigKeys;
import com.jstatcom.engine.gauss.GaussConfigPanel;
import com.jstatcom.engine.gauss.GaussEngine;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public final class GaussEngineType
extends EngineTypes {
    public static final GaussEngineType INSTANCE = new GaussEngineType("GAUSS");
    private GaussEngine gaussEngine = null;
    private AbstractConfigPanel configPanel = null;

    public File getTempFile() {
        String tmpDir = ConfigHolder.valueOf(this).getConfig(GaussConfigKeys.TEMP_DIR) + "/" + this.DIR_NAME;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("jsc", null, new File(tmpDir));
            tmpFile.deleteOnExit();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return tmpFile;
    }

    private GaussEngineType(String name) {
        super(name);
    }

    @Override
    public String checkSettings(ConfigHolder configHolder) {
        if (configHolder == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        return null;
    }

    @Override
    public Map<String, ConfigKeys> getConfigKeys() {
        return ConfigKeys.getAllKeys(GaussConfigKeys.class);
    }

    @Override
    public AbstractConfigPanel getConfigPanel() {
        if (this.configPanel == null) {
            this.configPanel = new GaussConfigPanel();
        }
        return this.configPanel;
    }

    @Override
    public Engine getEngine() {
        if (this.gaussEngine == null) {
            try {
                this.gaussEngine = GaussEngine.getInstance();
                this.gaussEngine.start(true);
            }
            catch (Throwable ex) {
                throw new RuntimeException("The GAUSS engine could not be initialized\ndue to the following error:\n\n" + ex.getMessage() + "\n");
            }
        }
        GaussEngineType.addLoadedEngine(this.gaussEngine);
        return this.gaussEngine;
    }
}

