/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.gauss;

import com.jstatcom.engine.AbstractConfigPanel;
import com.jstatcom.engine.ConfigHolder;
import com.jstatcom.engine.gauss.GaussConfigKeys;
import com.jstatcom.io.FileSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public final class GaussConfigPanel
extends AbstractConfigPanel {
    private static final Logger log = Logger.getLogger(GaussConfigPanel.class);
    private JLabel ivjJLabel1 = null;
    private JLabel ivjJLabel2 = null;
    private JLabel ivjJLabel3 = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JTextField ivjExecLocationField = null;
    private JTextField ivjTempDirField = null;
    private JComboBox ivjVersionCombo = null;
    private JButton ivjGaussLocationButton = null;
    private JButton ivjTempDirButton = null;

    public GaussConfigPanel() {
        this.initialize();
    }

    private void connEtoC1() {
        try {
            this.gaussLocation_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.tempDir_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void gaussLocation_ActionEvents() {
        File dir = FileSupport.getInstance().chooseDirectory(this, "Select Gauss Directory");
        if (dir != null) {
            this.getExecLocationField().setText(dir.toString());
        }
    }

    private JTextField getExecLocationField() {
        if (this.ivjExecLocationField == null) {
            try {
                this.ivjExecLocationField = new JTextField();
                this.ivjExecLocationField.setName("ExecLocationField");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExecLocationField;
    }

    private JButton getGaussLocationButton() {
        if (this.ivjGaussLocationButton == null) {
            try {
                this.ivjGaussLocationButton = new JButton();
                this.ivjGaussLocationButton.setName("GaussLocationButton");
                this.ivjGaussLocationButton.setMnemonic('w');
                this.ivjGaussLocationButton.setText("Browse...");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGaussLocationButton;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("Location of Gauss executable ");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel2() {
        if (this.ivjJLabel2 == null) {
            try {
                this.ivjJLabel2 = new JLabel();
                this.ivjJLabel2.setName("JLabel2");
                this.ivjJLabel2.setText(" Temporary directory (if empty, system TEMP is used)");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel2;
    }

    private JLabel getJLabel3() {
        if (this.ivjJLabel3 == null) {
            try {
                this.ivjJLabel3 = new JLabel();
                this.ivjJLabel3.setName("JLabel3");
                this.ivjJLabel3.setText("Version of Gauss ");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel3;
    }

    private JButton getTempDirButton() {
        if (this.ivjTempDirButton == null) {
            try {
                this.ivjTempDirButton = new JButton();
                this.ivjTempDirButton.setName("TempDirButton");
                this.ivjTempDirButton.setMnemonic('w');
                this.ivjTempDirButton.setText("Browse...");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTempDirButton;
    }

    private JTextField getTempDirField() {
        if (this.ivjTempDirField == null) {
            try {
                this.ivjTempDirField = new JTextField();
                this.ivjTempDirField.setName("TempDirField");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTempDirField;
    }

    private JComboBox getVersionCombo() {
        if (this.ivjVersionCombo == null) {
            try {
                this.ivjVersionCombo = new JComboBox();
                this.ivjVersionCombo.setName("VersionCombo");
                this.ivjVersionCombo.setMinimumSize(new Dimension(130, 23));
                Iterator iter = GaussConfigKeys.versionIterator();
                while (iter.hasNext()) {
                    this.ivjVersionCombo.addItem(iter.next());
                }
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjVersionCombo;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initConnections() throws Exception {
        this.getGaussLocationButton().addActionListener(this.ivjEventHandler);
        this.getTempDirButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("GaussConfigPanel");
            this.setPreferredSize(new Dimension(300, 200));
            this.setLayout(new GridBagLayout());
            this.setSize(487, 235);
            this.setMinimumSize(new Dimension(300, 200));
            GridBagConstraints constraintsExecLocationField = new GridBagConstraints();
            constraintsExecLocationField.gridx = 0;
            constraintsExecLocationField.gridy = 1;
            constraintsExecLocationField.gridwidth = 2;
            constraintsExecLocationField.fill = 2;
            constraintsExecLocationField.weightx = 1.0;
            constraintsExecLocationField.insets = new Insets(5, 10, 0, 0);
            this.add((Component)this.getExecLocationField(), constraintsExecLocationField);
            GridBagConstraints constraintsJLabel1 = new GridBagConstraints();
            constraintsJLabel1.gridx = 0;
            constraintsJLabel1.gridy = 0;
            constraintsJLabel1.gridwidth = 3;
            constraintsJLabel1.fill = 2;
            constraintsJLabel1.insets = new Insets(20, 10, 0, 0);
            this.add((Component)this.getJLabel1(), constraintsJLabel1);
            GridBagConstraints constraintsJLabel2 = new GridBagConstraints();
            constraintsJLabel2.gridx = 0;
            constraintsJLabel2.gridy = 2;
            constraintsJLabel2.gridwidth = 3;
            constraintsJLabel2.fill = 2;
            constraintsJLabel2.insets = new Insets(20, 10, 0, 0);
            this.add((Component)this.getJLabel2(), constraintsJLabel2);
            GridBagConstraints constraintsTempDirField = new GridBagConstraints();
            constraintsTempDirField.gridx = 0;
            constraintsTempDirField.gridy = 3;
            constraintsTempDirField.gridwidth = 2;
            constraintsTempDirField.fill = 2;
            constraintsTempDirField.weightx = 1.0;
            constraintsTempDirField.insets = new Insets(5, 10, 0, 0);
            this.add((Component)this.getTempDirField(), constraintsTempDirField);
            GridBagConstraints constraintsJLabel3 = new GridBagConstraints();
            constraintsJLabel3.gridx = 0;
            constraintsJLabel3.gridy = 4;
            constraintsJLabel3.fill = 2;
            constraintsJLabel3.anchor = 18;
            constraintsJLabel3.insets = new Insets(20, 10, 0, 0);
            this.add((Component)this.getJLabel3(), constraintsJLabel3);
            GridBagConstraints constraintsVersionCombo = new GridBagConstraints();
            constraintsVersionCombo.gridx = 0;
            constraintsVersionCombo.gridy = 5;
            constraintsVersionCombo.fill = 2;
            constraintsVersionCombo.anchor = 18;
            constraintsVersionCombo.weightx = 1.0;
            constraintsVersionCombo.weighty = 1.0;
            constraintsVersionCombo.insets = new Insets(5, 10, 0, 0);
            this.add((Component)this.getVersionCombo(), constraintsVersionCombo);
            GridBagConstraints constraintsGaussLocationButton = new GridBagConstraints();
            constraintsGaussLocationButton.gridx = 2;
            constraintsGaussLocationButton.gridy = 1;
            constraintsGaussLocationButton.insets = new Insets(5, 10, 0, 10);
            this.add((Component)this.getGaussLocationButton(), constraintsGaussLocationButton);
            GridBagConstraints constraintsTempDirButton = new GridBagConstraints();
            constraintsTempDirButton.gridx = 2;
            constraintsTempDirButton.gridy = 3;
            constraintsTempDirButton.insets = new Insets(5, 10, 0, 10);
            this.add((Component)this.getTempDirButton(), constraintsTempDirButton);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    @Override
    public void setConfig(ConfigHolder configHolder) {
        if (configHolder == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.getExecLocationField().setText(configHolder.getConfig(GaussConfigKeys.EXE_LOCATION));
        this.getTempDirField().setText(configHolder.getConfig(GaussConfigKeys.TEMP_DIR));
        this.getVersionCombo().setSelectedItem(configHolder.getConfig(GaussConfigKeys.GAUSS_VERSION));
    }

    @Override
    public String storeConfig(ConfigHolder configHolder) {
        if (configHolder == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        configHolder.setConfig(GaussConfigKeys.EXE_LOCATION, this.getExecLocationField().getText().trim());
        configHolder.setConfig(GaussConfigKeys.TEMP_DIR, this.getTempDirField().getText().trim());
        configHolder.setConfig(GaussConfigKeys.GAUSS_VERSION, this.getVersionCombo().getSelectedItem().toString());
        return null;
    }

    private void tempDir_ActionEvents() {
        File dir = FileSupport.getInstance().chooseDirectory(this, "Select Temporary Directory");
        if (dir != null) {
            this.getTempDirField().setText(dir.toString());
        }
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GaussConfigPanel.this.getGaussLocationButton()) {
                GaussConfigPanel.this.connEtoC1();
            }
            if (e.getSource() == GaussConfigPanel.this.getTempDirButton()) {
                GaussConfigPanel.this.connEtoC2();
            }
        }
    }
}

