/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import com.jstatcom.component.CompSettings;
import com.jstatcom.component.OutHolder;
import com.jstatcom.component.StdMessages;
import com.jstatcom.component.SystemOutHolder;
import com.jstatcom.engine.DefaultPCallControl;
import com.jstatcom.engine.Engine;
import com.jstatcom.engine.LoadTypes;
import com.jstatcom.engine.PCallListener;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.project.OutputData;
import com.jstatcom.project.OutputList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public abstract class PCall
extends Thread {
    private boolean gui = true;
    private static final Logger log = Logger.getLogger(PCall.class);
    protected volatile boolean cancelled = false;
    private static final QueuedExecutor executorThread = new QueuedExecutor();
    private List<PCall> callerList = null;
    private boolean printDate = true;
    private EventListenerList listenerList = new EventListenerList();
    private long startTime = 0L;
    private boolean success = true;
    private OutHolder outHolder = new SystemOutHolder();
    private SymbolTable symbolTable = null;
    protected final StringBuffer output = new StringBuffer();

    public final void addPCallListener(PCallListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.add(PCallListener.class, l);
    }

    protected void preCode() {
    }

    protected void finalCode() {
    }

    private void firePCallEvent(final EvtTypes evtType) {
        if (this.listenerList == null || evtType == null) {
            return;
        }
        if (!this.gui || SwingUtilities.isEventDispatchThread()) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != PCallListener.class) continue;
                evtType.fire((PCallListener)listeners[i + 1], this);
            }
            if (this.getPCallControl() != null) {
                evtType.fire(this.getPCallControl(), this);
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new Thread(){

                    @Override
                    public void run() {
                        PCall.this.firePCallEvent(evtType);
                    }
                });
            }
            catch (Throwable ex) {
                log.error((Object)"Event calling failed.", ex);
            }
        }
    }

    public OutHolder getOutHolder() {
        return this.outHolder;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public synchronized boolean isSuccess() {
        return this.success;
    }

    public void removePCallListener(PCallListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.remove(PCallListener.class, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.firePCallEvent(EvtTypes.STARTED);
        this.startTime = System.currentTimeMillis();
        Throwable runEx = null;
        this.success = true;
        this.cancelled = false;
        try {
            this.output.delete(0, this.output.length());
            this.preCode();
            this.runCode();
            if (!this.cancelled) {
                this.finalCode();
            }
        }
        catch (Throwable ex) {
            runEx = ex;
            if (!this.cancelled) {
                this.success = false;
            }
        }
        finally {
            String msg;
            try {
                this.cleanUpAfterCall();
            }
            catch (Throwable t) {
                log.error((Object)"Error in cleanup code.", t);
            }
            if (!this.success && !this.cancelled) {
                if (this.gui) {
                    this.output.append("\nError in \"" + this.getName() + "\" call, see log for details.\n\n");
                } else {
                    this.output.append("\nError in \"" + this.getName() + "\" call:\n" + runEx.getMessage() + "\n\n");
                }
                log.error((Object)("failed call: " + this.getName()), runEx);
                if (this.gui) {
                    msg = "Error running \"" + this.getName() + "\":\n" + runEx.getMessage();
                    StdMessages.error(msg, "Procedure Call Error");
                }
            }
            if (this.cancelled) {
                msg = "\"" + this.getName() + "\" call was interrupted, see log for details.\n";
                this.output.append(msg);
                msg = runEx != null ? msg + runEx.getMessage() + "\n\n" : msg + "\n";
                log.info((Object)msg);
            }
            String dateString = "*** " + CompSettings.getDateString() + " ***\n";
            if (this.getOutHolder() != null && this.output.toString().trim().length() > 0) {
                if (this.printDate) {
                    this.getOutHolder().append(dateString + this.output.toString());
                } else {
                    this.getOutHolder().append(this.output.toString());
                }
            }
            if (this.success && !this.cancelled) {
                this.firePCallEvent(EvtTypes.SUCESS);
                this.firePCallEvent(EvtTypes.FINISHED);
                if (this.gui && this.output.length() > 0) {
                    OutputList.getInstance().addOutput(new OutputData(this.getName(), dateString + this.output.toString()));
                }
                if (this.callerList != null) {
                    for (PCall element : this.callerList) {
                        element.run();
                    }
                }
            } else {
                this.firePCallEvent(EvtTypes.FINISHED);
            }
        }
    }

    protected abstract void runCode();

    public void setOutHolder(OutHolder outputHolder) {
        this.outHolder = outputHolder;
    }

    public void setSymbolTable(SymbolTable newSymbolTable) {
        if (newSymbolTable == null) {
            throw new IllegalArgumentException("Symbol table was null.");
        }
        this.symbolTable = newSymbolTable;
    }

    public void execute() {
        try {
            this.firePCallEvent(EvtTypes.QUEUED);
            this.setPriority(1);
            this.getExecutor().execute((Runnable)this);
        }
        catch (InterruptedException ex) {
            log.error((Object)("Execution of " + this.getName() + " failed."), (Throwable)ex);
            this.success = false;
            this.firePCallEvent(EvtTypes.FINISHED);
        }
    }

    public void cancel() {
        this.cancelled = true;
        if (this.engine() != null) {
            try {
                this.engine().stop();
            }
            catch (UnsupportedOperationException e) {
                this.cancelled = false;
                String s = "Running task for engine\n<" + this.engine().getClass().getName() + ">\ncannot be stopped.";
                if (this.gui) {
                    StdMessages.infoGeneral(s);
                }
                log.error((Object)s, (Throwable)e);
            }
        }
    }

    public void add(PCall pCall) {
        if (this.callerList == null) {
            this.callerList = new ArrayList<PCall>();
        }
        this.callerList.add(pCall);
    }

    public void remove(PCall pCall) {
        if (this.callerList == null) {
            return;
        }
        this.callerList.remove(pCall);
    }

    public boolean isPrintDate() {
        return this.printDate;
    }

    public void setPrintDate(boolean b) {
        this.printDate = b;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public abstract Engine engine();

    public void call(String procName, JSCData[] args, JSCData[] retData) {
        this.engine().call(procName, args, retData);
        if (this.cancelled) {
            throw new RuntimeException(this.getName() + " was interrupted.");
        }
    }

    public void load(String module, LoadTypes loadType, JSCData[] args) {
        this.engine().load(module, loadType, args);
        if (this.cancelled) {
            throw new RuntimeException(this.getName() + " was interrupted.");
        }
    }

    protected PCallListener getPCallControl() {
        return DefaultPCallControl.getInstance();
    }

    public Executor getExecutor() {
        return executorThread;
    }

    public boolean isGui() {
        return this.gui;
    }

    public void setGui(boolean gui) {
        this.gui = gui;
    }

    protected void cleanUpAfterCall() {
    }

    protected static abstract class EvtTypes {
        private final String name;
        private static final EvtTypes SUCESS = new EvtTypes("SUCESS"){

            @Override
            public void fire(PCallListener l, PCall pc) {
                l.success();
            }
        };
        private static final EvtTypes FINISHED = new EvtTypes("FINISHED"){

            @Override
            public void fire(PCallListener l, PCall pc) {
                l.finished(pc);
            }
        };
        private static final EvtTypes STARTED = new EvtTypes("STARTED"){

            @Override
            public void fire(PCallListener l, PCall pc) {
                l.started(pc);
            }
        };
        private static final EvtTypes QUEUED = new EvtTypes("QUEUED"){

            @Override
            public void fire(PCallListener l, PCall pc) {
                l.queued(pc);
            }
        };

        private EvtTypes(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        abstract void fire(PCallListener var1, PCall var2);
    }
}

