/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine;

import com.jstatcom.component.CompSettings;
import com.jstatcom.engine.PCall;
import com.jstatcom.engine.PCallListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import org.apache.log4j.Logger;

public class DefaultPCallControl
extends JPanel
implements PCallListener {
    private static final Logger log = Logger.getLogger(DefaultPCallControl.class);
    private static DefaultPCallControl instance = null;
    private JLabel jLabel = null;
    private StatusDisplayThread displayThread = null;
    private JButton jButton = null;
    private PCall runningPCall = null;
    private ActionListener stopAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (DefaultPCallControl.this.runningPCall != null) {
                DefaultPCallControl.this.runningPCall.cancel();
            }
        }
    };

    public DefaultPCallControl() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJLabel(), "Center");
        this.add((Component)this.getJButton(), "East");
        this.getJButton().setVisible(true);
        this.setSize(200, 25);
        this.setBorder(new EtchedBorder());
    }

    @Override
    public void finished(PCall pc) {
        if (this.displayThread != null) {
            this.displayThread.interrupt();
        }
        this.displayThread = null;
        this.runningPCall = null;
        this.getJButton().setEnabled(false);
    }

    @Override
    public void queued(PCall pc) {
    }

    @Override
    public void started(PCall pc) {
        if (this.displayThread != null && this.displayThread.isAlive()) {
            throw new RuntimeException("Another thread is running, display out of sync.");
        }
        this.displayThread = new StatusDisplayThread(pc.getName());
        this.displayThread.start();
        this.runningPCall = pc;
        this.getJButton().setEnabled(true);
    }

    @Override
    public void success() {
    }

    public static DefaultPCallControl getInstance() {
        if (instance == null) {
            instance = new DefaultPCallControl();
        }
        return instance;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("");
        }
        return this.jLabel;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setPreferredSize(new Dimension(100, 25));
            this.jButton.setText("STOP");
            this.jButton.setEnabled(false);
            this.jButton.addActionListener(this.stopAction);
        }
        return this.jButton;
    }

    public void setStopButtonVisible(boolean isVisible) {
        this.getJButton().setVisible(isVisible);
    }

    private class StatusDisplayThread
    extends Thread {
        private final String pCallName;

        public StatusDisplayThread(String name) {
            this.pCallName = name;
        }

        @Override
        public void run() {
            Date start = new Date();
            try {
                while (true) {
                    final Date now = new Date();
                    now.setTime(now.getTime() - start.getTime() - 3600000L);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DefaultPCallControl.this.getJLabel().setText(" Running \"" + StatusDisplayThread.this.pCallName + "\" (elapsed time " + CompSettings.getSimpleDateFormat().format(now) + ")");
                        }
                    });
                    Thread.sleep(1000L);
                }
            }
            catch (Throwable now) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DefaultPCallControl.this.getJLabel().setText("");
                        }
                    });
                }
                catch (Throwable ex) {
                    log.error((Object)"Error calling invokeLater", ex);
                }
                return;
            }
        }
    }
}

