/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.TimedCallable;
import EDU.oswego.cs.dl.util.concurrent.misc.SwingWorker;
import com.jstatcom.component.AppSettings;
import com.jstatcom.component.AppSettingsDialog;
import com.jstatcom.component.FileDrop;
import com.jstatcom.component.JHelpAction;
import com.jstatcom.component.LogFrame;
import com.jstatcom.component.Module;
import com.jstatcom.component.SplashScreen;
import com.jstatcom.component.StdMessages;
import com.jstatcom.component.TopFrameAboutBox;
import com.jstatcom.component.TopFrameReference;
import com.jstatcom.component.TopFrameSettings;
import com.jstatcom.engine.DefaultPCallControl;
import com.jstatcom.engine.Engine;
import com.jstatcom.engine.EngineTypes;
import com.jstatcom.io.AbstractImportPanel;
import com.jstatcom.io.FileSupport;
import com.jstatcom.io.ImportDataFrame;
import com.jstatcom.io.RedirectOutput;
import com.jstatcom.io.RedirectReceiver;
import com.jstatcom.io.TSImportPanel;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCInt;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.control.SymbolFrame;
import com.jstatcom.project.ModuleTreeNode;
import com.jstatcom.project.OutputFrame;
import com.jstatcom.project.OutputList;
import com.jstatcom.project.ProjectDataManager;
import com.jstatcom.project.ProjectManager;
import com.jstatcom.project.ProjectStateHandler;
import com.jstatcom.project.ProjectTree;
import com.jstatcom.project.SettingsManager;
import com.jstatcom.ts.TSCalcFrame;
import com.jstatcom.ts.TSHolder;
import com.jstatcom.util.FArg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javolution37.javolution.xml.ObjectReader;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;
import org.apache.log4j.Logger;

public class TopFrame
extends JFrame {
    private static final Logger log = Logger.getLogger(TopFrame.class);
    private static AppSettings appSettings = new AppSettings();
    private AppSettingsDialog settingsDialog = null;
    protected String osName = System.getProperty("os.name").toUpperCase();
    private JInternalFrame currentTopFrame = null;
    private final QueuedExecutor executorThread = new QueuedExecutor();
    private JPanel leftPanel = null;
    public static final String XMLFILE = "modules.xml";
    public static String VERSION = "1.0";
    public static String TITLE = "JStatCom";
    public static String ABOUTIMAGE = "/images/splashdefault.gif";
    public static String ABOUTINFO = "www.jstatcom.com";
    public static String LICENSE = "license.html";
    public static String ICON = "/images/jstatcom.gif";
    private static ResourceBundle resjm = null;
    private JToggleButton outputToggleB = null;
    private boolean systemExitWhenClosing = true;
    private boolean confirmClose = true;
    private List<JInternalFrame> alreadyShownFrames = new Vector<JInternalFrame>();
    private List<JInternalFrame> moduleFrames = new Vector<JInternalFrame>();
    private LogFrame logger = null;
    private JDialog aboutBox = null;
    private JInternalFrame tsCalc = null;
    private JToolBar toolBar = null;
    private JSplitPane splitPane = null;
    private JFrame symbolFrame = null;
    private JFrame outputFrame = null;
    private ImportDataFrame importFrame = null;
    private AbstractImportPanel importPanel = null;
    protected SplashScreen splashScreen = null;
    private JDesktopPane desktopPane = null;
    private JMenuBar menuBar = null;
    private JPanel statusBar = null;
    private JMenu fileMenu = null;
    private JMenu modulesMenu = null;
    private JMenu toolsMenu = null;
    private JMenu controlMenu = null;
    private JMenu helpMenu = null;

    public static AppSettings getApplicationSettings() {
        if (appSettings == null) {
            return new AppSettings();
        }
        return appSettings;
    }

    public String getTopModuleByName() {
        if (this.currentTopFrame == null) {
            return null;
        }
        return this.currentTopFrame.getTitle();
    }

    public TopFrame() {
        this(TITLE, true, true);
    }

    public TopFrame(String title) {
        this(title, true, true);
    }

    public TopFrame(String title, boolean isConfirmClose, boolean isSystemExitOnClose) {
        super(title);
        this.systemExitWhenClosing = isSystemExitOnClose;
        this.confirmClose = isConfirmClose;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TopFrame topFrame = (TopFrame)e.getComponent();
                if (appSettings.getExitDialog().intVal() != 0 && TopFrame.this.confirmClose && JOptionPane.showConfirmDialog(topFrame, "Quit?", topFrame.getTitle(), 0, 3) == 1) {
                    return;
                }
                try {
                    SettingsManager.getInstance().saveSettings();
                    if (appSettings.getSaveLastState().intVal() != 0) {
                        SettingsManager.getInstance().saveLastState();
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"Error saving settings", t);
                }
                this.testForExit();
                TopFrame.this.dispose();
            }

            private void testForExit() {
                if (TopFrame.this.systemExitWhenClosing) {
                    try {
                        Iterator iter = EngineTypes.engineIterator();
                        while (iter.hasNext()) {
                            final Engine element = (Engine)iter.next();
                            Callable call = new Callable(){

                                public Object call() {
                                    element.shutdown();
                                    return null;
                                }
                            };
                            new TimedCallable(call, 1000L).call();
                        }
                    }
                    catch (Throwable ex) {
                        log.error((Object)"Error shutting down engines", ex);
                    }
                    System.exit(0);
                }
            }
        });
    }

    protected JInternalFrame getTSCalcFrame() {
        if (this.tsCalc == null) {
            try {
                this.tsCalc = new TSCalcFrame();
            }
            catch (Throwable ex) {
                log.error((Object)"Error creating TSCalcFrame", ex);
            }
        }
        return this.tsCalc;
    }

    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            try {
                this.toolBar = new JToolBar();
                this.toolBar.setSize(200, 20);
                this.toolBar.setFloatable(false);
                this.toolBar.setRollover(true);
            }
            catch (Throwable ex) {
                log.error((Object)"Error creating toolbar", ex);
            }
        }
        return this.toolBar;
    }

    private void installDragAndDropListener(Component comp) {
        new FileDrop(comp, BorderFactory.createMatteBorder(2, 2, 2, 2, Color.GREEN), true, new FileDrop.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void filesDropped(File[] files) {
                String fName = "";
                TopFrame.this.setCursor(new Cursor(3));
                try {
                    if (files != null && files.length > 0) {
                        fName = files[0].getAbsolutePath();
                        if (fName.endsWith(".jsc") || fName.endsWith(".JSC")) {
                            ProjectManager.getInstance().deSerializeProject(files[0]);
                        } else if (TopFrame.this.getImportFrame().importData(files[0])) {
                            TopFrame.this.handleView(TopFrame.this.getImportFrame());
                        }
                    }
                }
                catch (Throwable t) {
                    StdMessages.error("The file \"" + fName + "\" could not be handled.\nPlease see the log for details.", "File Read Error");
                    log.error((Object)"Error in file drag'n drop", t);
                }
                finally {
                    TopFrame.this.setCursor(new Cursor(0));
                }
            }
        });
    }

    private JToggleButton getOutputToggleButton() {
        if (this.outputToggleB == null) {
            this.outputToggleB = new JToggleButton("Output History On");
            URL urlon = this.getClass().getResource("/images/outcontrol.gif");
            URL urloff = this.getClass().getResource("/images/outcontroloff.gif");
            ImageIcon on = null;
            ImageIcon off = null;
            if (urlon != null) {
                on = new ImageIcon(urlon);
            }
            if (urloff != null) {
                off = new ImageIcon(urloff);
            }
            final ImageIcon onFin = on;
            final ImageIcon offFin = off;
            this.outputToggleB.setIcon(on);
            this.outputToggleB.setSelected(true);
            this.outputToggleB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (TopFrame.this.outputToggleB.isSelected()) {
                        TopFrame.this.outputToggleB.setText("Output History On");
                        TopFrame.this.outputToggleB.setIcon(onFin);
                        TopFrame.this.getOutputControlFrame().setTitle("Output Control [History On]");
                        TopFrame.this.getOutputControlFrame().setIconImage(onFin.getImage());
                        OutputList.getInstance().setOutputHistory(true);
                    } else {
                        TopFrame.this.outputToggleB.setText("Output History Off");
                        TopFrame.this.outputToggleB.setIcon(offFin);
                        TopFrame.this.getOutputControlFrame().setTitle("Output Control [History Off]");
                        TopFrame.this.getOutputControlFrame().setIconImage(offFin.getImage());
                        OutputList.getInstance().setOutputHistory(false);
                    }
                }
            });
        }
        return this.outputToggleB;
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            try {
                this.splitPane = new JSplitPane();
                this.splitPane.setRightComponent(this.getTopFrameDesktop());
                JScrollPane scrollPane = new JScrollPane(ProjectTree.getInstance());
                this.leftPanel = new JPanel(new BorderLayout());
                this.leftPanel.add((Component)scrollPane, "Center");
                this.leftPanel.add((Component)this.getOutputToggleButton(), "North");
                this.installDragAndDropListener(scrollPane);
                scrollPane.setPreferredSize(new Dimension(150, 100));
                this.splitPane.setLeftComponent(this.leftPanel);
            }
            catch (Throwable ex) {
                log.error((Object)"Error creating splitpane", ex);
            }
        }
        return this.splitPane;
    }

    protected JFrame getOutputControlFrame() {
        if (this.outputFrame == null) {
            try {
                this.outputFrame = new OutputFrame();
                this.outputFrame.setLocationRelativeTo(this);
            }
            catch (Throwable ex) {
                log.error((Object)"Error creating output control", ex);
            }
        }
        return this.outputFrame;
    }

    protected JFrame getSymbolControlFrame() {
        if (this.symbolFrame == null) {
            try {
                this.symbolFrame = new SymbolFrame();
                this.symbolFrame.setLocationRelativeTo(this);
            }
            catch (Throwable ex) {
                log.error((Object)"Error creating symbol frame", ex);
            }
        }
        return this.symbolFrame;
    }

    public final JDesktopPane getTopFrameDesktop() {
        if (this.desktopPane == null) {
            try {
                this.desktopPane = new JDesktopPane();
            }
            catch (Throwable ex) {
                log.error((Object)"Error creating desktop", ex);
            }
        }
        return this.desktopPane;
    }

    public final JMenuBar getTopFrameMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
        }
        return this.menuBar;
    }

    protected JDialog getTopFrameAboutBox() {
        if (this.aboutBox == null) {
            try {
                this.aboutBox = new TopFrameAboutBox(this, "About " + TITLE, VERSION, ABOUTINFO, ABOUTIMAGE, LICENSE);
            }
            catch (Throwable ex) {
                log.error((Object)"Error creating about box", ex);
            }
        }
        return this.aboutBox;
    }

    protected RedirectReceiver getLogFrame() {
        if (this.logger == null) {
            try {
                this.logger = new LogFrame();
            }
            catch (Throwable ex) {
                log.error((Object)"Error creating logger", ex);
            }
        }
        return this.logger;
    }

    protected AbstractImportPanel getImportPanel() {
        if (this.importPanel == null) {
            try {
                this.importPanel = new TSImportPanel();
            }
            catch (Throwable ex) {
                log.error((Object)"Error creating import panel", ex);
            }
        }
        return this.importPanel;
    }

    protected ImportDataFrame getImportFrame() {
        if (this.importFrame == null) {
            try {
                this.importFrame = new ImportDataFrame();
                this.importFrame.setImportPanel(this.getImportPanel());
            }
            catch (Throwable ex) {
                log.error((Object)"Error creating import frame", ex);
            }
        }
        return this.importFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skeleton() {
        try {
            String file = new File(".").getAbsolutePath();
            FileSupport.getInstance().setDefaultPath(file.substring(0, file.length() - 1));
            this.getContentPane().add((Component)this.getSplitPane(), "Center");
            TopFrameReference.setTopFrameRef(this);
            this.setSize(1000, 800);
            URL url = this.getClass().getResource(ICON);
            if (url != null) {
                this.setIconImage(new ImageIcon(url).getImage());
            }
            this.setLookAndFeel();
            this.startSplash();
            this.adjustFrameSizeandLocation();
            this.initLog();
            this.addMenuBar();
            this.addToolBar();
            this.addStatusBar();
            this.extra();
            ProjectManager.getInstance().setTopFrame(this);
            SettingsManager.getInstance().restoreSettings();
            this.setModulesFromXML();
            try {
                this.executorThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProjectDataManager.getInstance().register(TSHolder.getInstance());
                                if (appSettings.getSaveLastState().intVal() != 0) {
                                    SettingsManager.getInstance().restoreLastState();
                                }
                            }
                        });
                    }
                });
            }
            catch (Throwable ex) {
                log.error((Object)"Error executing restore thread", ex);
            }
        }
        catch (Throwable ex) {
            log.error((Object)"Error restoring settings", ex);
        }
        finally {
            if (this.splashScreen != null) {
                this.splashScreen.showStatus("Completed", 100);
            }
            if (this.splashScreen != null) {
                this.splashScreen.setVisible(false);
            }
            this.setVisible(true);
        }
    }

    protected void setLookAndFeel() {
        try {
            Font f = new Font("dialog", 0, 11);
            UIManager.put("Button.font", f);
            UIManager.put("CheckBox.font", f);
            UIManager.put("CheckBoxMenuItem.font", f);
            UIManager.put("ColorChooser.font", f);
            UIManager.put("ComboBox.font", f);
            UIManager.put("EditorPane.font", f);
            UIManager.put("FormattedTextField.font", f);
            UIManager.put("Label.font", f);
            UIManager.put("List.font", f);
            UIManager.put("Menu.font", f);
            UIManager.put("MenuBar.font", f);
            UIManager.put("MenuItem.font", f);
            UIManager.put("MenuItem.acceleratorFont", new Font("dialog", 0, 10));
            UIManager.put("OptionPane.font", f);
            UIManager.put("Panel.font", f);
            UIManager.put("PasswordField.font", f);
            UIManager.put("PopupMenu.font", f);
            UIManager.put("ProgressBar.font", f);
            UIManager.put("RadioButton.font", f);
            UIManager.put("RadioButtonMenuItem.font", f);
            UIManager.put("ScrollPane.font", f);
            UIManager.put("Spinner.font", f);
            UIManager.put("TabbedPane.font", f);
            UIManager.put("Table.font", f);
            UIManager.put("TableHeader.font", f);
            UIManager.put("TextArea.font", f);
            UIManager.put("TextField.font", f);
            UIManager.put("TextPane.font", f);
            UIManager.put("TitledBorder.font", f);
            UIManager.put("ToggleButton.font", f);
            UIManager.put("ToolBar.font", f);
            UIManager.put("ToolTip.font", f);
            UIManager.put("Tree.font", f);
            UIManager.put("Viewport.font", f);
        }
        catch (Throwable ex) {
            log.error((Object)"Error configuring UI", ex);
        }
    }

    protected String getSplashImage() {
        return ABOUTIMAGE;
    }

    protected void startSplash() {
        try {
            URL url = this.getClass().getResource(this.getSplashImage());
            ImageIcon icon = null;
            if (url != null) {
                icon = new ImageIcon(url);
            } else {
                log.error((Object)("About image \"" + this.getSplashImage() + "\" could not be found."));
            }
            this.splashScreen = new SplashScreen(icon, "Starting Up", "version " + VERSION);
            this.splashScreen.setVisible(true);
        }
        catch (Throwable ex) {
            log.error((Object)"Error creating splash screen", ex);
        }
    }

    protected void adjustFrameSizeandLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    protected void initLog() {
        try {
            RedirectOutput.start(this.getLogFrame());
            SimpleDateFormat formater = new SimpleDateFormat();
            log.info((Object)FArg.sprintf("%-20s%s", new FArg("log time:").add(formater.format(new Date()))));
            log.info((Object)FArg.sprintf("%-20s%s", new FArg("program version:").add(VERSION)));
            Properties sysprops = System.getProperties();
            String debug = sysprops.getProperty("DEBUG", "false");
            log.info((Object)FArg.sprintf("%-20s%s", new FArg("debug mode:").add(debug)));
            if (debug.equalsIgnoreCase("true")) {
                JSCConstants.DEBUG = true;
            }
            log.info((Object)FArg.sprintf("%-20s%s", new FArg("java vm version:").add(sysprops.getProperty("java.vm.version"))));
            log.info((Object)FArg.sprintf("%-20s%s", new FArg("os name:").add(sysprops.getProperty("os.name"))));
            log.info((Object)FArg.sprintf("%-20s%s", new FArg("os version:").add(sysprops.getProperty("os.version"))));
        }
        catch (Throwable ex) {
            log.error((Object)"Error initializing log", ex);
        }
    }

    protected JMenu getFileMenu() {
        if (this.fileMenu != null) {
            return this.fileMenu;
        }
        try {
            this.fileMenu = new JMenu("File");
            ImageIcon icon = null;
            URL url = null;
            final TopFrame frame = this;
            AbstractAction openProjectAction = ProjectManager.getInstance().getDeSerializationAction();
            openProjectAction.putValue("ShortDescription", "Open Project");
            this.fileMenu.add(openProjectAction);
            this.getToolBar().add(openProjectAction);
            AbstractAction saveAsProjectAction = ProjectManager.getInstance().getSerializationAction();
            saveAsProjectAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control S"));
            saveAsProjectAction.putValue("ShortDescription", "Save Project As");
            this.fileMenu.add(saveAsProjectAction);
            this.getToolBar().add(saveAsProjectAction);
            this.fileMenu.addSeparator();
            this.getToolBar().addSeparator();
            url = this.getClass().getResource("/images/import.gif");
            if (url != null) {
                icon = new ImageIcon(url);
            }
            AbstractAction importAction = new AbstractAction("Import Data", icon){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TopFrame.this.handleView(TopFrame.this.getImportFrame());
                    TopFrame.this.getImportFrame().importData();
                }
            };
            importAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F"));
            importAction.putValue("ShortDescription", "Import Data");
            this.fileMenu.add(importAction);
            this.getToolBar().add(importAction);
            this.getToolBar().addSeparator();
            url = this.getClass().getResource("/images/settings.gif");
            if (url != null) {
                icon = new ImageIcon(url);
            }
            AbstractAction settingsAction = new AbstractAction("Preferences", icon){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TopFrame.this.getSettingsDialog().setAppSettings(appSettings);
                    TopFrame.this.getSettingsDialog().setVisible(true);
                    appSettings = TopFrame.this.getSettingsDialog().getAppSettings();
                    TopFrame.this.setAppSettings(appSettings);
                }
            };
            this.fileMenu.addSeparator();
            this.fileMenu.add(settingsAction);
            this.fileMenu.addSeparator();
            url = this.getClass().getResource("/images/exit.gif");
            if (url != null) {
                icon = new ImageIcon(url);
            }
            AbstractAction exitAction = new AbstractAction("Exit Program", icon){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TopFrame.this.processWindowEvent(new WindowEvent(frame, 201));
                }
            };
            this.fileMenu.add(exitAction);
        }
        catch (Throwable ex) {
            log.error((Object)"Error creating file menu", ex);
        }
        return this.fileMenu;
    }

    final JMenu getModuleMenu() {
        if (this.modulesMenu != null) {
            return this.modulesMenu;
        }
        this.modulesMenu = new JMenu("Modules");
        return this.modulesMenu;
    }

    public JMenu getToolsMenu() {
        if (this.toolsMenu != null) {
            return this.toolsMenu;
        }
        try {
            URL url = null;
            ImageIcon icon = null;
            this.toolsMenu = new JMenu("Tools");
            url = this.getClass().getResource("/images/tscalc.gif");
            if (url != null) {
                icon = new ImageIcon(url);
            }
            AbstractAction tsCalcAction = new AbstractAction("TS Calculator", icon){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TopFrame.this.handleView(TopFrame.this.getTSCalcFrame());
                    if (!TopFrame.this.alreadyShownFrames.contains(TopFrame.this.getTSCalcFrame())) {
                        TopFrame.this.alreadyShownFrames.add(TopFrame.this.getTSCalcFrame());
                        try {
                            TopFrame.this.getTSCalcFrame().setMaximum(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            };
            tsCalcAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control D"));
            tsCalcAction.putValue("ShortDescription", "Displays Time Series Calculator");
            this.toolsMenu.add(tsCalcAction);
            this.getToolBar().add(tsCalcAction);
            this.getToolBar().addSeparator();
        }
        catch (Throwable ex) {
            log.error((Object)"Error creating tools menu", ex);
        }
        return this.toolsMenu;
    }

    protected JMenu getControlMenu() {
        if (this.controlMenu != null) {
            return this.controlMenu;
        }
        try {
            URL url = null;
            ImageIcon icon = null;
            this.controlMenu = new JMenu("Control");
            if (this.getSymbolControlFrame().getIconImage() != null) {
                icon = new ImageIcon(this.getSymbolControlFrame().getIconImage());
            }
            AbstractAction symbolAction = new AbstractAction("Symbol Control", icon){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TopFrame.this.getSymbolControlFrame().setVisible(true);
                }
            };
            symbolAction.putValue("ShortDescription", "Symbol Control");
            this.controlMenu.add(symbolAction);
            this.getToolBar().add(symbolAction);
            icon = null;
            URL urlon = this.getClass().getResource("/images/outcontrol.gif");
            if (urlon != null) {
                icon = new ImageIcon(urlon);
            }
            AbstractAction outputAction = new AbstractAction("Output Control", icon){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TopFrame.this.getOutputControlFrame().setVisible(true);
                }
            };
            outputAction.putValue("ShortDescription", "Output Control");
            this.controlMenu.add(outputAction);
            this.getToolBar().add(outputAction);
            this.getToolBar().addSeparator();
            this.controlMenu.addSeparator();
            url = this.getClass().getResource("/images/log.gif");
            if (url != null) {
                icon = new ImageIcon(url);
            }
            AbstractAction logAction = new AbstractAction("Show Logs", icon){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TopFrame.this.getLogFrame().setVisible(true);
                }
            };
            this.controlMenu.add(logAction);
        }
        catch (Throwable ex) {
            log.error((Object)"Error creating control menu", ex);
        }
        return this.controlMenu;
    }

    protected JMenu getHelpMenu() {
        if (this.helpMenu != null) {
            return this.helpMenu;
        }
        try {
            URL url = null;
            ImageIcon icon = null;
            this.helpMenu = new JMenu("Help");
            url = this.getClass().getResource("/images/help.gif");
            if (url != null) {
                icon = new ImageIcon(url);
            }
            JHelpAction helpAction = JHelpAction.getShowHelpInstance("Help System", icon);
            helpAction.putValue("ShortDescription", "Invokes Help System");
            this.helpMenu.add(helpAction);
            this.getToolBar().add(helpAction);
            url = this.getClass().getResource("/images/onItem.gif");
            if (url != null) {
                icon = new ImageIcon(url);
            }
            JHelpAction trackAction = JHelpAction.getTrackInstance("Direct Help", icon);
            trackAction.putValue("ShortDescription", "Context Sensitive Help");
            this.helpMenu.add(trackAction);
            this.helpMenu.addSeparator();
            this.getToolBar().add(trackAction);
            url = this.getClass().getResource("/images/about.gif");
            if (url != null) {
                icon = new ImageIcon(url);
            }
            AbstractAction aboutAction = new AbstractAction("About " + TITLE, icon){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TopFrame.this.getTopFrameAboutBox().setVisible(true);
                }
            };
            this.helpMenu.add(aboutAction);
        }
        catch (Throwable ex) {
            log.error((Object)"Error creating help menu", ex);
        }
        return this.helpMenu;
    }

    protected JPanel getStatusBar() {
        if (this.statusBar == null) {
            try {
                this.statusBar = DefaultPCallControl.getInstance();
                this.statusBar.setPreferredSize(new Dimension(200, 25));
            }
            catch (Throwable ex) {
                log.error((Object)"Error creating status bar", ex);
            }
        }
        return this.statusBar;
    }

    protected void addMenuBar() {
        if (this.getTopFrameMenuBar() != null) {
            this.setJMenuBar(this.getTopFrameMenuBar());
        }
        if (this.getFileMenu() != null) {
            this.getTopFrameMenuBar().add(this.getFileMenu());
        }
        if (this.getModuleMenu() != null) {
            this.getTopFrameMenuBar().add(this.getModuleMenu());
        }
        if (this.getToolsMenu() != null) {
            this.getTopFrameMenuBar().add(this.getToolsMenu());
        }
        if (this.getControlMenu() != null) {
            this.getTopFrameMenuBar().add(this.getControlMenu());
        }
        if (this.getHelpMenu() != null) {
            this.getTopFrameMenuBar().add(this.getHelpMenu());
        }
    }

    protected void extra() {
    }

    protected void addStatusBar() {
        if (this.getStatusBar() != null) {
            this.getContentPane().add((Component)this.getStatusBar(), "South");
        }
    }

    protected void addToolBar() {
        if (this.getToolBar() != null) {
            this.getContentPane().add((Component)this.getToolBar(), "North");
        }
    }

    public static void main(String[] args) {
        try {
            TopFrame topFrame = new TopFrame();
            topFrame.skeleton();
        }
        catch (Throwable exception) {
            log.error((Object)"Error in main()", exception);
        }
    }

    public final void handleView(JInternalFrame internalFrame) {
        if (internalFrame.getDesktopPane() == null) {
            this.getTopFrameDesktop().add(internalFrame);
        }
        try {
            boolean wasMax = internalFrame.isMaximum();
            Dimension dim = internalFrame.getSize();
            Point point = internalFrame.getLocation();
            internalFrame.setClosed(false);
            internalFrame.setIcon(false);
            internalFrame.setMaximum(!wasMax);
            internalFrame.setMaximum(wasMax);
            if (!wasMax) {
                internalFrame.setSize(dim);
                internalFrame.setLocation(point);
            }
        }
        catch (PropertyVetoException ex) {
            log.error((Object)"Error handling a view", (Throwable)ex);
        }
        if (this.moduleFrames.contains(internalFrame)) {
            this.currentTopFrame = internalFrame;
        }
        internalFrame.setVisible(true);
    }

    protected final void setModulesFromXML() {
        URL url = this.getClass().getResource("/modules.xml");
        if (url == null) {
            return;
        }
        XMLRep newRep = null;
        ObjectReader constructor = new ObjectReader();
        try {
            newRep = (XMLRep)constructor.read(url.openStream());
        }
        catch (Throwable ex) {
            log.error((Object)("Module initialization from \"" + url + "\" failed."), ex);
            return;
        }
        if (newRep == null || newRep.moduleList == null || newRep.moduleList.size() == 0) {
            log.error((Object)("No modules defined in \"" + url + "\"."));
            return;
        }
        ArrayList<String> helpSetList = new ArrayList<String>();
        int num = newRep.moduleList.size();
        for (int i = 0; i < num; ++i) {
            final Module module_i = (Module)newRep.moduleList.get(i);
            if (module_i == null) continue;
            if (module_i.helpSetName != null && !helpSetList.contains(module_i.helpSetName)) {
                helpSetList.add(module_i.helpSetName);
            }
            if (module_i.className == null) continue;
            try {
                if (this.splashScreen != null) {
                    this.splashScreen.showStatus(module_i.className, 100 / num * (i + 1));
                }
                final JMenuItem menu_i = new JMenuItem(module_i.className);
                menu_i.setEnabled(false);
                this.getModuleMenu().add(menu_i);
                Worker worker_i = new Worker(module_i.className, module_i.methodName){
                    Logger lg;
                    {
                        super(className, methodName);
                        this.lg = Logger.getLogger(((Object)((Object)this)).getClass());
                    }

                    public void finished() {
                        Object obj;
                        try {
                            obj = this.get();
                        }
                        catch (Throwable ex) {
                            this.lg.error((Object)("Error in finished of worker: " + module_i.className + ":" + module_i.methodName), ex);
                            return;
                        }
                        if (obj instanceof JInternalFrame) {
                            final JInternalFrame frame = (JInternalFrame)obj;
                            AbstractAction action = new AbstractAction(frame.getTitle(), frame.getFrameIcon()){

                                @Override
                                public void actionPerformed(ActionEvent evt) {
                                    TopFrame.this.handleView(frame);
                                    if (!TopFrame.this.alreadyShownFrames.contains(frame)) {
                                        TopFrame.this.alreadyShownFrames.add(frame);
                                        try {
                                            frame.setMaximum(true);
                                        }
                                        catch (Throwable ex) {
                                            lg.error((Object)"Error in setMaximum", ex);
                                        }
                                    }
                                }
                            };
                            menu_i.setAction(action);
                            ProjectTree.getInstance().addModuleNode(new ModuleTreeNode(action));
                            TopFrame.this.moduleFrames.add(frame);
                            TopFrame.this.handleView(frame);
                            if (!TopFrame.this.alreadyShownFrames.contains(frame)) {
                                TopFrame.this.alreadyShownFrames.add(frame);
                                try {
                                    frame.setMaximum(true);
                                }
                                catch (Throwable ex) {
                                    this.lg.error((Object)"Error in setMaximum", ex);
                                }
                            }
                            if (frame instanceof ProjectStateHandler) {
                                ProjectManager.getInstance().addProjectStateHandler((ProjectStateHandler)((Object)frame));
                            }
                            return;
                        }
                        if (obj instanceof Throwable) {
                            this.lg.error((Object)("Creation of \"" + this.classToBuild + "\" failed."), (Throwable)obj);
                        } else {
                            this.lg.error((Object)("\"" + this.classToBuild + "\" is not a JInternalFrame."));
                        }
                    }
                };
                this.executorThread.execute((Runnable)((Object)worker_i));
                continue;
            }
            catch (Throwable ex) {
                log.error((Object)("Module \"" + module_i.className + "\" at position [" + (i + 1) + "] in \"" + url + "\" could not be set."), ex);
            }
        }
        JHelpAction.startHelpWorker(helpSetList);
    }

    public void setTopModuleByName(String moduleTitle) {
        if (moduleTitle == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        for (int i = 0; i < this.moduleFrames.size(); ++i) {
            JInternalFrame frame;
            JInternalFrame o = this.moduleFrames.get(i);
            if (!(o instanceof JInternalFrame) || !moduleTitle.equals((frame = o).getTitle())) continue;
            this.handleView(frame);
            return;
        }
    }

    public void setTopFrameSettings(TopFrameSettings settings) {
        if (settings == null) {
            return;
        }
        int[][] bounds = settings.getFrameBounds().intArray();
        if (bounds.length == 4) {
            Rectangle rec = new Rectangle(bounds[0][0], bounds[1][0], bounds[2][0], bounds[3][0]);
            this.setBounds(rec);
        }
        int loc = settings.getSplitLocation().intVal();
        this.getSplitPane().setDividerLocation(loc);
        int isToggle = settings.getIsOutputOn().intVal();
        if (isToggle != 0 != this.getOutputToggleButton().isSelected()) {
            this.getOutputToggleButton().doClick();
        }
    }

    public void setAppSettings(AppSettings settings) {
        if (settings == null) {
            return;
        }
        appSettings = settings;
        if (this.getSymbolControlFrame() instanceof SymbolFrame) {
            ((SymbolFrame)this.getSymbolControlFrame()).setDataEditable(appSettings.getSControlEdit().intVal() != 0);
        }
        if (this.leftPanel != null) {
            if (appSettings.getShowExplorer().intVal() != 0) {
                this.leftPanel.setVisible(true);
                this.getSplitPane().setDividerSize(10);
                if (this.getSplitPane().getDividerLocation() < 10) {
                    this.getSplitPane().setDividerLocation(180);
                }
            } else {
                this.leftPanel.setVisible(false);
                this.getSplitPane().setDividerSize(0);
            }
        }
    }

    public TopFrameSettings getTopFrameSettings() {
        TopFrameSettings settings = new TopFrameSettings();
        Rectangle rec = this.getBounds();
        JSCNArray bounds = new JSCNArray("bounds", rec.getX(), rec.getY(), rec.getWidth(), rec.getHeight());
        settings.setFrameBounds(bounds);
        int divider = this.getSplitPane().getDividerLocation();
        JSCInt div = new JSCInt("split", divider);
        settings.setSplitLocation(div);
        JSCInt output = new JSCInt("output", this.getOutputToggleButton().isSelected());
        settings.setIsOutputOn(output);
        return settings;
    }

    public AppSettings getAppSettings() {
        return appSettings;
    }

    private AppSettingsDialog getSettingsDialog() {
        if (this.settingsDialog == null) {
            this.settingsDialog = new AppSettingsDialog(this);
            this.settingsDialog.setLocationRelativeTo(this);
        }
        return this.settingsDialog;
    }

    static {
        try {
            resjm = ResourceBundle.getBundle("app");
            VERSION = resjm.getString("VERSION");
            TITLE = resjm.getString("TITLE");
            ABOUTIMAGE = resjm.getString("ABOUTIMAGE");
            ABOUTINFO = resjm.getString("ABOUTINFO");
            LICENSE = resjm.getString("LICENSE");
            ICON = resjm.getString("ICON");
        }
        catch (Throwable ex) {
            log.error((Object)"Resource app.properties not found", ex);
        }
    }

    private static class Worker
    extends SwingWorker {
        protected Class classToBuild;
        protected Method method;

        public Worker(String className, String methodName) {
            if (className == null) {
                this.classToBuild = null;
            } else {
                try {
                    this.classToBuild = Class.forName(className);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
                if (this.classToBuild != null && methodName != null && methodName.length() > 0) {
                    try {
                        this.method = this.classToBuild.getMethod(methodName, new Class[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }

        public Object construct() {
            try {
                if (this.classToBuild == null) {
                    return null;
                }
                if (this.method != null) {
                    Object rt = this.method.invoke((Object)this, new Object[0]);
                    return rt;
                }
                return this.classToBuild.newInstance();
            }
            catch (Throwable ex) {
                return ex;
            }
        }
    }

    public static class XMLRep {
        public final List moduleList;
        public final String name;
        public static final XmlFormat<XMLRep> XMLRep_XML = new XmlFormat<XMLRep>(XMLRep.class){

            @Override
            public void format(XMLRep data, XmlElement xml) {
                xml.setAttribute("name", data.name);
                for (Module element : data.moduleList) {
                    xml.add(element);
                }
            }

            @Override
            public XMLRep parse(XmlElement xml) {
                String nam = xml.getAttribute("name") + "";
                ArrayList<Module> modules = new ArrayList<Module>();
                while (xml.hasNext()) {
                    Module mod = (Module)xml.getNext();
                    if (mod == null) continue;
                    modules.add(mod);
                }
                return new XMLRep(nam, modules);
            }
        };

        public XMLRep(String name, List moduleList) {
            this.name = name;
            this.moduleList = moduleList;
        }
    }
}

