/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.component.ResultField;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

class ResultFieldPopup
extends JPopupMenu {
    private ResultField resultField = null;
    private static final ResultFieldPopup defaultRFPopup = new ResultFieldPopup("DEFAULT_ResultField_PopupMenu");
    private final String name;
    private final AbstractAction clearAction = new AbstractAction("Clear"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ResultFieldPopup.this.getResultField().clear();
        }
    };
    private final AbstractAction increaseFontAction = new AbstractAction("Bigger Font"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ResultFieldPopup.this.getResultField().setFontSize(ResultFieldPopup.this.getResultField().getFontSize() + 2);
        }
    };
    private final AbstractAction decreaseFontAction = new AbstractAction("Smaller Font"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ResultFieldPopup.this.getResultField().setFontSize(ResultFieldPopup.this.getResultField().getFontSize() - 2);
        }
    };
    private final AbstractAction defaultFontAction = new AbstractAction("Default Font"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ResultFieldPopup.this.getResultField().setFontSize(ResultFieldPopup.this.getResultField().getDefaultFontSize());
        }
    };
    private final AbstractAction saveResultAction = new AbstractAction("Save As"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ResultFieldPopup.this.getResultField().saveToFile();
        }
    };
    private final AbstractAction printResultAction = new AbstractAction("Print"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ResultFieldPopup.this.getResultField().print();
        }
    };
    private AbstractAction[] actionHolder = new AbstractAction[]{this.clearAction, this.increaseFontAction, this.decreaseFontAction, this.defaultFontAction, this.saveResultAction, this.printResultAction};

    private ResultFieldPopup(String label) {
        super(label);
        this.name = label;
        this.add(this.clearAction);
        this.addSeparator();
        this.add(this.printResultAction);
        this.add(this.saveResultAction);
        this.addSeparator();
        this.add(this.increaseFontAction);
        this.add(this.decreaseFontAction);
        this.add(this.defaultFontAction);
    }

    public static ResultFieldPopup getInstance() {
        return defaultRFPopup;
    }

    private ResultField getResultField() {
        return this.resultField;
    }

    @Override
    public void processMouseEvent(MouseEvent e, MenuElement[] path, MenuSelectionManager manager) {
        if (!SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        Component comp = e.getComponent();
        Container c = e.getComponent().getParent().getParent();
        if (c instanceof ResultField) {
            this.resultField = (ResultField)c;
            boolean isEnabled = this.resultField.getTextArea().getText().trim().length() > 0;
            for (int i = 0; i < this.actionHolder.length; ++i) {
                this.actionHolder[i].setEnabled(isEnabled);
            }
            if (this.resultField.getFontSize() <= this.resultField.getMinFontSize()) {
                this.decreaseFontAction.setEnabled(false);
            }
            if (this.resultField.getFontSize() >= this.resultField.getMaxFontSize()) {
                this.increaseFontAction.setEnabled(false);
            }
            this.pack();
            this.show(comp, e.getX(), e.getY());
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName() + "[name=" + this.name);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            buffer.append("," + this.getComponent(i).getName());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

