/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.component.CompSettings;
import com.jstatcom.component.OutHolder;
import com.jstatcom.component.ResultFieldPopup;
import com.jstatcom.component.TopFrameReference;
import com.jstatcom.io.FileSupport;
import com.jstatcom.util.UString;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public final class ResultField
extends JScrollPane
implements OutHolder {
    private boolean appendWithoutScroll = false;
    private static final Logger log = Logger.getLogger(ResultField.class);
    private PageFormat pageFormat = null;
    private final PrintableTextArea resultTextArea = new PrintableTextArea();
    private boolean editable = true;
    private JPopupMenu rfPopup = ResultFieldPopup.getInstance();
    private int maxFontSize = 16;
    private int minFontSize = 8;
    private MouseListener triggerPopUp = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            if (ResultField.this.getPopup() != null) {
                ResultField.this.getPopup().processMouseEvent(e, null, null);
            }
        }
    };

    public ResultField() {
        this.setName("ResultField");
        this.setSize(270, 200);
        this.setViewportView(this.resultTextArea);
        this.resultTextArea.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (offs > 1000000) {
                    this.remove(0, 200000);
                }
                super.insertString(offs, str, a);
            }
        });
        this.resultTextArea.addMouseListener(this.triggerPopUp);
    }

    @Override
    public void append(final String text) {
        if (this.appendWithoutScroll) {
            this.appendWithoutScroll(text);
            return;
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                ResultField.this.resultTextArea.append(text);
                int temp = ResultField.this.resultTextArea.getText().length();
                ResultField.this.resultTextArea.setCaretPosition(temp);
            }
        };
        CompSettings.syncWithSwing(runner);
    }

    public void appendWithoutScroll(final String text) {
        Thread runner = new Thread(){

            @Override
            public void run() {
                int temp = ResultField.this.resultTextArea.getText().length();
                ResultField.this.resultTextArea.append(text);
                ResultField.this.resultTextArea.setCaretPosition(temp);
            }
        };
        CompSettings.syncWithSwing(runner);
    }

    @Override
    public void clear() {
        Thread runner = new Thread(){

            @Override
            public void run() {
                ResultField.this.resultTextArea.setText("");
            }
        };
        CompSettings.syncWithSwing(runner);
    }

    public int getDefaultFontSize() {
        return 12;
    }

    public int getFontSize() {
        return this.resultTextArea.getFontSize();
    }

    public int getMaxFontSize() {
        return this.maxFontSize;
    }

    public int getMinFontSize() {
        return this.minFontSize;
    }

    public JPopupMenu getPopup() {
        return this.rfPopup;
    }

    public String getText() {
        return this.resultTextArea.getText();
    }

    public JTextArea getTextArea() {
        return this.resultTextArea;
    }

    public boolean isEditable() {
        return this.editable;
    }

    private Book makeBook() {
        if (this.pageFormat == null) {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            this.pageFormat = printJob.defaultPage();
        }
        Book book = new Book();
        book.append(this.resultTextArea, this.pageFormat, this.resultTextArea.getPageCount(this.pageFormat));
        return book;
    }

    public void print() {
        Thread printer = new Thread(new Runnable(){

            @Override
            public void run() {
                PrinterJob printJob = PrinterJob.getPrinterJob();
                printJob.setPageable(ResultField.this.makeBook());
                if (printJob.printDialog()) {
                    try {
                        printJob.print();
                    }
                    catch (PrinterException ex) {
                        log.error((Object)"Printing error", (Throwable)ex);
                    }
                }
            }
        });
        printer.start();
    }

    public void saveToFile() {
        File file = FileSupport.getInstance().saveTextFile(TopFrameReference.getTopFrameRef());
        String text = this.resultTextArea.getText();
        text = UString.replaceAllSubStrings(text, "\n", "\r\n");
        if (file != null) {
            FileSupport.getInstance().saveStringToFile(file, text, false);
        }
    }

    public void setEditable(boolean newEditable) {
        this.editable = newEditable;
        this.resultTextArea.setEditable(this.editable);
    }

    public void setFontSize(final int newFontSize) {
        Thread runner = new Thread(){

            @Override
            public void run() {
                ResultField.this.resultTextArea.setFontSize(newFontSize);
            }
        };
        CompSettings.syncWithSwing(runner);
    }

    public void setPopup(JPopupMenu newRfPopup) {
        this.rfPopup = newRfPopup;
    }

    public void setText(final String text) {
        Thread runner = new Thread(){

            @Override
            public void run() {
                ResultField.this.resultTextArea.setText(text);
            }
        };
        CompSettings.syncWithSwing(runner);
    }

    public boolean isAppendWithoutScroll() {
        return this.appendWithoutScroll;
    }

    public void setAppendWithoutScroll(boolean appendWithoutScroll) {
        this.appendWithoutScroll = appendWithoutScroll;
    }

    private static class PrintableTextArea
    extends JTextArea
    implements Printable {
        private int fontSize = 12;

        public PrintableTextArea() {
            this.setFont(new Font("monospaced", 0, this.fontSize));
            this.setMargin(new Insets(3, 5, 3, 5));
        }

        public int getFontSize() {
            return this.fontSize;
        }

        public int getPageCount(PageFormat pf) {
            double height = this.getHeight();
            int pages = (int)Math.ceil(height / pf.getImageableHeight());
            return pages;
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(pf.getImageableX(), pf.getImageableY() + pf.getImageableHeight() * (double)(-pi));
            Font f = new Font(null, 0, 12);
            g2.setFont(f);
            this.paint(g2);
            return 0;
        }

        public void setFontSize(int newFontSize) {
            this.setFont(new Font("monospaced", 0, newFontSize));
            this.fontSize = newFontSize;
        }
    }
}

