/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public final class MatrixBorder
extends AbstractBorder {
    private Insets insets;
    private int outerTopSpace;
    private int outerLeftSpace;
    private int innerTopSpace;
    private int innerLeftSpace;
    private int thickness;
    private int bracketWidth;

    public MatrixBorder() {
        this.thickness = 1;
        this.bracketWidth = 8;
        this.outerTopSpace = 1;
        this.innerTopSpace = 3;
        this.outerLeftSpace = 1;
        this.innerLeftSpace = 3;
        int top = this.thickness + this.outerTopSpace + this.innerTopSpace;
        int left = this.thickness + this.outerLeftSpace + this.innerLeftSpace;
        this.insets = new Insets(top, left, top, left);
    }

    public MatrixBorder(int thick, int width, int outerTop, int innerTop, int outerLeft, int innerLeft) {
        this.thickness = thick;
        this.bracketWidth = width;
        this.outerTopSpace = outerTop;
        this.innerTopSpace = innerTop;
        this.outerLeftSpace = outerLeft;
        this.innerLeftSpace = innerLeft;
        int top = this.thickness + this.outerTopSpace + this.innerTopSpace;
        int left = this.thickness + this.outerLeftSpace + this.innerLeftSpace;
        this.insets = new Insets(top, left, top, left);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = this.insets.left;
        insets.top = this.insets.top;
        insets.right = this.insets.right;
        insets.bottom = this.insets.bottom;
        return insets;
    }

    public static MatrixBorder getInstanceSmall() {
        return new MatrixBorder(1, 5, 1, 1, 1, 1);
    }

    public static MatrixBorder getInstanceThick() {
        return new MatrixBorder(2, 5, 2, 1, 3, 1);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        if (c.isEnabled()) {
            Color newColor = c.getForeground();
            g.setColor(newColor);
        } else {
            Color newColor = c.getBackground().darker();
            g.setColor(newColor);
        }
        g.fillRect(this.outerLeftSpace, this.outerTopSpace, this.thickness, height - 2 * this.outerTopSpace);
        g.fillRect(this.outerLeftSpace, this.outerTopSpace, this.bracketWidth, this.thickness);
        g.fillRect(this.outerLeftSpace, height - this.outerTopSpace - this.thickness, this.bracketWidth, this.thickness);
        g.fillRect(width - this.outerLeftSpace - this.thickness, this.outerTopSpace, this.thickness, height - 2 * this.outerTopSpace);
        g.fillRect(width - this.outerLeftSpace - this.bracketWidth, this.outerTopSpace, this.bracketWidth, this.thickness);
        g.fillRect(width - this.outerLeftSpace - this.bracketWidth, height - this.outerTopSpace - this.thickness, this.bracketWidth, this.thickness);
        g.setColor(oldColor);
    }
}

