/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.component.CardDisplayPanel;
import com.jstatcom.component.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public final class CardPanelAction
extends AbstractAction {
    private static final Logger log = Logger.getLogger(CardPanelAction.class);
    private final CardDisplayPanel cardPanel;
    private JComponent component = null;
    private final String className;

    public CardPanelAction(String className, CardDisplayPanel parent, boolean enabled, String name) {
        this(className, parent, enabled, name, null);
    }

    public CardPanelAction(String className, CardDisplayPanel parent, boolean enabled, String name, Icon icon) {
        super(name, icon);
        if (className == null) {
            throw new IllegalArgumentException("Class name was null.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Parent was null.");
        }
        this.className = className;
        this.cardPanel = parent;
        this.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent arg1) {
        this.cardPanel.showCard(this.getComponent());
    }

    public JComponent getComponent() {
        if (this.component == null) {
            try {
                this.component = (JComponent)Class.forName(this.className).newInstance();
            }
            catch (Throwable thr) {
                String msg = "Problem creating \"" + this.className + "\".";
                log.error((Object)msg, thr);
                this.component = new JPanel();
                this.component.setLayout(new BorderLayout());
                MultiLineLabel label = new MultiLineLabel(msg + "\nDisplaying an empty JPanel instead. Check log messages for more.");
                label.setHorizontalAlignment(0);
                label.setForeground(Color.red);
                this.component.add((Component)label, "Center");
            }
        }
        return this.component;
    }
}

