/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.event;

import javax.swing.text.JTextComponent;
import org.dts.spell.event.SpellCheckAdapter;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.utils.ErrorMarker;

public class ErrorMarkerListener
extends SpellCheckAdapter {
    private ErrorMarker errorMarker = new ErrorMarker();

    public ErrorMarkerListener() {
        this.errorMarker.setSelectError(false);
        this.errorMarker.setAutoQuit(true);
    }

    public void setTextComponent(JTextComponent textComp) {
        this.errorMarker.setTextComponent(textComp);
    }

    public JTextComponent getTextComponent() {
        return this.errorMarker.getTextComponent();
    }

    public boolean isSelectError() {
        return this.errorMarker.isSelectError();
    }

    public void setSelectError(boolean selectError) {
        this.errorMarker.setSelectError(selectError);
    }

    public void unMarkErrors() {
        this.errorMarker.unMarkAllErrors();
    }

    @Override
    public void beginChecking(SpellCheckEvent event) {
        this.unMarkErrors();
    }

    @Override
    public void spellingError(SpellCheckEvent event) {
        this.markError(event);
    }

    @Override
    public void badCaseError(SpellCheckEvent event) {
        this.markError(event);
    }

    @Override
    public void repeatWordError(SpellCheckEvent event) {
        this.markError(event);
    }

    private void markError(SpellCheckEvent event) {
        try {
            Word word = event.getCurrentWord();
            this.errorMarker.markError(word.getStart(), word.getEnd());
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }
}

