/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing;

import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.dts.spell.SpellChecker;
import org.dts.spell.swing.RealTimeSpellChecker;
import org.dts.spell.swing.event.ErrorMarkerListener;
import org.dts.spell.swing.event.UIErrorMarkerListener;
import org.dts.spell.swing.finder.DocumentWordFinder;

public class JTextComponentSpellChecker {
    private SpellChecker spellChecker;
    private UIErrorMarkerListener uiErrorListener = new UIErrorMarkerListener();
    private Map<JTextComponent, ErrorMarkerListener> errorMarkers = new HashMap<JTextComponent, ErrorMarkerListener>();
    private DocumentWordFinder defaultDocumentWordFinder = new DocumentWordFinder();
    private RealTimeSpellChecker realTimeSpellChecker = null;

    public JTextComponentSpellChecker(SpellChecker checker) {
        this.spellChecker = checker;
    }

    private ErrorMarkerListener getErrorMarkerListener(JTextComponent textComponent) {
        return this.errorMarkers.get(textComponent);
    }

    public void markErrors(JTextComponent textComponent) {
        this.markErrors(textComponent, this.defaultDocumentWordFinder);
    }

    public void markErrors(JTextComponent textComponent, DocumentWordFinder wordFinder) {
        ErrorMarkerListener listener = this.getErrorMarkerListener(textComponent);
        if (null == listener) {
            listener = new ErrorMarkerListener();
            this.errorMarkers.put(textComponent, listener);
        }
        Document doc = textComponent.getDocument();
        listener.setTextComponent(textComponent);
        wordFinder.setDocument(doc);
        this.spellChecker.check(wordFinder, listener);
        if (wordFinder == this.defaultDocumentWordFinder) {
            wordFinder.quitDocument();
        }
    }

    public void unMarkErrors(JTextComponent textComponent) {
        ErrorMarkerListener listener = this.getErrorMarkerListener(textComponent);
        if (null == listener) {
            throw new IllegalArgumentException();
        }
        listener.setTextComponent(null);
        this.errorMarkers.remove(textComponent);
    }

    public boolean spellCheck(JTextComponent textComponent) {
        return this.spellCheck(textComponent, this.defaultDocumentWordFinder);
    }

    public boolean spellCheck(JTextComponent textComponent, DocumentWordFinder documentWordFinder) {
        boolean isRealTime;
        Document doc = textComponent.getDocument();
        boolean bl = isRealTime = null != this.realTimeSpellChecker && this.realTimeSpellChecker.getDocumentWordFinder() == documentWordFinder;
        if (isRealTime) {
            this.stopRealtimeMarkErrors();
        }
        this.uiErrorListener.setTextComponent(textComponent);
        documentWordFinder.setDocument(doc);
        boolean result = this.spellChecker.check(documentWordFinder, this.uiErrorListener);
        this.uiErrorListener.quitTextComponent();
        if (!isRealTime) {
            documentWordFinder.quitDocument();
        } else {
            this.startRealtimeMarkErrors(textComponent, documentWordFinder);
        }
        return result;
    }

    public void startRealtimeMarkErrors(JTextComponent textComponent) {
        this.startRealtimeMarkErrors(textComponent, this.defaultDocumentWordFinder);
    }

    public void startRealtimeMarkErrors(JTextComponent textComponent, DocumentWordFinder wordFinder) {
        Document doc = textComponent.getDocument();
        wordFinder.setDocument(doc);
        this.realTimeSpellChecker = new RealTimeSpellChecker(this.spellChecker, textComponent, wordFinder);
        this.realTimeSpellChecker.start();
    }

    public void stopRealtimeMarkErrors() {
        this.realTimeSpellChecker.stop();
        this.realTimeSpellChecker = null;
    }
}

