/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.ZipFile;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.dictionary.SpellDictionaryException;
import org.dts.spell.dictionary.myspell.MySpell;
import org.dts.spell.dictionary.myspell.Utils;

public class CopyOfOpenOfficeSpellDictionary
implements SpellDictionary {
    private File personalDict;
    private MySpell mySpell;
    private boolean isLoaded = false;
    private Future loader = null;

    public CopyOfOpenOfficeSpellDictionary(ZipFile zipFile) throws IOException {
        this(zipFile, true);
    }

    public CopyOfOpenOfficeSpellDictionary(final ZipFile zipFile, boolean inBackground) throws IOException {
        if (inBackground) {
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            this.loader = executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CopyOfOpenOfficeSpellDictionary.this.initFromZipFile(zipFile);
                    executor.shutdown();
                    return null;
                }
            });
        } else {
            this.initFromZipFile(zipFile);
        }
    }

    public CopyOfOpenOfficeSpellDictionary(InputStream zipStream, File personalDict) throws IOException {
        this(zipStream, personalDict, true);
    }

    public CopyOfOpenOfficeSpellDictionary(final InputStream zipStream, final File personalDict, boolean inBackground) throws IOException {
        if (inBackground) {
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            this.loader = executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CopyOfOpenOfficeSpellDictionary.this.initFromStream(zipStream, personalDict);
                    zipStream.close();
                    executor.shutdown();
                    return null;
                }
            });
        } else {
            this.initFromStream(zipStream, personalDict);
        }
    }

    public CopyOfOpenOfficeSpellDictionary(File dictFile, File affFile) throws IOException {
        this(dictFile, affFile, true);
    }

    public CopyOfOpenOfficeSpellDictionary(final File dictFile, final File affFile, boolean inBackground) throws IOException {
        if (inBackground) {
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            this.loader = executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CopyOfOpenOfficeSpellDictionary.this.initFromFiles(dictFile, affFile);
                    executor.shutdown();
                    return null;
                }
            });
        } else {
            this.initFromFiles(dictFile, affFile);
        }
    }

    private File extractRootFile(File file2) {
        String name = file2.getName();
        int index = name.lastIndexOf(46);
        String rootName = index != -1 ? name.substring(0, index) : name;
        return new File(file2.getParent(), rootName);
    }

    private void initFromFiles(File dictFile, File affFile) throws IOException {
        this.personalDict = this.getPersonalWordsFile(this.extractRootFile(dictFile));
        this.mySpell = new MySpell(affFile.getPath(), dictFile.getPath());
        this.readPersonalWords(this.personalDict);
        this.notifyLoaded();
    }

    private void initFromZipFile(ZipFile zipFile) throws IOException {
        this.personalDict = this.getPersonalWordsFile(this.extractRootFile(new File(zipFile.getName())));
        this.mySpell = new MySpell(zipFile);
        this.readPersonalWords(this.personalDict);
        this.notifyLoaded();
    }

    private void initFromStream(InputStream zipStream, File personalDict) throws IOException {
        this.personalDict = personalDict;
        this.mySpell = new MySpell(zipStream);
        this.readPersonalWords(personalDict);
        this.notifyLoaded();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addWord(String word) throws SpellDictionaryException {
        this.waitToLoad();
        PrintWriter pw = null;
        word = word.trim();
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.personalDict, true), this.mySpell.get_dic_encoding()));
            this.mySpell.addCustomWord(word);
            pw.println(word);
        }
        catch (Exception ex) {
            try {
                throw new SpellDictionaryException(ex);
            }
            catch (Throwable throwable) {
                try {
                    Utils.close(pw);
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SpellDictionaryException(e);
                }
            }
        }
        try {
            Utils.close(pw);
            return;
        }
        catch (IOException e) {
            throw new SpellDictionaryException(e);
        }
    }

    @Override
    public boolean isCorrect(String word) {
        this.waitToLoad();
        return this.mySpell.spell(word);
    }

    @Override
    public List<String> getSuggestions(String word) {
        this.waitToLoad();
        return this.mySpell.suggest(word);
    }

    private synchronized void waitToLoad() {
        try {
            if (!this.isLoaded) {
                if (null == this.loader || !this.loader.isDone()) {
                    this.wait();
                } else {
                    this.loader.get();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private synchronized void notifyLoaded() {
        this.isLoaded = true;
        this.notify();
    }

    private File getPersonalWordsFile(File rootFile) {
        return new File(rootFile.getParent(), rootFile.getName() + ".per");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPersonalWords(File personalFile) throws IOException {
        BufferedReader rd = null;
        try {
            if (null != personalFile && personalFile.exists() && !personalFile.isDirectory()) {
                rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(personalFile), this.mySpell.get_dic_encoding()));
                String line = rd.readLine();
                while (line != null) {
                    this.mySpell.addCustomWord(line.trim());
                    line = rd.readLine();
                }
            }
        }
        finally {
            Utils.close(rd);
        }
    }
}

