/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import jehep.ui.mainGUI;

class DropHandler2
extends TransferHandler {
    private mainGUI win;

    DropHandler2(mainGUI win) {
        this.win = win;
    }

    @Override
    public boolean importData(JComponent component, Transferable transferable) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        JTextComponent source = (JTextComponent)component;
        try {
            if (this.canImportFiles(flavors)) {
                this.importFiles(transferable, source);
            } else if (this.canImportStrings(flavors)) {
                this.importStrings(transferable, source);
            } else {
                return false;
            }
            return true;
        }
        catch (UnsupportedFlavorException e) {
            source.setText(e.getMessage());
        }
        catch (IOException e) {
            source.setText(e.getMessage());
        }
        return false;
    }

    private void importFiles(Transferable transferable, JTextComponent source) throws UnsupportedFlavorException, IOException {
        List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        for (int i = 0; i < files.size(); ++i) {
            source.setText(source.getText() + "\n" + ((File)files.get(i)).toURL());
        }
    }

    private void importStrings(Transferable transferable, JTextComponent source) throws UnsupportedFlavorException, IOException {
        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        String message = null;
        File file2 = new File(string);
        if (file2.exists()) {
            message = file2.toURL().toString();
        } else {
            try {
                URL url = new URL(string);
                url.getContent();
                message = url.toString();
            }
            catch (IOException e) {
                message = "Could not convert string to URL " + string;
            }
        }
        source.setText(source.getText() + "\n" + message);
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.canImportFiles(flavors) || this.canImportStrings(flavors);
    }

    private boolean canImportFiles(DataFlavor[] flavors) {
        return Arrays.asList(flavors).contains(DataFlavor.javaFileListFlavor);
    }

    private boolean canImportStrings(DataFlavor[] flavors) {
        return Arrays.asList(flavors).contains(DataFlavor.stringFlavor);
    }
}

