/*
 * Decompiled with CFR 0.152.
 */
package jehep.textparse;

import java.util.ArrayList;
import java.util.List;
import jehep.textparse.OidNode;
import jehep.ui.Editor;

public class LatexParse {
    private List<OidNode> data = new ArrayList<OidNode>();
    private int[] id_keywords;
    private String[][] keywords = new String[][]{{"\\section", "Sect:"}, {"\\subsection", "  -subsect:"}, {"\\title", "TITLE:"}, {"\\part", "Part:"}, {"\\paragraph", "  -parag:"}};

    public LatexParse() {
        this.id_keywords = new int[this.keywords.length];
    }

    public List<OidNode> Load() {
        this.clear();
        String snode = "";
        block0: for (int i = 0; i < Editor.getLineCount(); ++i) {
            String scomment;
            String text = Editor.getLineText(i);
            for (int ii = 0; ii < this.keywords.length; ++ii) {
                this.id_keywords[ii] = text.indexOf(this.keywords[ii][0]);
            }
            int jtake = -1;
            String jwhat = "";
            int jjtake = 0;
            for (int ii = 0; ii < this.keywords.length; ++ii) {
                if (this.id_keywords[ii] <= -1) continue;
                jtake = this.id_keywords[ii];
                jwhat = this.keywords[ii][1];
                jjtake = ii;
            }
            if (jtake <= -1 || (scomment = text.substring(0, jtake)).indexOf("%") > -1) continue;
            int i1 = text.indexOf("{");
            int i2 = text.indexOf("}");
            if (i1 > -1 && i2 > -1 && i1 < i2) {
                text = text.substring(i1 + 1, i2);
                text = text.trim();
                snode = jwhat + " " + text;
                this.data.add(new OidNode(i, new String(snode)));
                continue;
            }
            if (i1 <= -1 || i2 != -1) continue;
            String stmp = text;
            for (int j = i + 1; j < Editor.getLineCount(); ++j) {
                stmp = stmp + Editor.getLineText(j);
                i2 = (stmp = stmp.replace("\\n", " ")).indexOf("}");
                if (i2 <= -1) continue;
                stmp = stmp.substring(i1 + 1, i2);
                snode = jwhat + " " + stmp;
                this.data.add(new OidNode(i, new String(snode)));
                continue block0;
            }
        }
        return this.data;
    }

    public void clear() {
        this.data.clear();
    }

    public int getSize() {
        return this.data.size();
    }
}

