/*
 * Decompiled with CFR 0.152.
 */
package jehep.textparse;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jehep.textparse.OidNode;
import jehep.ui.Editor;

public class FortranParse {
    private List<OidNode> data = new ArrayList<OidNode>();
    private int[] id_keywords;
    private String[][] keywords = new String[][]{{"program ", ""}, {"function ", ""}, {"subroutine ", ""}};

    public FortranParse() {
        this.id_keywords = new int[this.keywords.length];
    }

    public List<OidNode> Load() {
        this.clear();
        String snode = "";
        for (int i = 0; i < Editor.getLineCount(); ++i) {
            StringTokenizer st;
            int ncount;
            String text = Editor.getLineText(i);
            if ((text = text.toLowerCase()).startsWith("*") || text.startsWith("c")) continue;
            this.id_keywords[0] = text.indexOf(this.keywords[0][0]);
            this.id_keywords[1] = text.indexOf(this.keywords[1][0]);
            this.id_keywords[2] = text.indexOf(this.keywords[2][0]);
            if (this.id_keywords[0] > -1 && (ncount = (st = new StringTokenizer(text)).countTokens()) > 2) {
                this.id_keywords[0] = -1;
            }
            int jtake = -1;
            String jwhat = "";
            int jjtake = 0;
            for (int ii = 0; ii < this.keywords.length; ++ii) {
                if (this.id_keywords[ii] <= -1) continue;
                jtake = this.id_keywords[ii];
                jwhat = this.keywords[ii][1];
                jjtake = ii;
            }
            if (jtake <= -1) continue;
            text = text.trim();
            this.data.add(new OidNode(i, new String(text)));
        }
        return this.data;
    }

    public void clear() {
        this.data.clear();
    }

    public int getSize() {
        return this.data.size();
    }
}

