/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class MatlabTokenMarker
extends TokenMarker {
    public static final String METHOD_DELIMITERS = " \t~!%^*()-+=|\\#/{}[]:;\"'<>,.?@";
    private static KeywordMap cKeywords;
    protected boolean cpp;
    protected boolean javadoc;
    protected KeywordMap keywords;
    protected int lastOffset;
    protected int lastKeyword;
    protected int lastWhitespace;

    public MatlabTokenMarker() {
        this(true, false, MatlabTokenMarker.getKeywords());
    }

    public MatlabTokenMarker(boolean cpp, boolean javadoc, KeywordMap keywords) {
        this.cpp = cpp;
        this.javadoc = javadoc;
        this.keywords = keywords;
    }

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        this.lastWhitespace = offset - 1;
        int length = line.count + offset;
        boolean backslash = false;
        block23: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '(': {
                            if (backslash) {
                                this.doKeyword(line, i, c);
                                backslash = false;
                                break;
                            }
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(this.lastWhitespace - this.lastOffset + 1, token);
                            this.addToken(i - this.lastWhitespace - 1, (byte)11);
                            this.addToken(1, (byte)0);
                            token = 0;
                            this.lastOffset = this.lastKeyword = i1;
                            this.lastWhitespace = i;
                            break;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '%': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            this.lastOffset = this.lastKeyword = length;
                            break block23;
                        }
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            this.lastOffset = this.lastKeyword = length;
                            break block23;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                if (i1 < array.length && array[i1] == ':') {
                                    this.addToken(i1 - this.lastOffset, (byte)0);
                                } else {
                                    this.addToken(i1 - this.lastOffset, (byte)5);
                                }
                                this.lastOffset = this.lastKeyword = i1;
                                this.lastWhitespace = i1;
                                backslash = false;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) continue block23;
                            break;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block23;
                            switch (array[i1]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (this.javadoc && length - i > 2 && array[i + 2] == '*') {
                                        token = (byte)2;
                                        break;
                                    }
                                    token = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.addToken(length - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block23;
                                }
                            }
                            continue block23;
                        }
                        default: {
                            backslash = false;
                            if (!Character.isLetterOrDigit(c) && c != '_') {
                                this.doKeyword(line, i, c);
                            }
                            if (METHOD_DELIMITERS.indexOf(c) == -1) continue block23;
                            this.lastWhitespace = i;
                            break;
                        }
                    }
                    continue block23;
                }
                case 1: 
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block23;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    this.lastWhitespace = i;
                    continue block23;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block23;
                    }
                    if (c != '\"') continue block23;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.lastWhitespace = i;
                    continue block23;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block23;
                    }
                    if (c != '\'') continue block23;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.lastWhitespace = i;
                    continue block23;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (cKeywords == null) {
            cKeywords = new KeywordMap(false);
            cKeywords.add("rat", (byte)8);
            cKeywords.add("realpart", (byte)8);
            cKeywords.add("imagpart", (byte)8);
            cKeywords.add("float", (byte)8);
            cKeywords.add("int", (byte)8);
            cKeywords.add("abs", (byte)8);
            cKeywords.add("sign", (byte)8);
            cKeywords.add("conj", (byte)8);
            cKeywords.add("angle", (byte)8);
            cKeywords.add("cfs", (byte)8);
            cKeywords.add("sqrt", (byte)8);
            cKeywords.add("exp", (byte)8);
            cKeywords.add("log", (byte)8);
            cKeywords.add("sinh", (byte)8);
            cKeywords.add("cosh", (byte)8);
            cKeywords.add("asinh", (byte)8);
            cKeywords.add("acosh", (byte)8);
            cKeywords.add("sech", (byte)8);
            cKeywords.add("csch", (byte)8);
            cKeywords.add("asech", (byte)8);
            cKeywords.add("acsch", (byte)8);
            cKeywords.add("sin", (byte)8);
            cKeywords.add("cos", (byte)8);
            cKeywords.add("tan", (byte)8);
            cKeywords.add("asin", (byte)8);
            cKeywords.add("acos", (byte)8);
            cKeywords.add("atan", (byte)8);
            cKeywords.add("acscatan2", (byte)8);
            cKeywords.add("sec", (byte)8);
            cKeywords.add("csc", (byte)8);
            cKeywords.add("asec", (byte)8);
            cKeywords.add("acsc", (byte)8);
            cKeywords.add("factorial", (byte)8);
            cKeywords.add("nchoosek", (byte)8);
            cKeywords.add("gamma", (byte)8);
            cKeywords.add("gammaln", (byte)8);
            cKeywords.add("length", (byte)8);
            cKeywords.add("zeros", (byte)8);
            cKeywords.add("linspace", (byte)8);
            cKeywords.add("ones", (byte)8);
            cKeywords.add("size", (byte)8);
            cKeywords.add("eye", (byte)8);
            cKeywords.add("rand", (byte)8);
            cKeywords.add("hilb", (byte)8);
            cKeywords.add("find", (byte)8);
            cKeywords.add("invhilb", (byte)8);
            cKeywords.add("max", (byte)8);
            cKeywords.add("min", (byte)8);
            cKeywords.add("diag", (byte)8);
            cKeywords.add("det", (byte)8);
            cKeywords.add("eigen", (byte)8);
            cKeywords.add("qr", (byte)8);
            cKeywords.add("lu", (byte)8);
            cKeywords.add("inv", (byte)8);
            cKeywords.add("eig", (byte)8);
            cKeywords.add("poly", (byte)8);
            cKeywords.add("polyfit", (byte)8);
            cKeywords.add("roots", (byte)8);
            cKeywords.add("gcd", (byte)8);
            cKeywords.add("allroots", (byte)8);
            cKeywords.add("sqfr", (byte)8);
            cKeywords.add("divide", (byte)8);
            cKeywords.add("coeff", (byte)8);
            cKeywords.add("subst", (byte)7);
            cKeywords.add("trigrat", (byte)7);
            cKeywords.add("algsys", (byte)7);
            cKeywords.add("linsolve", (byte)7);
            cKeywords.add("linsolve2", (byte)7);
            cKeywords.add("linlstsq", (byte)7);
            cKeywords.add("fzero", (byte)7);
            cKeywords.add("ode", (byte)7);
            cKeywords.add("taylor", (byte)7);
            cKeywords.add("quad", (byte)7);
            cKeywords.add("romberg", (byte)7);
            cKeywords.add("integrate", (byte)7);
            cKeywords.add("diff", (byte)7);
            cKeywords.add("lsum", (byte)7);
            cKeywords.add("sum", (byte)7);
            cKeywords.add("solve", (byte)7);
            cKeywords.add("plot", (byte)7);
            cKeywords.add("loglog", (byte)7);
            cKeywords.add("linlog", (byte)7);
            cKeywords.add("loglin", (byte)7);
            cKeywords.add("print", (byte)7);
            cKeywords.add("if", (byte)7);
            cKeywords.add("printf", (byte)7);
            cKeywords.add("print", (byte)7);
            cKeywords.add("while", (byte)7);
            cKeywords.add("function", (byte)7);
            cKeywords.add("continue", (byte)7);
            cKeywords.add("end", (byte)7);
            cKeywords.add("break", (byte)7);
            cKeywords.add("for", (byte)7);
            cKeywords.add("title", (byte)7);
            cKeywords.add("xlabel", (byte)7);
            cKeywords.add("ylabel", (byte)7);
        }
        return cKeywords;
    }

    protected boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
            this.lastKeyword = i1;
            this.lastWhitespace = i;
            return true;
        }
        this.lastKeyword = i1;
        return false;
    }
}

