/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.SyntaxUtilities;
import jehep.syntax.TokenMarker;

public class CobolTokenMarker
extends TokenMarker {
    private static KeywordMap cobolKeywords;
    private KeywordMap keywords = CobolTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        block15: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            switch (token) {
                case 0: {
                    switch (c) {
                        case 'E': {
                            if (!SyntaxUtilities.regionMatches(false, line, i1, "XEC SQL")) break;
                            this.doKeyword(line, i, c);
                            i += 7;
                            token = (byte)8;
                            continue block15;
                        }
                        case '*': {
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            token = 0;
                            this.lastOffset = this.lastKeyword = length;
                            break block15;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            continue block15;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            continue block15;
                        }
                        case ' ': {
                            this.doKeyword(line, i, c);
                        }
                    }
                    continue block15;
                }
                case 8: {
                    if (c != 'E' || !SyntaxUtilities.regionMatches(false, line, i1, "ND-EXEC")) continue block15;
                    this.addToken((i += 8) - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i;
                    continue block15;
                }
                case 3: {
                    if (c != '\"') continue block15;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block15;
                }
                case 4: {
                    if (c != '\'') continue block15;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block15;
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            default: 
        }
        this.addToken(length - this.lastOffset, token);
        return token;
        throw new InternalError("Invalid state: " + token);
    }

    public static KeywordMap getKeywords() {
        if (cobolKeywords == null) {
            cobolKeywords = new KeywordMap(false);
            cobolKeywords.add("ACCEPT", (byte)6);
            cobolKeywords.add("ACCESS", (byte)6);
            cobolKeywords.add("ACTUAL", (byte)6);
            cobolKeywords.add("ADD", (byte)6);
            cobolKeywords.add("ADDRESS", (byte)6);
            cobolKeywords.add("ADVANCING", (byte)6);
            cobolKeywords.add("AFTER", (byte)6);
            cobolKeywords.add("ALL", (byte)6);
            cobolKeywords.add("ALPHABET", (byte)6);
            cobolKeywords.add("ALPHABETIC", (byte)6);
            cobolKeywords.add("ALPHABETIC-LOWER", (byte)6);
            cobolKeywords.add("ALPHABETIC-UPPER", (byte)6);
            cobolKeywords.add("ALPHANUMERIC", (byte)6);
            cobolKeywords.add("ALPHANUMERIC-EDITED", (byte)6);
            cobolKeywords.add("ALSO", (byte)6);
            cobolKeywords.add("ALTER", (byte)6);
            cobolKeywords.add("ALTERNATE", (byte)6);
            cobolKeywords.add("AND", (byte)6);
            cobolKeywords.add("ANY", (byte)6);
            cobolKeywords.add("API", (byte)6);
            cobolKeywords.add("APPLY", (byte)6);
            cobolKeywords.add("ARE", (byte)6);
            cobolKeywords.add("AREA", (byte)6);
            cobolKeywords.add("AREAS", (byte)6);
            cobolKeywords.add("ASCENDING", (byte)6);
            cobolKeywords.add("ASSIGN", (byte)6);
            cobolKeywords.add("AT", (byte)6);
            cobolKeywords.add("AUTHOR", (byte)6);
            cobolKeywords.add("AUTO", (byte)6);
            cobolKeywords.add("AUTO-SKIP", (byte)6);
            cobolKeywords.add("AUTOMATIC", (byte)6);
            cobolKeywords.add("BACKGROUND-COLOR", (byte)6);
            cobolKeywords.add("BACKGROUND-COLOUR", (byte)6);
            cobolKeywords.add("BACKWARD", (byte)6);
            cobolKeywords.add("BASIS", (byte)6);
            cobolKeywords.add("BEEP", (byte)6);
            cobolKeywords.add("BEFORE", (byte)6);
            cobolKeywords.add("BEGINNING", (byte)6);
            cobolKeywords.add("BELL", (byte)6);
            cobolKeywords.add("BINARY", (byte)6);
            cobolKeywords.add("BLANK", (byte)6);
            cobolKeywords.add("BLINK", (byte)6);
            cobolKeywords.add("BLOCK", (byte)6);
            cobolKeywords.add("BOTTOM", (byte)6);
            cobolKeywords.add("BY", (byte)6);
            cobolKeywords.add("C01", (byte)6);
            cobolKeywords.add("C02", (byte)6);
            cobolKeywords.add("C03", (byte)6);
            cobolKeywords.add("C04", (byte)6);
            cobolKeywords.add("C05", (byte)6);
            cobolKeywords.add("C06", (byte)6);
            cobolKeywords.add("C07", (byte)6);
            cobolKeywords.add("C08", (byte)6);
            cobolKeywords.add("C09", (byte)6);
            cobolKeywords.add("C10", (byte)6);
            cobolKeywords.add("C11", (byte)6);
            cobolKeywords.add("C12", (byte)6);
            cobolKeywords.add("CALL", (byte)6);
            cobolKeywords.add("CALL-CONVENTION", (byte)6);
            cobolKeywords.add("CANCEL", (byte)6);
            cobolKeywords.add("CBL", (byte)6);
            cobolKeywords.add("CD", (byte)6);
            cobolKeywords.add("CF", (byte)6);
            cobolKeywords.add("CH", (byte)6);
            cobolKeywords.add("CHAIN", (byte)6);
            cobolKeywords.add("CHAINING", (byte)6);
            cobolKeywords.add("CHANGED", (byte)6);
            cobolKeywords.add("CHARACTER", (byte)6);
            cobolKeywords.add("CHARACTERS", (byte)6);
            cobolKeywords.add("CLASS", (byte)6);
            cobolKeywords.add("CLOCK-UNITS", (byte)6);
            cobolKeywords.add("CLOSE", (byte)6);
            cobolKeywords.add("COBOL", (byte)6);
            cobolKeywords.add("CODE", (byte)6);
            cobolKeywords.add("CODE-SET", (byte)6);
            cobolKeywords.add("COL", (byte)6);
            cobolKeywords.add("COLLATING", (byte)6);
            cobolKeywords.add("COLUMN", (byte)6);
            cobolKeywords.add("COM-REG", (byte)6);
            cobolKeywords.add("COMMA", (byte)6);
            cobolKeywords.add("COMMIT", (byte)6);
            cobolKeywords.add("COMMON", (byte)6);
            cobolKeywords.add("COMMUNICATION", (byte)6);
            cobolKeywords.add("COMP", (byte)6);
            cobolKeywords.add("COMP-0", (byte)6);
            cobolKeywords.add("COMP-1", (byte)6);
            cobolKeywords.add("COMP-2", (byte)6);
            cobolKeywords.add("COMP-3", (byte)6);
            cobolKeywords.add("COMP-4", (byte)6);
            cobolKeywords.add("COMP-5", (byte)6);
            cobolKeywords.add("COMP-6", (byte)6);
            cobolKeywords.add("COMP-X", (byte)6);
            cobolKeywords.add("COMPUTATIONAL", (byte)6);
            cobolKeywords.add("COMPUTATIONAL-0", (byte)6);
            cobolKeywords.add("COMPUTATIONAL-1", (byte)6);
            cobolKeywords.add("COMPUTATIONAL-2", (byte)6);
            cobolKeywords.add("COMPUTATIONAL-3", (byte)6);
            cobolKeywords.add("COMPUTATIONAL-4", (byte)6);
            cobolKeywords.add("COMPUTATIONAL-5", (byte)6);
            cobolKeywords.add("COMPUTATIONAL-6", (byte)6);
            cobolKeywords.add("COMPUTATIONAL-X", (byte)6);
            cobolKeywords.add("COMPUTE", (byte)6);
            cobolKeywords.add("CONFIGURATION", (byte)6);
            cobolKeywords.add("CONSOLE", (byte)6);
            cobolKeywords.add("CONTAINS", (byte)6);
            cobolKeywords.add("CONTENT", (byte)6);
            cobolKeywords.add("CONTINUE", (byte)6);
            cobolKeywords.add("CONTROL", (byte)6);
            cobolKeywords.add("CONTROLS", (byte)6);
            cobolKeywords.add("CONVERTING", (byte)6);
            cobolKeywords.add("COPY", (byte)6);
            cobolKeywords.add("CORE-INDEX", (byte)6);
            cobolKeywords.add("CORR", (byte)6);
            cobolKeywords.add("CORRESPONDING", (byte)6);
            cobolKeywords.add("COUNT", (byte)6);
            cobolKeywords.add("CRT", (byte)6);
            cobolKeywords.add("CRT-UNDER", (byte)6);
            cobolKeywords.add("CURRENCY", (byte)6);
            cobolKeywords.add("CURRENT-DATE", (byte)6);
            cobolKeywords.add("CURSOR", (byte)6);
            cobolKeywords.add("CYCLE", (byte)6);
            cobolKeywords.add("CYL-INDEX", (byte)6);
            cobolKeywords.add("CYL-OVERFLOW", (byte)6);
            cobolKeywords.add("DATA", (byte)6);
            cobolKeywords.add("DATE", (byte)6);
            cobolKeywords.add("DATE-COMPILED", (byte)6);
            cobolKeywords.add("DATE-WRITTEN", (byte)6);
            cobolKeywords.add("DAY", (byte)6);
            cobolKeywords.add("DAY-OF-WEEK", (byte)6);
            cobolKeywords.add("DBCS", (byte)6);
            cobolKeywords.add("DE", (byte)6);
            cobolKeywords.add("DEBUG", (byte)6);
            cobolKeywords.add("DEBUG-CONTENTS", (byte)6);
            cobolKeywords.add("DEBUG-ITEM", (byte)6);
            cobolKeywords.add("DEBUG-LINE", (byte)6);
            cobolKeywords.add("DEBUG-NAME", (byte)6);
            cobolKeywords.add("DEBUG-SUB-1", (byte)6);
            cobolKeywords.add("DEBUG-SUB-2", (byte)6);
            cobolKeywords.add("DEBUG-SUB-3", (byte)6);
            cobolKeywords.add("DEBUGGING", (byte)6);
            cobolKeywords.add("DECIMAL-POINT", (byte)6);
            cobolKeywords.add("DECLARATIVES", (byte)6);
            cobolKeywords.add("DELETE", (byte)6);
            cobolKeywords.add("DELIMITED", (byte)6);
            cobolKeywords.add("DELIMITER", (byte)6);
            cobolKeywords.add("DEPENDING", (byte)6);
            cobolKeywords.add("DESCENDING", (byte)6);
            cobolKeywords.add("DESTINATION", (byte)6);
            cobolKeywords.add("DETAIL", (byte)6);
            cobolKeywords.add("DISABLE", (byte)6);
            cobolKeywords.add("DISK", (byte)6);
            cobolKeywords.add("DISP", (byte)6);
            cobolKeywords.add("DISPLAY", (byte)6);
            cobolKeywords.add("DISPLAY-1", (byte)6);
            cobolKeywords.add("DISPLAY-ST", (byte)6);
            cobolKeywords.add("DIVIDE", (byte)6);
            cobolKeywords.add("DIVISION", (byte)6);
            cobolKeywords.add("DOWN", (byte)6);
            cobolKeywords.add("DUPLICATES", (byte)6);
            cobolKeywords.add("DYNAMIC", (byte)6);
            cobolKeywords.add("ECHO", (byte)6);
            cobolKeywords.add("EGCS", (byte)6);
            cobolKeywords.add("EGI", (byte)6);
            cobolKeywords.add("EJECT", (byte)6);
            cobolKeywords.add("ELSE", (byte)6);
            cobolKeywords.add("EMI", (byte)6);
            cobolKeywords.add("EMPTY-CHECK", (byte)6);
            cobolKeywords.add("ENABLE", (byte)6);
            cobolKeywords.add("END", (byte)6);
            cobolKeywords.add("END-ACCEPT", (byte)6);
            cobolKeywords.add("END-ADD", (byte)6);
            cobolKeywords.add("END-CALL", (byte)6);
            cobolKeywords.add("END-CHAIN", (byte)6);
            cobolKeywords.add("END-COMPUTE", (byte)6);
            cobolKeywords.add("END-DELETE", (byte)6);
            cobolKeywords.add("END-DISPLAY", (byte)6);
            cobolKeywords.add("END-DIVIDE", (byte)6);
            cobolKeywords.add("END-EVALUATE", (byte)6);
            cobolKeywords.add("END-IF", (byte)6);
            cobolKeywords.add("END-INVOKE", (byte)6);
            cobolKeywords.add("END-MULTIPLY", (byte)6);
            cobolKeywords.add("END-OF-PAGE", (byte)6);
            cobolKeywords.add("END-PERFORM", (byte)6);
            cobolKeywords.add("END-READ", (byte)6);
            cobolKeywords.add("END-RECEIVE", (byte)6);
            cobolKeywords.add("END-RETURN", (byte)6);
            cobolKeywords.add("END-REWRITE", (byte)6);
            cobolKeywords.add("END-SEARCH", (byte)6);
            cobolKeywords.add("END-START", (byte)6);
            cobolKeywords.add("END-STRING", (byte)6);
            cobolKeywords.add("END-SUBTRACT", (byte)6);
            cobolKeywords.add("END-UNSTRING", (byte)6);
            cobolKeywords.add("END-WRITE", (byte)6);
            cobolKeywords.add("ENDING", (byte)6);
            cobolKeywords.add("ENTER", (byte)6);
            cobolKeywords.add("ENTRY", (byte)6);
            cobolKeywords.add("ENVIRONMENT", (byte)6);
            cobolKeywords.add("EOL", (byte)6);
            cobolKeywords.add("EOP", (byte)6);
            cobolKeywords.add("EOS", (byte)6);
            cobolKeywords.add("EQUAL", (byte)6);
            cobolKeywords.add("EQUALS", (byte)6);
            cobolKeywords.add("ERASE", (byte)6);
            cobolKeywords.add("ERROR", (byte)6);
            cobolKeywords.add("ESCAPE", (byte)6);
            cobolKeywords.add("ESI", (byte)6);
            cobolKeywords.add("EVALUATE", (byte)6);
            cobolKeywords.add("EVERY", (byte)6);
            cobolKeywords.add("EXAMINE", (byte)6);
            cobolKeywords.add("EXCEEDS", (byte)6);
            cobolKeywords.add("EXCEPTION", (byte)6);
            cobolKeywords.add("EXCESS-3", (byte)6);
            cobolKeywords.add("EXCLUSIVE", (byte)6);
            cobolKeywords.add("EXEC", (byte)6);
            cobolKeywords.add("EXECUTE", (byte)6);
            cobolKeywords.add("EXHIBIT", (byte)6);
            cobolKeywords.add("EXIT", (byte)6);
            cobolKeywords.add("EXTEND", (byte)6);
            cobolKeywords.add("EXTENDED-SEARCH", (byte)6);
            cobolKeywords.add("EXTERNAL", (byte)6);
            cobolKeywords.add("FACTORY", (byte)6);
            cobolKeywords.add("FALSE", (byte)6);
            cobolKeywords.add("FD", (byte)6);
            cobolKeywords.add("FH-FCD", (byte)6);
            cobolKeywords.add("FH-KEYDEF", (byte)6);
            cobolKeywords.add("FILE", (byte)6);
            cobolKeywords.add("FILE-CONTROL", (byte)6);
            cobolKeywords.add("FILE-ID", (byte)6);
            cobolKeywords.add("FILE-LIMIT", (byte)6);
            cobolKeywords.add("FILE-LIMITS", (byte)6);
            cobolKeywords.add("FILLER", (byte)6);
            cobolKeywords.add("FINAL", (byte)6);
            cobolKeywords.add("FIRST", (byte)6);
            cobolKeywords.add("FIXED", (byte)6);
            cobolKeywords.add("FOOTING", (byte)6);
            cobolKeywords.add("FOR", (byte)6);
            cobolKeywords.add("FOREGROUND-COLOR", (byte)6);
            cobolKeywords.add("FOREGROUND-COLOUR", (byte)6);
            cobolKeywords.add("FROM", (byte)6);
            cobolKeywords.add("FULL", (byte)6);
            cobolKeywords.add("FUNCTION", (byte)6);
            cobolKeywords.add("GENERATE", (byte)6);
            cobolKeywords.add("GIVING", (byte)6);
            cobolKeywords.add("GLOBAL", (byte)6);
            cobolKeywords.add("GO", (byte)6);
            cobolKeywords.add("GOBACK", (byte)6);
            cobolKeywords.add("GREATER", (byte)6);
            cobolKeywords.add("GRID", (byte)6);
            cobolKeywords.add("GROUP", (byte)6);
            cobolKeywords.add("HEADING", (byte)6);
            cobolKeywords.add("HIGH", (byte)6);
            cobolKeywords.add("HIGH-VALUE", (byte)6);
            cobolKeywords.add("HIGH-VALUES", (byte)6);
            cobolKeywords.add("HIGHLIGHT", (byte)6);
            cobolKeywords.add("I-O", (byte)6);
            cobolKeywords.add("I-O-CONTROL", (byte)6);
            cobolKeywords.add("ID", (byte)6);
            cobolKeywords.add("IDENTIFICATION", (byte)6);
            cobolKeywords.add("IF", (byte)6);
            cobolKeywords.add("IGNORE", (byte)6);
            cobolKeywords.add("IN", (byte)6);
            cobolKeywords.add("INDEX", (byte)6);
            cobolKeywords.add("INDEXED", (byte)6);
            cobolKeywords.add("INDICATE", (byte)6);
            cobolKeywords.add("INHERITING", (byte)6);
            cobolKeywords.add("INITIAL", (byte)6);
            cobolKeywords.add("INITIALIZE", (byte)6);
            cobolKeywords.add("INITIATE", (byte)6);
            cobolKeywords.add("INPUT", (byte)6);
            cobolKeywords.add("INPUT-OUTPUT", (byte)6);
            cobolKeywords.add("INSERT", (byte)6);
            cobolKeywords.add("INSPECT", (byte)6);
            cobolKeywords.add("INSTALLATION", (byte)6);
            cobolKeywords.add("INTO", (byte)6);
            cobolKeywords.add("INVALID", (byte)6);
            cobolKeywords.add("INVOKE", (byte)6);
            cobolKeywords.add("IS", (byte)6);
            cobolKeywords.add("JAPANESE", (byte)6);
            cobolKeywords.add("JUST", (byte)6);
            cobolKeywords.add("JUSTIFIED", (byte)6);
            cobolKeywords.add("KANJI", (byte)6);
            cobolKeywords.add("KEPT", (byte)6);
            cobolKeywords.add("KEY", (byte)6);
            cobolKeywords.add("KEYBOARD", (byte)6);
            cobolKeywords.add("LABEL", (byte)6);
            cobolKeywords.add("LAST", (byte)6);
            cobolKeywords.add("LEADING", (byte)6);
            cobolKeywords.add("LEAVE", (byte)6);
            cobolKeywords.add("LEFT", (byte)6);
            cobolKeywords.add("LEFT-JUSTIFY", (byte)6);
            cobolKeywords.add("LEFTLINE", (byte)6);
            cobolKeywords.add("LENGTH", (byte)6);
            cobolKeywords.add("LENGTH-CHECK", (byte)6);
            cobolKeywords.add("LESS", (byte)6);
            cobolKeywords.add("LIMIT", (byte)6);
            cobolKeywords.add("LIMITS", (byte)6);
            cobolKeywords.add("LIN", (byte)6);
            cobolKeywords.add("LINAGE", (byte)6);
            cobolKeywords.add("LINAGE-COUNTER", (byte)6);
            cobolKeywords.add("LINE", (byte)6);
            cobolKeywords.add("LINE-COUNTER", (byte)6);
            cobolKeywords.add("LINES", (byte)6);
            cobolKeywords.add("LINKAGE", (byte)6);
            cobolKeywords.add("LOCAL-STORAGE", (byte)6);
            cobolKeywords.add("LOCK", (byte)6);
            cobolKeywords.add("LOCKING", (byte)6);
            cobolKeywords.add("LOW", (byte)6);
            cobolKeywords.add("LOW-VALUE", (byte)6);
            cobolKeywords.add("LOW-VALUES", (byte)6);
            cobolKeywords.add("LOWER", (byte)6);
            cobolKeywords.add("LOWLIGHT", (byte)6);
            cobolKeywords.add("MANUAL", (byte)6);
            cobolKeywords.add("MASTER-INDEX", (byte)6);
            cobolKeywords.add("MEMORY", (byte)6);
            cobolKeywords.add("MERGE", (byte)6);
            cobolKeywords.add("MESSAGE", (byte)6);
            cobolKeywords.add("METHOD", (byte)6);
            cobolKeywords.add("MODE", (byte)6);
            cobolKeywords.add("MODULES", (byte)6);
            cobolKeywords.add("MORE-LABELS", (byte)6);
            cobolKeywords.add("MOVE", (byte)6);
            cobolKeywords.add("MULTIPLE", (byte)6);
            cobolKeywords.add("MULTIPLY", (byte)6);
            cobolKeywords.add("NAME", (byte)6);
            cobolKeywords.add("NAMED", (byte)6);
            cobolKeywords.add("NATIONAL", (byte)6);
            cobolKeywords.add("NATIONAL-EDITED", (byte)6);
            cobolKeywords.add("NATIVE", (byte)6);
            cobolKeywords.add("NCHAR", (byte)6);
            cobolKeywords.add("NEGATIVE", (byte)6);
            cobolKeywords.add("NEXT", (byte)6);
            cobolKeywords.add("NO", (byte)6);
            cobolKeywords.add("NO-ECHO", (byte)6);
            cobolKeywords.add("NOMINAL", (byte)6);
            cobolKeywords.add("NOT", (byte)6);
            cobolKeywords.add("NOTE", (byte)6);
            cobolKeywords.add("NSTD-REELS", (byte)6);
            cobolKeywords.add("NULL", (byte)6);
            cobolKeywords.add("NULLS", (byte)6);
            cobolKeywords.add("NUMBER", (byte)6);
            cobolKeywords.add("NUMERIC", (byte)6);
            cobolKeywords.add("NUMERIC-EDITED", (byte)6);
            cobolKeywords.add("OBJECT", (byte)6);
            cobolKeywords.add("OBJECT-COMPUTER", (byte)6);
            cobolKeywords.add("OBJECT-STORAGE", (byte)6);
            cobolKeywords.add("OCCURS", (byte)6);
            cobolKeywords.add("OF", (byte)6);
            cobolKeywords.add("OFF", (byte)6);
            cobolKeywords.add("OMITTED", (byte)6);
            cobolKeywords.add("ON", (byte)6);
            cobolKeywords.add("OOSTACKPTR", (byte)6);
            cobolKeywords.add("OPEN", (byte)6);
            cobolKeywords.add("OPTIONAL", (byte)6);
            cobolKeywords.add("OR", (byte)6);
            cobolKeywords.add("ORDER", (byte)6);
            cobolKeywords.add("ORGANIZATION", (byte)6);
            cobolKeywords.add("OTHER", (byte)6);
            cobolKeywords.add("OTHERWISE", (byte)6);
            cobolKeywords.add("OUTPUT", (byte)6);
            cobolKeywords.add("OVERFLOW", (byte)6);
            cobolKeywords.add("OVERLINE", (byte)6);
            cobolKeywords.add("PACKED-DECIMAL", (byte)6);
            cobolKeywords.add("PADDING", (byte)6);
            cobolKeywords.add("PAGE", (byte)6);
            cobolKeywords.add("PAGE-COUNTER", (byte)6);
            cobolKeywords.add("PARAGRAPH", (byte)6);
            cobolKeywords.add("PASSWORD", (byte)6);
            cobolKeywords.add("PERFORM", (byte)6);
            cobolKeywords.add("PF", (byte)6);
            cobolKeywords.add("PH", (byte)6);
            cobolKeywords.add("PIC", (byte)6);
            cobolKeywords.add("PICTURE", (byte)6);
            cobolKeywords.add("PLUS", (byte)6);
            cobolKeywords.add("POINTER", (byte)6);
            cobolKeywords.add("POS", (byte)6);
            cobolKeywords.add("POSITION", (byte)6);
            cobolKeywords.add("POSITIONING", (byte)6);
            cobolKeywords.add("POSITIVE", (byte)6);
            cobolKeywords.add("PREVIOUS", (byte)6);
            cobolKeywords.add("PRINT", (byte)6);
            cobolKeywords.add("PRINT-SWITCH", (byte)6);
            cobolKeywords.add("PRINTER", (byte)6);
            cobolKeywords.add("PRINTER-1", (byte)6);
            cobolKeywords.add("PRINTING", (byte)6);
            cobolKeywords.add("PRIVATE", (byte)6);
            cobolKeywords.add("PROCEDURE", (byte)6);
            cobolKeywords.add("PROCEDURE-POINTER", (byte)6);
            cobolKeywords.add("PROCEDURES", (byte)6);
            cobolKeywords.add("PROCEED", (byte)6);
            cobolKeywords.add("PROCESSING", (byte)6);
            cobolKeywords.add("PROGRAM", (byte)6);
            cobolKeywords.add("PROGRAM-ID", (byte)6);
            cobolKeywords.add("PROMPT", (byte)6);
            cobolKeywords.add("PROTECTED", (byte)6);
            cobolKeywords.add("PUBLIC", (byte)6);
            cobolKeywords.add("PURGE", (byte)6);
            cobolKeywords.add("QUEUE", (byte)6);
            cobolKeywords.add("QUOTE", (byte)6);
            cobolKeywords.add("QUOTES", (byte)6);
            cobolKeywords.add("RANDOM", (byte)6);
            cobolKeywords.add("RANGE", (byte)6);
            cobolKeywords.add("RD", (byte)6);
            cobolKeywords.add("READ", (byte)6);
            cobolKeywords.add("READY", (byte)6);
            cobolKeywords.add("RECEIVE", (byte)6);
            cobolKeywords.add("RECORD", (byte)6);
            cobolKeywords.add("RECORD-OVERFLOW", (byte)6);
            cobolKeywords.add("RECORDING", (byte)6);
            cobolKeywords.add("RECORDS", (byte)6);
            cobolKeywords.add("REDEFINES", (byte)6);
            cobolKeywords.add("REEL", (byte)6);
            cobolKeywords.add("REFERENCE", (byte)6);
            cobolKeywords.add("REFERENCES", (byte)6);
            cobolKeywords.add("RELATIVE", (byte)6);
            cobolKeywords.add("RELEASE", (byte)6);
            cobolKeywords.add("RELOAD", (byte)6);
            cobolKeywords.add("REMAINDER", (byte)6);
            cobolKeywords.add("REMARKS", (byte)6);
            cobolKeywords.add("REMOVAL", (byte)6);
            cobolKeywords.add("RENAMES", (byte)6);
            cobolKeywords.add("REORG-CRITERIA", (byte)6);
            cobolKeywords.add("REPLACE", (byte)6);
            cobolKeywords.add("REPLACING", (byte)6);
            cobolKeywords.add("REPORT", (byte)6);
            cobolKeywords.add("REPORTING", (byte)6);
            cobolKeywords.add("REPORTS", (byte)6);
            cobolKeywords.add("REQUIRED", (byte)6);
            cobolKeywords.add("REREAD", (byte)6);
            cobolKeywords.add("RERUN", (byte)6);
            cobolKeywords.add("RESERVE", (byte)6);
            cobolKeywords.add("RESET", (byte)6);
            cobolKeywords.add("RETURN", (byte)6);
            cobolKeywords.add("RETURN-CODE", (byte)6);
            cobolKeywords.add("RETURNING", (byte)6);
            cobolKeywords.add("REVERSE", (byte)6);
            cobolKeywords.add("REVERSE-VIDEO", (byte)6);
            cobolKeywords.add("REVERSED", (byte)6);
            cobolKeywords.add("REWIND", (byte)6);
            cobolKeywords.add("REWRITE", (byte)6);
            cobolKeywords.add("RF", (byte)6);
            cobolKeywords.add("RH", (byte)6);
            cobolKeywords.add("RIGHT", (byte)6);
            cobolKeywords.add("RIGHT-JUSTIFY", (byte)6);
            cobolKeywords.add("ROLLBACK", (byte)6);
            cobolKeywords.add("ROUNDED", (byte)6);
            cobolKeywords.add("RUN", (byte)6);
            cobolKeywords.add("S01", (byte)6);
            cobolKeywords.add("S02", (byte)6);
            cobolKeywords.add("S03", (byte)6);
            cobolKeywords.add("S04", (byte)6);
            cobolKeywords.add("S05", (byte)6);
            cobolKeywords.add("SAME", (byte)6);
            cobolKeywords.add("SCREEN", (byte)6);
            cobolKeywords.add("SD", (byte)6);
            cobolKeywords.add("SEARCH", (byte)6);
            cobolKeywords.add("SECTION", (byte)6);
            cobolKeywords.add("SECURE", (byte)6);
            cobolKeywords.add("SECURITY", (byte)6);
            cobolKeywords.add("SEEK", (byte)6);
            cobolKeywords.add("SEGMENT", (byte)6);
            cobolKeywords.add("SEGMENT-LIMIT", (byte)6);
            cobolKeywords.add("SELECT", (byte)6);
            cobolKeywords.add("SELECTIVE", (byte)6);
            cobolKeywords.add("SEND", (byte)6);
            cobolKeywords.add("SENTENCE", (byte)6);
            cobolKeywords.add("SEPARATE", (byte)6);
            cobolKeywords.add("SEQUENCE", (byte)6);
            cobolKeywords.add("SEQUENTIAL", (byte)6);
            cobolKeywords.add("SERVICE", (byte)6);
            cobolKeywords.add("SET", (byte)6);
            cobolKeywords.add("SHIFT-IN", (byte)6);
            cobolKeywords.add("SHIFT-OUT", (byte)6);
            cobolKeywords.add("SIGN", (byte)6);
            cobolKeywords.add("SIZE", (byte)6);
            cobolKeywords.add("SKIP1", (byte)6);
            cobolKeywords.add("SKIP2", (byte)6);
            cobolKeywords.add("SKIP3", (byte)6);
            cobolKeywords.add("SORT", (byte)6);
            cobolKeywords.add("SORT-CONTROL", (byte)6);
            cobolKeywords.add("SORT-CORE-SIZE", (byte)6);
            cobolKeywords.add("SORT-FILE-SIZE", (byte)6);
            cobolKeywords.add("SORT-MERGE", (byte)6);
            cobolKeywords.add("SORT-MESSAGE", (byte)6);
            cobolKeywords.add("SORT-MODE-SIZE", (byte)6);
            cobolKeywords.add("SORT-OPTION", (byte)6);
            cobolKeywords.add("SORT-RETURN", (byte)6);
            cobolKeywords.add("SOURCE", (byte)6);
            cobolKeywords.add("SOURCE-COMPUTER", (byte)6);
            cobolKeywords.add("SPACE", (byte)6);
            cobolKeywords.add("SPACE-FILL", (byte)6);
            cobolKeywords.add("SPACES", (byte)6);
            cobolKeywords.add("SPECIAL-NAMES", (byte)6);
            cobolKeywords.add("STANDARD", (byte)6);
            cobolKeywords.add("STANDARD-1", (byte)6);
            cobolKeywords.add("STANDARD-2", (byte)6);
            cobolKeywords.add("START", (byte)6);
            cobolKeywords.add("STATUS", (byte)6);
            cobolKeywords.add("STOP", (byte)6);
            cobolKeywords.add("STORE", (byte)6);
            cobolKeywords.add("STRING", (byte)6);
            cobolKeywords.add("SUB-QUEUE-1", (byte)6);
            cobolKeywords.add("SUB-QUEUE-2", (byte)6);
            cobolKeywords.add("SUB-QUEUE-3", (byte)6);
            cobolKeywords.add("SUBTRACT", (byte)6);
            cobolKeywords.add("SUM", (byte)6);
            cobolKeywords.add("SUPER", (byte)6);
            cobolKeywords.add("SUPPRESS", (byte)6);
            cobolKeywords.add("SYMBOLIC", (byte)6);
            cobolKeywords.add("SYNC", (byte)6);
            cobolKeywords.add("SYNCHRONIZED", (byte)6);
            cobolKeywords.add("SYSIN", (byte)6);
            cobolKeywords.add("SYSIPT", (byte)6);
            cobolKeywords.add("SYSLST", (byte)6);
            cobolKeywords.add("SYSOUT", (byte)6);
            cobolKeywords.add("SYSPCH", (byte)6);
            cobolKeywords.add("SYSPUNCH", (byte)6);
            cobolKeywords.add("TAB", (byte)6);
            cobolKeywords.add("TABLE", (byte)6);
            cobolKeywords.add("TALLY", (byte)6);
            cobolKeywords.add("TALLYING", (byte)6);
            cobolKeywords.add("TAPE", (byte)6);
            cobolKeywords.add("TERMINAL", (byte)6);
            cobolKeywords.add("TERMINATE", (byte)6);
            cobolKeywords.add("TEST", (byte)6);
            cobolKeywords.add("TEXT", (byte)6);
            cobolKeywords.add("THAN", (byte)6);
            cobolKeywords.add("THEN", (byte)6);
            cobolKeywords.add("THROUGH", (byte)6);
            cobolKeywords.add("THRU", (byte)6);
            cobolKeywords.add("TIME", (byte)6);
            cobolKeywords.add("TIME-OF-DAY", (byte)6);
            cobolKeywords.add("TIME-OUT", (byte)6);
            cobolKeywords.add("TIMEOUT", (byte)6);
            cobolKeywords.add("TIMES", (byte)6);
            cobolKeywords.add("TITLE", (byte)6);
            cobolKeywords.add("TO", (byte)6);
            cobolKeywords.add("TOP", (byte)6);
            cobolKeywords.add("TOTALED", (byte)6);
            cobolKeywords.add("TOTALING", (byte)6);
            cobolKeywords.add("TRACE", (byte)6);
            cobolKeywords.add("TRACK-AREA", (byte)6);
            cobolKeywords.add("TRACK-LIMIT", (byte)6);
            cobolKeywords.add("TRACKS", (byte)6);
            cobolKeywords.add("TRAILING", (byte)6);
            cobolKeywords.add("TRAILING-SIGN", (byte)6);
            cobolKeywords.add("TRANSFORM", (byte)6);
            cobolKeywords.add("TRUE", (byte)6);
            cobolKeywords.add("TYPE", (byte)6);
            cobolKeywords.add("TYPEDEF", (byte)6);
            cobolKeywords.add("UNDERLINE", (byte)6);
            cobolKeywords.add("UNEQUAL", (byte)6);
            cobolKeywords.add("UNIT", (byte)6);
            cobolKeywords.add("UNLOCK", (byte)6);
            cobolKeywords.add("UNSTRING", (byte)6);
            cobolKeywords.add("UNTIL", (byte)6);
            cobolKeywords.add("UP", (byte)6);
            cobolKeywords.add("UPDATE", (byte)6);
            cobolKeywords.add("UPON", (byte)6);
            cobolKeywords.add("UPPER", (byte)6);
            cobolKeywords.add("UPSI-0", (byte)6);
            cobolKeywords.add("UPSI-1", (byte)6);
            cobolKeywords.add("UPSI-2", (byte)6);
            cobolKeywords.add("UPSI-3", (byte)6);
            cobolKeywords.add("UPSI-4", (byte)6);
            cobolKeywords.add("UPSI-5", (byte)6);
            cobolKeywords.add("UPSI-6", (byte)6);
            cobolKeywords.add("UPSI-7", (byte)6);
            cobolKeywords.add("USAGE", (byte)6);
            cobolKeywords.add("USE", (byte)6);
            cobolKeywords.add("USER", (byte)6);
            cobolKeywords.add("USING", (byte)6);
            cobolKeywords.add("VALUE", (byte)6);
            cobolKeywords.add("VALUES", (byte)6);
            cobolKeywords.add("VARIABLE", (byte)6);
            cobolKeywords.add("VARYING", (byte)6);
            cobolKeywords.add("WAIT", (byte)6);
            cobolKeywords.add("WHEN", (byte)6);
            cobolKeywords.add("WHEN-COMPILED", (byte)6);
            cobolKeywords.add("WITH", (byte)6);
            cobolKeywords.add("WORDS", (byte)6);
            cobolKeywords.add("WORKING-STORAGE", (byte)6);
            cobolKeywords.add("WRITE", (byte)6);
            cobolKeywords.add("WRITE-ONLY", (byte)6);
            cobolKeywords.add("WRITE-VERIFY", (byte)6);
            cobolKeywords.add("ZERO", (byte)6);
            cobolKeywords.add("ZERO-FILL", (byte)6);
            cobolKeywords.add("ZEROES", (byte)6);
            cobolKeywords.add("ZEROS", (byte)6);
            cobolKeywords.add("ACOS", (byte)7);
            cobolKeywords.add("ANNUITY", (byte)7);
            cobolKeywords.add("ASIN", (byte)7);
            cobolKeywords.add("ATAN", (byte)7);
            cobolKeywords.add("CHAR", (byte)7);
            cobolKeywords.add("COS", (byte)7);
            cobolKeywords.add("CURRENT-DATE", (byte)7);
            cobolKeywords.add("DATE-OF-INTEGER", (byte)7);
            cobolKeywords.add("DAY-OF-INTEGER", (byte)7);
            cobolKeywords.add("FACTORIAL", (byte)7);
            cobolKeywords.add("INTEGER", (byte)7);
            cobolKeywords.add("INTEGER-OF-DATE", (byte)7);
            cobolKeywords.add("INTEGER-OF-DAY", (byte)7);
            cobolKeywords.add("INTEGER-PART", (byte)7);
            cobolKeywords.add("LOG", (byte)7);
            cobolKeywords.add("LOG10", (byte)7);
            cobolKeywords.add("LOWER-CASE", (byte)7);
            cobolKeywords.add("MAX", (byte)7);
            cobolKeywords.add("MEAN", (byte)7);
            cobolKeywords.add("MEDIAN", (byte)7);
            cobolKeywords.add("MIDRANGE", (byte)7);
            cobolKeywords.add("MIN", (byte)7);
            cobolKeywords.add("MOD", (byte)7);
            cobolKeywords.add("NUMVAL", (byte)7);
            cobolKeywords.add("NUMVAL-C", (byte)7);
            cobolKeywords.add("ORD", (byte)7);
            cobolKeywords.add("ORD-MAX", (byte)7);
            cobolKeywords.add("ORD-MIN", (byte)7);
            cobolKeywords.add("PRESENT-VALUE", (byte)7);
            cobolKeywords.add("RANDOM", (byte)7);
            cobolKeywords.add("RANGE", (byte)7);
            cobolKeywords.add("REM", (byte)7);
            cobolKeywords.add("REVERSE", (byte)7);
            cobolKeywords.add("SIN", (byte)7);
            cobolKeywords.add("SQRT", (byte)7);
            cobolKeywords.add("STANDARD-DEVIATION", (byte)7);
            cobolKeywords.add("SUM", (byte)7);
            cobolKeywords.add("TAN", (byte)7);
            cobolKeywords.add("UPPER-CASE", (byte)7);
            cobolKeywords.add("VARIANCE", (byte)7);
            cobolKeywords.add("WHEN-COMPILED", (byte)7);
            cobolKeywords.add("[COPY-PREFIX]", (byte)4);
            cobolKeywords.add("[COUNT]", (byte)4);
            cobolKeywords.add("[DISPLAY]", (byte)4);
            cobolKeywords.add("[EXECUTE]", (byte)4);
            cobolKeywords.add("[PG]", (byte)4);
            cobolKeywords.add("[PREFIX]", (byte)4);
            cobolKeywords.add("[PROGRAM]", (byte)4);
            cobolKeywords.add("[SPECIAL-PREFIX]", (byte)4);
            cobolKeywords.add("[TESTCASE]", (byte)4);
        }
        return cobolKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

