/*
 * Decompiled with CFR 0.152.
 */
package jehep.misc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.File;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jehep.misc.FindFilter;
import jehep.misc.FindFilterFactory;
import jehep.misc.FindProgressCallback;

class FindByDate
extends JPanel
implements FindFilterFactory {
    public static String THE_BIG_BANG = "The Big Bang";
    public static String THE_BIG_CRUNCH = "The Big Crunch";
    public static String YESTERDAY = "Yesterday";
    public static String TODAY = "Today";
    public static String NOW = "Now";
    public static String MODIFIED_LABEL = "Modified";
    public static String FORMAT_LABEL = "mm/dd/yyyy";
    public static String FROM_DATE_LABEL = "between start of";
    public static String TO_DATE_LABEL = "and end of";
    protected JComboBox fromDateField = null;
    protected JComboBox toDateField = null;
    protected String[] fromDateItems = new String[]{THE_BIG_BANG, YESTERDAY, TODAY};
    protected String[] toDateItems = new String[]{THE_BIG_CRUNCH, TODAY, NOW, YESTERDAY};

    FindByDate() {
        this.setLayout(new BorderLayout());
        Font font = new Font("Helvetica", 0, 10);
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(0, 2, 2, 2));
        JLabel modified = new JLabel(MODIFIED_LABEL, 2);
        modified.setFont(font);
        modified.setForeground(Color.black);
        p.add(modified);
        JLabel format = new JLabel(FORMAT_LABEL, 2);
        format.setFont(font);
        format.setForeground(Color.black);
        p.add(format);
        JLabel betweenLabel = new JLabel(FROM_DATE_LABEL, 4);
        betweenLabel.setFont(font);
        betweenLabel.setForeground(Color.black);
        p.add(betweenLabel);
        this.fromDateField = new JComboBox<String>(this.fromDateItems);
        this.fromDateField.setFont(font);
        this.fromDateField.setEditable(true);
        p.add(this.fromDateField);
        JLabel andLabel = new JLabel(TO_DATE_LABEL, 4);
        andLabel.setFont(font);
        andLabel.setForeground(Color.black);
        p.add(andLabel);
        this.toDateField = new JComboBox<String>(this.toDateItems);
        this.toDateField.setFont(font);
        this.toDateField.setEditable(true);
        p.add(this.toDateField);
        this.add((Component)p, "North");
    }

    @Override
    public FindFilter createFindFilter() {
        long from = -1L;
        long to = -1L;
        from = this.startDateToTime((String)this.fromDateField.getSelectedItem());
        to = this.endDateToTime((String)this.toDateField.getSelectedItem());
        return new DateFilter(from, to);
    }

    protected long startDateToTime(String s) {
        if (s == null) {
            return -1L;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        Date d = formatter.parse(s, new ParsePosition(0));
        if (d == null) {
            if (s.equalsIgnoreCase(TODAY)) {
                String today = formatter.format(new Date());
                d = formatter.parse(today, new ParsePosition(0));
            } else if (s.equalsIgnoreCase(YESTERDAY)) {
                String yesterday = formatter.format(new Date(new Date().getTime() - 86400000L));
                d = formatter.parse(yesterday, new ParsePosition(0));
            } else if (s.equalsIgnoreCase(THE_BIG_BANG)) {
                return 0L;
            }
        }
        if (d != null) {
            return d.getTime();
        }
        return -1L;
    }

    protected long endDateToTime(String s) {
        if (s == null) {
            return -1L;
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy");
        long time = -1L;
        Date d = dateFormatter.parse(s, new ParsePosition(0));
        if (d == null) {
            if (s.equalsIgnoreCase(TODAY)) {
                String today = dateFormatter.format(new Date());
                d = dateFormatter.parse(today, new ParsePosition(0));
                if (d != null) {
                    time = d.getTime() + 86400000L;
                }
            } else if (s.equalsIgnoreCase(YESTERDAY)) {
                String yesterday = dateFormatter.format(new Date(new Date().getTime() - 86400000L));
                d = dateFormatter.parse(yesterday, new ParsePosition(0));
                if (d != null) {
                    time = d.getTime() + 86400000L;
                }
            } else if (s.equalsIgnoreCase(NOW)) {
                d = new Date();
                if (d != null) {
                    time = d.getTime();
                }
            } else if (s.equalsIgnoreCase(THE_BIG_CRUNCH)) {
                time = Long.MAX_VALUE;
            }
        } else {
            time = d.getTime() + 86400000L;
        }
        return time;
    }

    class DateFilter
    implements FindFilter {
        protected long startTime = -1L;
        protected long endTime = -1L;

        DateFilter(long from, long to) {
            this.startTime = from;
            this.endTime = to;
        }

        @Override
        public boolean accept(File f, FindProgressCallback callback) {
            if (f == null) {
                return false;
            }
            long t = f.lastModified();
            if (this.startTime >= 0L && t < this.startTime) {
                return false;
            }
            return this.endTime < 0L || t <= this.endTime;
        }
    }
}

