/*
 * Decompiled with CFR 0.152.
 */
package jehep.misc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import jehep.misc.FindByContent;
import jehep.misc.FindByDate;
import jehep.misc.FindByName;
import jehep.misc.FindFilter;
import jehep.misc.FindFilterFactory;
import jehep.misc.FindProgressCallback;

public class FindAccessory
extends JPanel
implements Runnable,
PropertyChangeListener,
ActionListener,
FindProgressCallback {
    public static final String ACCESSORY_NAME = " Find ";
    public static final int DEFAULT_MAX_SEARCH_HITS = 50;
    public static final String ACTION_START = "Start";
    public static final String ACTION_STOP = "Stop";
    protected JFileChooser chooser = null;
    protected FindAction actionStart = null;
    protected FindAction actionStop = null;
    protected Thread searchThread = null;
    protected boolean killFind = false;
    protected FindFolder pathPanel = null;
    protected FindTabs searchTabs = null;
    protected FindControls controlPanel = null;
    protected int total = 0;
    protected int matches = 0;
    protected int maxMatches = 50;

    public FindAccessory() {
        this.setBorder(new TitledBorder(ACCESSORY_NAME));
        this.setLayout(new BorderLayout());
        this.actionStart = new FindAction(ACTION_START, null);
        this.actionStop = new FindAction(ACTION_STOP, null);
        this.pathPanel = new FindFolder();
        this.add((Component)this.pathPanel, "North");
        this.searchTabs = new FindTabs();
        this.add((Component)this.searchTabs, "Center");
        this.controlPanel = new FindControls(this.actionStart, this.actionStop, true);
        this.add((Component)this.controlPanel, "South");
        this.updateFindDirectory();
    }

    public FindAccessory(JFileChooser parent) {
        this();
        this.chooser = parent;
        this.register(this.chooser);
    }

    public FindAccessory(JFileChooser c, int max) {
        this(c);
        this.setMaxFindHits(max);
    }

    public void setMaxFindHits(int max) {
        this.maxMatches = max;
    }

    public int getMaxFindHits() {
        return this.maxMatches;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("directoryChanged")) {
            this.updateFindDirectory();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals("ApproveSelection")) {
            this.quit();
        } else if (command.equals("CancelSelection")) {
            this.quit();
        }
    }

    public void updateFindDirectory() {
        if (this.isRunning()) {
            return;
        }
        if (this.chooser == null) {
            return;
        }
        if (this.pathPanel == null) {
            return;
        }
        File f = this.chooser.getCurrentDirectory();
        this.pathPanel.setFindDirectory(f);
    }

    public void goTo(File f) {
        File parentFolder;
        if (f == null) {
            return;
        }
        if (!f.exists()) {
            return;
        }
        if (this.chooser == null) {
            return;
        }
        this.chooser.setFileSelectionMode(2);
        FileFilter filter = this.chooser.getFileFilter();
        if (filter != null && !filter.accept(f)) {
            FileFilter all = this.chooser.getAcceptAllFileFilter();
            this.chooser.setFileFilter(all);
        }
        if ((parentFolder = f.getParentFile()) != null) {
            this.chooser.setCurrentDirectory(parentFolder);
        }
        this.chooser.setSelectedFile(null);
        this.chooser.setSelectedFile(f);
        this.chooser.invalidate();
        this.chooser.repaint();
    }

    public synchronized void start() {
        if (this.searchTabs != null) {
            this.searchTabs.showFindResults();
        }
        this.updateFindDirectory();
        this.killFind = false;
        if (this.searchThread == null) {
            this.searchThread = new Thread(this);
        }
        if (this.searchThread != null) {
            this.searchThread.start();
        }
    }

    public synchronized void stop() {
        this.killFind = true;
    }

    public boolean isRunning() {
        if (this.searchThread == null) {
            return false;
        }
        return this.searchThread.isAlive();
    }

    @Override
    public void run() {
        if (this.searchThread == null) {
            return;
        }
        if (Thread.currentThread() != this.searchThread) {
            return;
        }
        try {
            this.actionStart.setEnabled(false);
            this.actionStop.setEnabled(true);
            this.runFind(this.chooser.getCurrentDirectory(), this.newFind());
        }
        catch (InterruptedException e) {
            System.out.println("Error starting thread");
            System.out.println("InterruptedException " + e.getMessage());
        }
        catch (Exception ex) {
            System.out.println("Error starting thread");
            System.out.println("Exception " + ex.getMessage());
        }
        finally {
            this.actionStart.setEnabled(true);
            this.actionStop.setEnabled(false);
            this.searchThread = null;
        }
    }

    protected void runFind(File base, FindFilter[] filters) throws InterruptedException {
        if (base == null) {
            return;
        }
        if (!base.exists()) {
            return;
        }
        if (filters == null) {
            return;
        }
        if (this.killFind) {
            return;
        }
        File folder = null;
        folder = base.isDirectory() ? base : base.getParentFile();
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            ++this.total;
            if (this.accept(files[i], filters)) {
                ++this.matches;
                this.searchTabs.addFoundFile(files[i]);
            }
            this.updateProgress();
            if (this.killFind) {
                return;
            }
            Thread.currentThread();
            Thread.sleep(0L);
            if (files[i].isDirectory()) {
                this.runFind(files[i], filters);
            }
            if (this.maxMatches <= 0 || this.matches < this.maxMatches) continue;
            return;
        }
    }

    protected boolean accept(File file2, FindFilter[] filters) {
        if (file2 == null) {
            return false;
        }
        if (filters == null) {
            return false;
        }
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i].accept(file2, this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean reportProgress(FindFilter filter, File file2, long current, long total) {
        return !this.killFind;
    }

    protected FindFilter[] newFind() {
        this.matches = 0;
        this.total = 0;
        this.updateProgress();
        if (this.searchTabs != null) {
            return this.searchTabs.newFind();
        }
        return null;
    }

    protected void updateProgress() {
        this.controlPanel.showProgress(this.matches, this.total);
    }

    protected void register(JFileChooser c) {
        if (c == null) {
            return;
        }
        c.addPropertyChangeListener(this);
        c.addActionListener(this);
    }

    protected void unregister(JFileChooser c) {
        if (c == null) {
            return;
        }
        c.removeActionListener(this);
        c.removePropertyChangeListener(this);
    }

    public void quit() {
        this.stop();
        this.unregister(this.chooser);
    }

    public void action(String command) {
        if (command == null) {
            return;
        }
        if (command.equals(ACTION_START)) {
            this.start();
        } else if (command.equals(ACTION_STOP)) {
            this.stop();
        }
    }

    class FindAction
    extends AbstractAction {
        FindAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindAccessory.this.action(e.getActionCommand());
        }
    }

    class FindFolder
    extends JPanel {
        protected JLabel searchDirectory = null;

        FindFolder() {
            this.setLayout(new BorderLayout());
            this.searchDirectory = new JLabel();
            this.searchDirectory.setForeground(Color.black);
            this.searchDirectory.setFont(new Font("Helvetica", 0, 9));
            this.add(this.searchDirectory);
        }

        public void setFindDirectory(File f) {
            if (this.searchDirectory == null) {
                return;
            }
            if (f != null) {
                this.searchDirectory.setText(f.getAbsolutePath());
            } else {
                this.searchDirectory.setText(null);
            }
        }
    }

    class FindTabs
    extends JTabbedPane {
        protected String TAB_NAME = "Name";
        protected String TAB_DATE = "Date";
        protected String TAB_CONTENT = "Content";
        protected String TAB_RESULTS = "Found";
        protected FindResults resultsPanel = null;
        protected JScrollPane resultsScroller = null;

        FindTabs() {
            this.setForeground(Color.black);
            this.setFont(new Font("Helvetica", 1, 10));
            this.addTab(this.TAB_NAME, new FindByName());
            this.addTab(this.TAB_DATE, new FindByDate());
            this.addTab(this.TAB_CONTENT, new FindByContent());
            this.resultsPanel = new FindResults();
            this.resultsScroller = new JScrollPane(this.resultsPanel);
            this.resultsPanel.setDoubleBuffered(true);
            this.resultsScroller.setDoubleBuffered(true);
            this.addTab(this.TAB_RESULTS, this.resultsScroller);
        }

        public void addFoundFile(File f) {
            if (this.resultsPanel != null) {
                this.resultsPanel.append(f);
            }
        }

        public void showFindResults() {
            if (this.resultsScroller != null) {
                this.setSelectedComponent(this.resultsScroller);
            }
        }

        public FindFilter[] newFind() {
            if (this.resultsPanel != null) {
                this.resultsPanel.clear();
            }
            Dimension dim = this.resultsScroller.getSize();
            this.resultsScroller.setMaximumSize(dim);
            this.resultsScroller.setPreferredSize(dim);
            Vector<FindFilter> filters = new Vector<FindFilter>();
            for (int i = 0; i < this.getTabCount(); ++i) {
                try {
                    FindFilterFactory fac = (FindFilterFactory)((Object)this.getComponentAt(i));
                    FindFilter f = fac.createFindFilter();
                    if (f == null) continue;
                    filters.addElement(f);
                    continue;
                }
                catch (Throwable fac) {
                    // empty catch block
                }
            }
            if (filters.size() == 0) {
                return null;
            }
            FindFilter[] filterArray = new FindFilter[filters.size()];
            for (int i = 0; i < filterArray.length; ++i) {
                filterArray[i] = (FindFilter)filters.elementAt(i);
            }
            return filterArray;
        }
    }

    class FindControls
    extends JPanel {
        protected JLabel searchDirectory = null;
        protected JLabel progress = null;

        FindControls(FindAction find, FindAction stop, boolean recurse) {
            this.setLayout(new BorderLayout());
            JToolBar tools2 = new JToolBar();
            tools2.setFloatable(false);
            FindAccessory.this.actionStart = new FindAction(FindAccessory.ACTION_START, null);
            tools2.add(FindAccessory.this.actionStart);
            FindAccessory.this.actionStop = new FindAction(FindAccessory.ACTION_STOP, null);
            tools2.add(FindAccessory.this.actionStop);
            this.add((Component)tools2, "West");
            this.progress = new JLabel("", 4);
            this.progress.setDoubleBuffered(true);
            this.progress.setForeground(Color.black);
            this.progress.setFont(new Font("Helvetica", 0, 9));
            this.add((Component)this.progress, "East");
        }

        public void showProgress(int matches, int total) {
            if (this.progress == null) {
                return;
            }
            this.progress.setText(String.valueOf(matches) + "/" + String.valueOf(total));
        }
    }

    class FindResults
    extends JPanel {
        protected DefaultListModel model = null;
        protected JList fileList = null;

        FindResults() {
            this.setLayout(new BorderLayout());
            this.model = new DefaultListModel();
            this.fileList = new JList(this.model);
            this.fileList.setSelectionMode(0);
            this.fileList.setCellRenderer(new FindResultsCellRenderer());
            this.add((Component)this.fileList, "Center");
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        try {
                            int index = FindResults.this.fileList.locationToIndex(e.getPoint());
                            File f = (File)FindResults.this.model.elementAt(index);
                            FindAccessory.this.goTo(f);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            };
            this.fileList.addMouseListener(mouseListener);
        }

        public void append(File f) {
            if (f == null) {
                return;
            }
            this.model.addElement(f);
        }

        public void clear() {
            if (this.model != null) {
                this.model.removeAllElements();
                this.invalidate();
                this.repaint();
            }
        }

        class FindResultsCellRenderer
        extends JLabel
        implements ListCellRenderer {
            FindResultsCellRenderer() {
                this.setOpaque(true);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (index == -1) {
                    int selected = list.getSelectedIndex();
                    if (selected == -1) {
                        return this;
                    }
                    index = selected;
                }
                this.setBorder(new EmptyBorder(1, 2, 1, 2));
                this.setFont(new Font("Helvetica", 0, 10));
                File file2 = (File)FindResults.this.model.elementAt(index);
                this.setText(file2.getAbsolutePath());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(Color.white);
                    this.setForeground(Color.black);
                }
                return this;
            }
        }
    }
}

