/*
 * Decompiled with CFR 0.152.
 */
package jehep.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import jehep.ui.mainGUI;
import jehep.utils.Utils;

public class Open {
    private mainGUI win;
    boolean readonly;
    private static final int BUFFER_SIZE = 32768;

    public Open(mainGUI win, String f, boolean r) {
        this.win = win;
        this.run(f, r);
    }

    public void run(String f, boolean r) {
        this.readonly = r;
        this.win.setWaitCursor();
        File toLoad = new File(f);
        if (!toLoad.exists() || !toLoad.canRead()) {
            Utils.userMessage(" Oops!", " File " + f + " no longer exists has been moved, or cannot be read from", 2);
            boolean killOpen = true;
            this.win.killOpen(killOpen);
            this.win.setTextCursor();
            return;
        }
        if (Utils.isReadOnly(f) && this.readonly) {
            Utils.userMessage(" Read Only", " File " + f + " is Read Only", 2);
        }
        try {
            int len;
            StringBuffer buffer = new StringBuffer((int)toLoad.length());
            InputStreamReader in = new InputStreamReader(new FileInputStream(toLoad));
            char[] buf = new char[32768];
            boolean lineCount = false;
            boolean CRLF = false;
            boolean CROnly = false;
            boolean lastWasCR = false;
            while ((len = in.read(buf, 0, buf.length)) != -1) {
                int lastLine = 0;
                block7: for (int i = 0; i < len; ++i) {
                    switch (buf[i]) {
                        case '\r': {
                            if (lastWasCR) {
                                CROnly = true;
                                CRLF = false;
                            } else {
                                lastWasCR = true;
                            }
                            buffer.append(buf, lastLine, i - lastLine);
                            buffer.append('\n');
                            lastLine = i + 1;
                            continue block7;
                        }
                        case '\n': {
                            if (lastWasCR) {
                                CROnly = false;
                                CRLF = true;
                                lastWasCR = false;
                                lastLine = i + 1;
                                continue block7;
                            }
                            CROnly = false;
                            CRLF = false;
                            buffer.append(buf, lastLine, i - lastLine);
                            buffer.append('\n');
                            lastLine = i + 1;
                            continue block7;
                        }
                        default: {
                            if (!lastWasCR) continue block7;
                            CROnly = true;
                            CRLF = false;
                            lastWasCR = false;
                        }
                    }
                }
            }
            in.close();
            in = null;
            if (buffer.length() != 0 && buffer.charAt(buffer.length() - 1) == '\n') {
                buffer.setLength(buffer.length() - 1);
            }
            this.win.loadDoc(buffer.toString());
            this.win.setTextCursor();
            buffer = null;
        }
        catch (Exception e) {
            this.win.setStatus("Error opening file");
        }
    }
}

