/*
 * Decompiled with CFR 0.152.
 */
package jabref.label;

import jabref.BibtexEntry;
import jabref.imports.ImportFormatReader;
import jabref.label.DefaultLabelRule;

public class ArticleLabelRule
extends DefaultLabelRule {
    @Override
    public String applyRule(BibtexEntry oldEntry) {
        String oldLabel = (String)oldEntry.getField("bibtexkey");
        String newLabel = "";
        String author = "";
        try {
            author = (String)oldEntry.getField("author");
            String[] tokens = author.split("\\band\\b");
            if (tokens.length > 0) {
                if (tokens[0].indexOf(",") > 0) {
                    tokens[0] = ImportFormatReader.fixAuthor(tokens[0]);
                }
                String[] firstAuthor = tokens[0].replaceAll("\\s+", " ").split(" ");
                newLabel = newLabel + firstAuthor[firstAuthor.length - 1];
            }
        }
        catch (Throwable t) {
            System.out.println("error getting author: " + t);
        }
        try {
            if (!newLabel.equals("")) {
                if (oldEntry.getField("year") != null) {
                    newLabel = newLabel + String.valueOf(oldEntry.getField("year"));
                }
            } else {
                newLabel = oldLabel;
            }
        }
        catch (Throwable t) {
            System.out.println("error getting year: " + t);
        }
        return newLabel;
    }
}

