/*
 * Decompiled with CFR 0.152.
 */
package jabref.export.layout.format;

import jabref.Globals;
import jabref.export.layout.LayoutFormatter;
import java.util.regex.Pattern;

public class ConvertSpecialCharactersForHTML
implements LayoutFormatter {
    Pattern pattern = Pattern.compile(".*\\{\\\\.*[a-zA-Z]\\}.*");

    @Override
    public String format(String fieldText) {
        if (!this.pattern.matcher(fieldText = this.firstFormat(fieldText)).matches()) {
            return this.restFormat(fieldText);
        }
        for (String s : Globals.HTML_CHARS.keySet()) {
            fieldText = fieldText.replaceAll(s, (String)Globals.HTML_CHARS.get(s));
        }
        return this.restFormat(fieldText);
    }

    private String firstFormat(String s) {
        return s.replaceAll("&|\\\\&", "&amp;");
    }

    private String restFormat(String s) {
        return s.replaceAll("\\}", "").replaceAll("\\{", "");
    }
}

