/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BasePanel;
import jabref.BibtexEntry;
import jabref.DatabaseSearch;
import jabref.GUIGlobals;
import jabref.Globals;
import jabref.IncrementalSearcher;
import jabref.JabRefFrame;
import jabref.JabRefPreferences;
import jabref.RegExpRule;
import jabref.SearchRule;
import jabref.SearchRuleSet;
import jabref.SidePaneComponent;
import jabref.SidePaneHeader;
import jabref.SidePaneManager;
import jabref.SimpleSearchRule;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class SearchManager2
extends SidePaneComponent
implements ActionListener,
KeyListener,
ItemListener {
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    IncrementalSearcher incSearcher;
    private JabRefFrame frame;
    private JTextField searchField = new JTextField("", 12);
    private JLabel lab = new JLabel(new ImageIcon(GUIGlobals.searchIconFile));
    private JPopupMenu settings = new JPopupMenu();
    private JButton openset = new JButton(Globals.lang("Settings"));
    private JButton escape = new JButton(Globals.lang("Clear search"));
    private JabRefPreferences prefs;
    private JCheckBoxMenuItem searchReq;
    private JCheckBoxMenuItem searchOpt;
    private JCheckBoxMenuItem searchGen;
    private JCheckBoxMenuItem searchAll;
    private JCheckBoxMenuItem caseSensitive;
    private JCheckBoxMenuItem regExpSearch;
    private JCheckBox increment;
    private JCheckBox select;
    private JCheckBox reorder;
    private ButtonGroup types = new ButtonGroup();
    private SearchManager2 ths = this;
    private boolean incSearch = false;
    private int incSearchPos = -1;

    public SearchManager2(JabRefFrame frame, JabRefPreferences prefs_, SidePaneManager manager) {
        super(manager);
        this.frame = frame;
        this.prefs = prefs_;
        this.incSearcher = new IncrementalSearcher(this.prefs);
        this.searchReq = new JCheckBoxMenuItem(Globals.lang("Search required fields"), this.prefs.getBoolean("searchReq"));
        this.searchOpt = new JCheckBoxMenuItem(Globals.lang("Search optional fields"), this.prefs.getBoolean("searchOpt"));
        this.searchGen = new JCheckBoxMenuItem(Globals.lang("Search general fields"), this.prefs.getBoolean("searchGen"));
        this.searchAll = new JCheckBoxMenuItem(Globals.lang("Search all fields"), this.prefs.getBoolean("searchAll"));
        this.regExpSearch = new JCheckBoxMenuItem(Globals.lang("Use regular expressions"), this.prefs.getBoolean("regExpSearch"));
        this.increment = new JCheckBox(Globals.lang("Incremental"), false);
        this.select = new JCheckBox(Globals.lang("Highlight"), true);
        this.reorder = new JCheckBox(Globals.lang("Float"), false);
        this.increment.addItemListener(this);
        this.reorder.addItemListener(this);
        this.searchField.addFocusListener(Globals.focusListener);
        if (this.searchAll.isSelected()) {
            this.searchReq.setEnabled(false);
            this.searchOpt.setEnabled(false);
            this.searchGen.setEnabled(false);
        }
        this.caseSensitive = new JCheckBoxMenuItem(Globals.lang("Case sensitive"), this.prefs.getBoolean("caseSensitiveSearch"));
        this.settings.add(this.caseSensitive);
        this.settings.addSeparator();
        this.settings.add(this.searchReq);
        this.settings.add(this.searchOpt);
        this.settings.add(this.searchGen);
        this.settings.addSeparator();
        this.settings.add(this.searchAll);
        this.settings.addSeparator();
        this.settings.add(this.regExpSearch);
        this.searchField.addActionListener(this);
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SearchManager2.this.incSearch = false;
                SearchManager2.this.incSearchPos = -1;
                if (SearchManager2.this.increment.isSelected()) {
                    SearchManager2.this.searchField.setText("");
                }
            }
        });
        this.escape.addActionListener(this);
        this.openset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton src = (JButton)e.getSource();
                SearchManager2.this.settings.show(src, 0, 0);
            }
        });
        this.types.add(this.increment);
        this.types.add(this.select);
        this.types.add(this.reorder);
        if (this.prefs.getBoolean("incrementS")) {
            this.increment.setSelected(true);
        } else if (!this.prefs.getBoolean("selectS")) {
            this.reorder.setSelected(true);
        }
        this.setLayout(this.gbl);
        SidePaneHeader header = new SidePaneHeader("Search", GUIGlobals.searchIconFile, this);
        this.con.gridwidth = 0;
        this.con.fill = 2;
        this.con.weightx = 1.0;
        this.con.insets = new Insets(0, 0, 2, 0);
        this.gbl.setConstraints(header, this.con);
        this.add(header);
        this.con.insets = new Insets(0, 0, 0, 0);
        this.gbl.setConstraints(this.searchField, this.con);
        this.add(this.searchField);
        this.gbl.setConstraints(this.increment, this.con);
        this.add(this.increment);
        this.gbl.setConstraints(this.select, this.con);
        this.add(this.select);
        this.gbl.setConstraints(this.reorder, this.con);
        this.add(this.reorder);
        this.gbl.setConstraints(this.openset, this.con);
        this.add(this.openset);
        this.gbl.setConstraints(this.escape, this.con);
        this.add(this.escape);
        this.searchField.getInputMap().put(this.prefs.getKey("Repeat incremental search"), "repeat");
        this.searchField.getActionMap().put("repeat", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchManager2.this.increment.isSelected()) {
                    SearchManager2.this.repeatIncremental();
                }
            }
        });
        this.searchField.getInputMap().put(this.prefs.getKey("Clear search"), "escape");
        this.searchField.getActionMap().put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchManager2.this.ths.actionPerformed(new ActionEvent(SearchManager2.this.escape, 0, ""));
            }
        });
    }

    protected void updatePrefs() {
        this.prefs.putBoolean("searchReq", this.searchReq.isSelected());
        this.prefs.putBoolean("searchOpt", this.searchOpt.isSelected());
        this.prefs.putBoolean("searchGen", this.searchGen.isSelected());
        this.prefs.putBoolean("searchAll", this.searchAll.isSelected());
        this.prefs.putBoolean("incrementS", this.increment.isSelected());
        this.prefs.putBoolean("selectS", this.select.isSelected());
        this.prefs.putBoolean("caseSensitiveSearch", this.caseSensitive.isSelected());
        this.prefs.putBoolean("regExpSearch", this.regExpSearch.isSelected());
    }

    public void startIncrementalSearch() {
        this.increment.setSelected(true);
        this.searchField.setText("");
        this.searchField.requestFocus();
    }

    public void startSearch() {
        if (this.increment.isSelected() && this.incSearch) {
            this.repeatIncremental();
            return;
        }
        if (!this.searchField.hasFocus()) {
            this.searchField.setText("");
            this.searchField.requestFocus();
        } else {
            if (this.increment.isSelected()) {
                this.select.setSelected(true);
            } else if (this.select.isSelected()) {
                this.reorder.setSelected(true);
            } else {
                this.increment.setSelected(true);
            }
            this.increment.revalidate();
            this.increment.repaint();
            this.searchField.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.escape) {
            this.incSearch = false;
            if (this.frame.basePanel() != null) {
                this.frame.basePanel().stopShowingSearchResults();
            }
        } else if (e.getSource() == this.searchField && !this.increment.isSelected() && this.frame.basePanel() != null) {
            this.updatePrefs();
            Hashtable<String, String> searchOptions = new Hashtable<String, String>();
            searchOptions.put("option", this.searchField.getText());
            SearchRuleSet searchRules = new SearchRuleSet();
            SearchRule rule1 = this.prefs.getBoolean("regExpSearch") ? new RegExpRule(this.prefs) : new SimpleSearchRule(this.prefs);
            searchRules.addRule(rule1);
            if (this.reorder.isSelected()) {
                DatabaseSearch search2 = new DatabaseSearch(searchOptions, searchRules, this.frame.basePanel(), "__search", true);
                search2.start();
            } else if (this.select.isSelected()) {
                DatabaseSearch search3 = new DatabaseSearch(searchOptions, searchRules, this.frame.basePanel(), "__search", false);
                search3.start();
            }
            this.searchField.select(0, this.searchField.getText().length());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.increment) {
            if (this.increment.isSelected()) {
                this.searchField.addKeyListener(this.ths);
            } else {
                this.searchField.removeKeyListener(this.ths);
            }
        } else if (e.getSource() == this.reorder && !this.reorder.isSelected()) {
            this.frame.stopShowingSearchResults();
        }
    }

    private void repeatIncremental() {
        ++this.incSearchPos;
        if (this.frame.basePanel() != null) {
            this.goIncremental();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.isControlDown()) {
            return;
        }
        if (this.frame.basePanel() != null) {
            this.goIncremental();
        }
    }

    private void goIncremental() {
        this.incSearch = true;
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                String text = SearchManager2.this.searchField.getText();
                BasePanel bp = SearchManager2.this.frame.basePanel();
                if (SearchManager2.this.incSearchPos >= bp.getDatabase().getEntryCount()) {
                    SearchManager2.this.frame.output("'" + text + "' : " + Globals.lang("Incremental search failed. Repeat to search from top.") + ".");
                    SearchManager2.this.incSearchPos = -1;
                    return;
                }
                if (SearchManager2.this.searchField.getText().equals("")) {
                    return;
                }
                if (SearchManager2.this.incSearchPos < 0) {
                    SearchManager2.this.incSearchPos = 0;
                }
                BibtexEntry be = bp.getDatabase().getEntryById(bp.tableModel.getNameFromNumber(SearchManager2.this.incSearchPos));
                while (!SearchManager2.this.incSearcher.search(text, be)) {
                    SearchManager2.this.incSearchPos++;
                    if (SearchManager2.this.incSearchPos < bp.getDatabase().getEntryCount()) {
                        be = bp.getDatabase().getEntryById(bp.tableModel.getNameFromNumber(SearchManager2.this.incSearchPos));
                        continue;
                    }
                    SearchManager2.this.frame.output("'" + text + "' : " + Globals.lang("Incremental search failed. Repeat to search from top."));
                    SearchManager2.this.incSearchPos = -1;
                    return;
                }
                if (SearchManager2.this.incSearchPos >= 0) {
                    bp.selectSingleEntry(SearchManager2.this.incSearchPos);
                    SearchManager2.this.frame.output("'" + text + "' " + Globals.lang("found") + ".");
                }
            }
        });
    }

    @Override
    public void componentClosing() {
        BasePanel bp = this.frame.basePanel();
        if (bp != null) {
            bp.stopShowingSearchResults();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

