/*
 * Decompiled with CFR 0.152.
 */
package jabref;

import jabref.BasePanel;
import jabref.BibtexDatabase;
import jabref.BibtexEntry;
import jabref.BibtexEntryType;
import jabref.EntryComparator;
import jabref.EntrySorter;
import jabref.GUIGlobals;
import jabref.JabRefFrame;
import jabref.Util;
import jabref.export.LatexFieldFormatter;
import jabref.imports.ImportFormatReader;
import jabref.undo.UndoableFieldChange;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;

public class EntryTableModel
extends AbstractTableModel {
    BibtexDatabase db;
    BasePanel panel;
    JabRefFrame frame;
    String[] columns;
    private EntrySorter sorter;
    public static final int REQUIRED = 1;
    public static final int OPTIONAL = 2;
    public static final int REQ_STRING = 1;
    public static final int REQ_NUMBER = 2;
    public static final int OPT_STRING = 3;
    public static final int OTHER = 3;
    public static final int ICON_COL = 8;
    public static final String[] PDF = new String[]{"pdf", "ps"};
    public static final String[] URL_ = new String[]{"url", "doi"};
    public int padleft = -1;
    private HashMap iconCols = new HashMap();
    int[] nameCols = null;
    boolean namesAsIs;
    boolean namesFf;

    public EntryTableModel(JabRefFrame frame_, BasePanel panel_, BibtexDatabase db_) {
        this.panel = panel_;
        this.frame = frame_;
        this.db = db_;
        this.columns = this.panel.prefs.getStringArray("columnNames");
        this.remap();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return GUIGlobals.NUMBER_COL;
        }
        if (this.getIconTypeForColumn(col) != null) {
            return "";
        }
        return Util.nCase(this.columns[col - this.padleft]);
    }

    @Override
    public int getRowCount() {
        return this.sorter.getEntryCount();
    }

    @Override
    public int getColumnCount() {
        return this.padleft + this.columns.length;
    }

    public Class getColumnClass(int column) {
        return this.getIconTypeForColumn(column) != null ? JLabel.class : String.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object o;
        BibtexEntry be = this.db.getEntryById(this.getNameFromNumber(row));
        String[] iconType = this.getIconTypeForColumn(col);
        if (col == 0) {
            o = "" + (row + 1);
        } else {
            if (iconType != null) {
                int hasField = -1;
                for (int i = iconType.length - 1; i >= 0; --i) {
                    if (!this.hasField(row, iconType[i])) continue;
                    hasField = i;
                }
                if (hasField < 0) {
                    return null;
                }
                return GUIGlobals.getTableIcon(iconType[hasField]);
            }
            if (this.columns[col - this.padleft].equals(GUIGlobals.TYPE_HEADER)) {
                o = be.getType().getName();
            } else {
                o = be.getField(this.columns[col - this.padleft]);
                for (int i = 0; i < this.nameCols.length; ++i) {
                    if (col - this.padleft != this.nameCols[i]) continue;
                    if (o == null) {
                        return null;
                    }
                    if (this.namesAsIs) {
                        return o;
                    }
                    if (this.namesFf) {
                        return ImportFormatReader.fixAuthor((String)o);
                    }
                    return ImportFormatReader.fixAuthor_lastnameFirst((String)o);
                }
            }
        }
        return o;
    }

    public String[] getIconTypeForColumn(int col) {
        Object o = this.iconCols.get(new Integer(col));
        if (o != null) {
            return (String[])o;
        }
        return null;
    }

    public int getCellStatus(int row, int col) {
        if (col == 0) {
            return 3;
        }
        if (this.getIconTypeForColumn(col) != null) {
            return 8;
        }
        BibtexEntryType type = this.db.getEntryById(this.getNameFromNumber(row)).getType();
        if (this.columns[col - this.padleft].equals(GUIGlobals.KEY_FIELD) || type.isRequired(this.columns[col - this.padleft])) {
            return 1;
        }
        if (type.isOptional(this.columns[col - this.padleft])) {
            return 2;
        }
        return 3;
    }

    public boolean isComplete(int row) {
        BibtexEntry be = this.db.getEntryById(this.getNameFromNumber(row));
        return be.hasAllRequiredFields();
    }

    public boolean hasCrossRef(int row) {
        BibtexEntry be = this.db.getEntryById(this.getNameFromNumber(row));
        return be.getField("crossref") != null;
    }

    public boolean nonZeroField(int row, String field) {
        BibtexEntry be = this.db.getEntryById(this.getNameFromNumber(row));
        String o = (String)be.getField(field);
        return o != null && !o.equals("0");
    }

    public boolean hasField(int row, String field) {
        BibtexEntry be = this.db.getEntryById(this.getNameFromNumber(row));
        return be.getField(field) != null;
    }

    public void remap() {
        int i;
        this.iconCols.clear();
        int coln = 1;
        if (this.panel.prefs.getBoolean("pdfColumn")) {
            this.iconCols.put(new Integer(coln++), PDF);
        }
        if (this.panel.prefs.getBoolean("urlColumn")) {
            this.iconCols.put(new Integer(coln++), URL_);
        }
        this.padleft = 1 + this.iconCols.size();
        Vector<Integer> tmp = new Vector<Integer>(2, 1);
        for (i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].equals("author") && !this.columns[i].equals("editor")) continue;
            tmp.add(new Integer(i));
        }
        this.nameCols = new int[tmp.size()];
        for (i = 0; i < this.nameCols.length; ++i) {
            this.nameCols[i] = (Integer)tmp.elementAt(i);
        }
        this.namesAsIs = this.panel.prefs.getBoolean("namesAsIs");
        this.namesFf = this.panel.prefs.getBoolean("namesFf");
        Vector<String> fields = new Vector<String>(5, 1);
        Vector<Boolean> directions = new Vector<Boolean>(5, 1);
        fields.add("__markedentry");
        directions.add(new Boolean(true));
        if (this.panel.showingGroup) {
            fields.add("__groupsearch");
            directions.add(new Boolean(true));
        }
        if (this.panel.showingSearchResults) {
            fields.add("__search");
            directions.add(new Boolean(true));
        }
        directions.add(new Boolean(this.frame.prefs.getBoolean("priDescending")));
        directions.add(new Boolean(this.frame.prefs.getBoolean("secDescending")));
        directions.add(new Boolean(this.frame.prefs.getBoolean("terDescending")));
        fields.add(this.frame.prefs.get("priSort"));
        fields.add(this.frame.prefs.get("secSort"));
        fields.add(this.frame.prefs.get("terSort"));
        this.sorter = directions.size() < 4 ? this.db.getSorter(new EntryComparator((Boolean)directions.elementAt(0), (Boolean)directions.elementAt(1), (Boolean)directions.elementAt(2), (String)fields.elementAt(0), (String)fields.elementAt(1), (String)fields.elementAt(2))) : this.db.getSorter(new EntryComparator((Boolean)directions.elementAt(0), (Boolean)directions.elementAt(1), (Boolean)directions.elementAt(2), (Boolean)directions.elementAt(3), (String)fields.elementAt(0), (String)fields.elementAt(1), (String)fields.elementAt(2), (String)fields.elementAt(3)));
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col < this.padleft) {
            return false;
        }
        try {
            return !this.getColumnName(col).toLowerCase().equals(GUIGlobals.TYPE_HEADER);
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        BibtexEntry be = this.db.getEntryById(this.getNameFromNumber(row));
        boolean set = false;
        String toSet = null;
        String fieldName = this.getColumnName(col);
        if (value != null) {
            String text = value.toString();
            if (text.length() > 0) {
                toSet = text;
                Object o = be.getField(fieldName.toLowerCase());
                if (o == null || o != null && !o.toString().equals(toSet)) {
                    set = true;
                }
            } else if (be.getField(fieldName.toLowerCase()) != null) {
                set = true;
            }
        }
        if (set) {
            try {
                if (toSet != null) {
                    new LatexFieldFormatter().format(toSet, GUIGlobals.isStandardField(fieldName));
                }
                Object oldVal = be.getField(fieldName.toLowerCase());
                this.panel.undoManager.addEdit(new UndoableFieldChange(be, fieldName.toLowerCase(), oldVal, toSet));
                be.setField(fieldName.toLowerCase(), toSet);
                this.panel.markBaseChanged();
            }
            catch (IllegalArgumentException ex) {
                this.frame.output("Invalid field format: " + ex.getMessage());
            }
        }
    }

    public String getNameFromNumber(int number) {
        return this.sorter.getIdAt(number);
    }

    public int getNumberFromName(String name) {
        int res = -1;
        for (int i = 0; i < this.sorter.getEntryCount() && res < 0; ++i) {
            if (!name.equals(this.sorter.getIdAt(i))) continue;
            res = i;
        }
        return res;
    }
}

