/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.xmlgui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GUILoader
implements ActionListener {
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private XmlLoader xmlLoader = new XmlLoader(this);

    public Object getBuildedObject(String keyNameOfObject) {
        return this.xmlLoader.getResult().get(keyNameOfObject);
    }

    public void load(String filePath) throws IOException, SAXException, ParserConfigurationException {
        File file2 = new File(filePath);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(file2, (DefaultHandler)this.xmlLoader);
    }

    public void load(File file2) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(file2, (DefaultHandler)this.xmlLoader);
    }

    public void load(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(in, (DefaultHandler)this.xmlLoader);
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Iterator<ActionListener> i = this.actionListeners.iterator();
        while (i.hasNext()) {
            i.next().actionPerformed(e);
        }
    }

    private class XmlLoader
    extends DefaultHandler {
        public static final String TXT_CONTENT = "txtContent";
        public static final String ACTION_COMMAND = "actionCommand";
        public static final String RESULT_KEY = "resultKeyName";
        public static final String ICON_PATH = "iconPath";
        public static final String TOOL_TIP = "toolTip";
        public static final String CLASS_NAME = "className";
        public static final String SEPARATOR = "Separation";
        public ArrayList<JComponent> depth = new ArrayList();
        public Hashtable<String, Object> result = new Hashtable();
        public ActionListener al;
        String txt;
        String actionCommand;
        String resultKey;
        String iconPath;
        String className;
        String toolTip;

        public XmlLoader(ActionListener al) {
            this.al = al;
        }

        public Hashtable<String, Object> getResult() {
            return this.result;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Object obj = null;
            this.txt = attributes.getValue(TXT_CONTENT);
            this.actionCommand = attributes.getValue(ACTION_COMMAND);
            this.resultKey = attributes.getValue(RESULT_KEY);
            this.className = attributes.getValue(CLASS_NAME);
            this.iconPath = attributes.getValue(ICON_PATH);
            this.toolTip = attributes.getValue(TOOL_TIP);
            if (this.className == null) {
                return;
            }
            try {
                obj = Class.forName(this.className).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (obj instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)obj;
                if (button instanceof JButton) {
                    button.setMargin(new Insets(0, 0, 0, 0));
                }
                if (this.txt != null) {
                    button.setText(this.txt);
                }
                if (this.actionCommand != null) {
                    button.setActionCommand(this.actionCommand);
                    button.addActionListener(this.al);
                }
                if (this.toolTip != null) {
                    button.setToolTipText(this.toolTip);
                }
                if (this.iconPath != null) {
                    URL imgURL = GUILoader.class.getResource(this.iconPath);
                    if (imgURL != null) {
                        button.setIcon(new ImageIcon(imgURL));
                    } else {
                        System.err.println("Couldn't find file: " + this.iconPath);
                    }
                }
            }
            if (obj instanceof JComponent) {
                JComponent parentComponent = (JComponent)obj;
                this.depth.add(parentComponent);
                if (this.depth.size() > 1) {
                    this.depth.get(this.depth.size() - 2).add(this.depth.get(this.depth.size() - 1));
                }
            }
            if (this.resultKey != null) {
                this.result.put(this.resultKey, obj);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals(SEPARATOR)) {
                JComponent obj = this.depth.get(this.depth.size() - 1);
                if (obj instanceof JMenu) {
                    ((JMenu)obj).addSeparator();
                }
            } else if (this.depth.size() > 0) {
                this.depth.remove(this.depth.size() - 1);
            }
        }
    }
}

