/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.basic;

import com.artenum.tk.ui.api.FloatListener;
import com.artenum.tk.ui.api.FloatValue;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FloatSliderInput
implements FloatValue,
ChangeListener,
FloatListener {
    private static final long serialVersionUID = 1L;
    private float value;
    private float min;
    private float max;
    private int nbStep;
    private JSlider valueUI;
    private ArrayList<FloatListener> listeners = new ArrayList();

    public FloatSliderInput() {
        this(0.0f);
    }

    public FloatSliderInput(float value) {
        this(0.0f, -1.0f, 1.0f);
    }

    public FloatSliderInput(float value, float min, float max) {
        this(value, min, max, 1000);
    }

    public FloatSliderInput(float value, float min, float max, int nbStep) {
        this.value = value;
        this.nbStep = nbStep;
        this.min = min;
        this.max = max;
        this.valueUI = new JSlider(0, nbStep, this.convertToSliderValue(value));
        this.valueUI.addChangeListener(this);
    }

    @Override
    public float getValue() {
        return this.value;
    }

    private int convertToSliderValue(float value) {
        return (int)((value - this.min) / (this.max - this.min) * (float)this.nbStep);
    }

    @Override
    public void setValue(float newValue, boolean notify) {
        this.value = newValue;
        this.value = Math.min(this.value, this.max);
        this.value = Math.max(this.value, this.min);
        this.valueUI.setValue(this.convertToSliderValue(this.value));
        if (notify) {
            this.notifyListener();
        }
    }

    @Override
    public JComponent getUI() {
        return this.valueUI;
    }

    @Override
    public void setRange(float min, float max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public float[] getRange() {
        return new float[]{this.min, this.max};
    }

    @Override
    public void addFloatListener(FloatListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeFloatListener(FloatListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void notifyListener() {
        for (FloatListener l : this.listeners) {
            l.valueChanged(this.value);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setValue((float)this.valueUI.getValue() / (float)this.nbStep * (this.max - this.min) + this.min, true);
    }

    @Override
    public void valueChanged(float newValue) {
        this.setValue(newValue, false);
    }
}

