/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.rtti;

import java.util.Vector;
import org.freehep.rtti.RTTI;

public class IDestructor {
    private String name;
    private Vector comments;
    private String[] exceptionTypes;

    IDestructor(String name, Vector comments, String[] exceptionTypes) {
        this.name = name;
        this.comments = comments;
        this.exceptionTypes = exceptionTypes;
    }

    public String getName() {
        return this.name;
    }

    public String[] getComments(String language) {
        return RTTI.getComments(this.comments, language);
    }

    public String[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("");
        String[] comments = this.getComments(null);
        for (int i = 0; i < comments.length; ++i) {
            s.append(comments[i]);
            s.append("\n");
        }
        s.append("    public ");
        s.append(this.getName());
        s.append(" ()");
        String[] exceptionTypes = this.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            s.append(" throws ");
            for (int i = 0; i < exceptionTypes.length; ++i) {
                s.append(exceptionTypes[i]);
                if (i >= exceptionTypes.length - 1) continue;
                s.append(", ");
            }
        }
        s.append(";");
        return s.toString();
    }
}

