/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.rtti;

import java.util.Vector;
import org.freehep.rtti.IConstructor;
import org.freehep.rtti.IDestructor;
import org.freehep.rtti.IField;
import org.freehep.rtti.IMethod;
import org.freehep.rtti.RTTI;

public class IClass {
    private String name;
    private boolean isClass;
    private String packageName;
    private Vector packageComments;
    private Vector comments;
    private Vector eocComments;
    private Vector eopComments;
    private Vector eofComments;
    private String[] templateParameters;
    private String[] interfaces;
    private IConstructor[] constructors;
    private IDestructor destructor;
    private IMethod[] methods;
    private IField[] fields;
    private IField[] enumFields = new IField[0];

    IClass(String name, boolean isClass, String packageName, Vector packageComments, Vector comments, Vector eocComments, String[] templateParameters, String[] interfaces, IConstructor[] constructors, IDestructor destructor, IMethod[] methods, IField[] fields) {
        this.name = name;
        this.isClass = isClass;
        this.packageName = packageName;
        this.packageComments = packageComments;
        this.comments = comments;
        this.eocComments = eocComments;
        this.templateParameters = templateParameters;
        this.interfaces = interfaces;
        this.constructors = constructors;
        this.destructor = destructor;
        this.methods = methods;
        this.fields = fields;
    }

    public String getName() {
        return this.name;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageName(String packagePrefix) {
        if (packagePrefix != null && !packagePrefix.equals("")) {
            if (this.packageName != null && !this.packageName.equals("")) {
                return packagePrefix + "." + this.packageName;
            }
            return packagePrefix;
        }
        return this.packageName;
    }

    public String[] getPackageComments(String language) {
        return RTTI.getComments(this.packageComments, language);
    }

    public String[] getComments(String language) {
        return RTTI.getComments(this.comments, language);
    }

    public String[] getEOCComments(String language) {
        return RTTI.getComments(this.eocComments, language);
    }

    public String[] getEOPComments(String language) {
        return RTTI.getComments(this.eopComments, language);
    }

    public void setEOPComments(Vector eopComments) {
        this.eopComments = eopComments;
    }

    public String[] getEOFComments(String language) {
        return RTTI.getComments(this.eofComments, language);
    }

    public void setEOFComments(Vector eofComments) {
        this.eofComments = eofComments;
    }

    public IField[] getEnumFields() {
        return this.enumFields;
    }

    public void setEnumFields(Vector enumFields) {
        this.enumFields = new IField[enumFields.size()];
        enumFields.toArray(this.enumFields);
    }

    public String[] getTemplateParameters() {
        return this.templateParameters;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public IConstructor[] getConstructors() {
        return this.constructors;
    }

    public IDestructor getDestructor() {
        return this.destructor;
    }

    public IMethod[] getMethods() {
        return this.methods;
    }

    public IField[] getFields() {
        return this.fields;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String packagePrefix) {
        StringBuffer s = new StringBuffer();
        String[] packageComments = this.getPackageComments(null);
        for (int i = 0; i < packageComments.length; ++i) {
            s.append(packageComments[i]);
        }
        s.append("package ");
        s.append(this.getPackageName(packagePrefix));
        s.append(";");
        String[] comments = this.getComments(null);
        for (int i = 0; i < comments.length; ++i) {
            s.append(comments[i]);
        }
        s.append("\n");
        s.append("public ");
        s.append(this.isClass() ? "class" : "interface");
        s.append(" ");
        s.append(this.getName());
        String[] interfaces = this.getInterfaces();
        if (interfaces.length > 0) {
            s.append(" extends ");
            for (int i = 0; i < interfaces.length; ++i) {
                s.append(interfaces[i]);
                if (i >= interfaces.length - 1) continue;
                s.append(", ");
            }
        }
        s.append(" {");
        s.append("\n");
        IConstructor[] constructors = this.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            s.append(constructors[i]);
        }
        IDestructor destructor = this.getDestructor();
        if (destructor != null) {
            s.append(destructor);
        }
        IMethod[] methods = this.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            s.append(methods[i]);
        }
        IField[] fields = this.getFields();
        for (int i = 0; i < fields.length; ++i) {
            s.append(fields[i]);
        }
        String[] eocComments = this.getEOCComments(null);
        for (int i = 0; i < eocComments.length; ++i) {
            s.append(eocComments[i]);
        }
        s.append("\n");
        s.append("\n}\n");
        String[] eofComments = this.getEOFComments(null);
        for (int i = 0; i < eofComments.length; ++i) {
            s.append(eofComments[i]);
        }
        s.append("\n");
        return s.toString();
    }
}

