/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.record.loop.event;

import java.util.TooManyListenersException;
import org.freehep.record.loop.event.ChainableRecordListener;
import org.freehep.record.loop.event.ConfigurationEvent;
import org.freehep.record.loop.event.RecordAdapter;
import org.freehep.record.loop.event.RecordEvent;
import org.freehep.record.loop.event.RecordListener;
import org.freehep.record.loop.event.RecordSuppliedEvent;

class ChainableRecordAdapter
implements ChainableRecordListener {
    private static final RecordListener NULL_LISTENER = new RecordAdapter();
    private RecordListener listener = NULL_LISTENER;
    private boolean newListener;
    private final RecordEvent recordEvent = new RecordEvent(this);

    protected ChainableRecordAdapter() {
    }

    @Override
    public void addRecordListener(RecordListener listener) throws TooManyListenersException {
        if (NULL_LISTENER != this.listener) {
            throw new TooManyListenersException("An RecordListener is already registered with this ChainableRecordListener");
        }
        if (null == listener) {
            listener = NULL_LISTENER;
        } else {
            this.listener = listener;
        }
        this.newListener = true;
    }

    @Override
    public void configure(ConfigurationEvent event) {
        this.listener.configure(event);
        this.newListener = false;
    }

    @Override
    public void finish(RecordEvent event) {
        this.listener.finish(event);
    }

    @Override
    public RecordListener getRecordListener() {
        if (NULL_LISTENER == this.listener) {
            return null;
        }
        return this.listener;
    }

    @Override
    public void recordSupplied(RecordSuppliedEvent event) {
        this.listener.recordSupplied(event);
    }

    @Override
    public void reconfigure(ConfigurationEvent event) {
        if (this.newListener) {
            this.listener.configure(event);
            this.newListener = false;
        } else {
            this.listener.reconfigure(event);
        }
    }

    @Override
    public void removeRecordListener(RecordListener listener) {
        if (this.listener == listener) {
            if (!this.newListener) {
                listener.finish(this.recordEvent);
            }
            this.listener = NULL_LISTENER;
        }
    }

    @Override
    public void resume(RecordEvent event) {
        if (this.newListener) {
            throw new IllegalStateException("Chained Listener was changed but SequentialRecordLoop configuration was not reset");
        }
        this.listener.resume(event);
    }

    @Override
    public void suspend(RecordEvent event) {
        this.listener.suspend(event);
    }
}

