/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.File;
import org.freehep.postscript.FileOperator;
import org.freehep.postscript.IOError;
import org.freehep.postscript.InvalidFileAccess;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSString;
import org.freehep.postscript.UndefinedFileName;

class RenameFile
extends FileOperator {
    RenameFile() {
        this.operandTypes = new Class[]{PSString.class, PSString.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        if (!os.isSecure()) {
            RenameFile.error(os, new InvalidFileAccess());
            return true;
        }
        PSString name2 = os.popString();
        PSString name1 = os.popString();
        if (name1.get(0) == '%' || name2.get(0) == '%') {
            RenameFile.error(os, new UndefinedFileName());
        } else {
            File file1 = new File(name1.getValue());
            File file2 = new File(name2.getValue());
            if (!file1.exists()) {
                RenameFile.error(os, new UndefinedFileName());
            } else if (!file1.renameTo(file2)) {
                RenameFile.error(os, new IOError());
            }
        }
        return true;
    }
}

