/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.freehep.postscript.BreakException;
import org.freehep.postscript.DSC;
import org.freehep.postscript.DebuggerListener;
import org.freehep.postscript.DictionaryStack;
import org.freehep.postscript.ExecutableStack;
import org.freehep.postscript.GStateStack;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSDataSource;
import org.freehep.postscript.PSDebugger;
import org.freehep.postscript.PSDevice;
import org.freehep.postscript.PSFile;
import org.freehep.postscript.PSGState;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPanel;
import org.freehep.postscript.PanelDevice;
import org.freehep.postscript.PostScriptError;
import org.freehep.postscript.ShowPage;
import org.freehep.postscript.VirtualDevice;

public class Processor
implements DebuggerListener {
    private PSDevice device;
    private boolean secure;
    private PSObject data;
    private DSC dsc = null;
    private long pageNo = 1L;
    private double sx = 1.0;
    private double sy = 1.0;
    private double tx = 0.0;
    private double ty = 0.0;
    private boolean debug = false;
    private PSDebugger debugger;
    private DictionaryStack dictStack;
    private ExecutableStack execStack;
    private OperandStack operandStack;
    private GStateStack gstateStack;
    private ActionListener listener;
    private long currentPageNo;

    public Processor(PSPanel panel) {
        this(new PanelDevice(panel), false);
    }

    public Processor(PSDevice device, boolean secure) {
        this.device = device;
        device.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                try {
                    if (Processor.this.debugger == null) {
                        Processor.this.process();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.secure = secure;
        this.currentPageNo = 0L;
    }

    public Processor(Graphics2D graphics, Dimension dimension, boolean secure) {
        this.device = new VirtualDevice(graphics, dimension);
        this.secure = secure;
        this.currentPageNo = 0L;
    }

    public Processor(Graphics2D graphics, Dimension dimension) {
        this(graphics, dimension, false);
    }

    @Override
    public void reset() throws IOException {
        PSGState gstate = new PSGState(this.device);
        this.dictStack = new DictionaryStack();
        this.execStack = new ExecutableStack();
        this.operandStack = new OperandStack(this, gstate, this.secure);
        this.gstateStack = new GStateStack();
        if (this.data instanceof PSFile && ((PSFile)this.data).markSupported()) {
            ((PSFile)this.data).reset();
        }
        this.execStack.push(this.data);
        this.currentPageNo = 0L;
        if (this.debugger != null) {
            this.debugger.update(this.dictStack, this.execStack, this.operandStack);
        }
    }

    public void setData(PSObject data) {
        this.setData(data, Integer.MAX_VALUE);
    }

    public void setData(PSObject data, int bufferLimit) {
        this.data = data;
        if (data instanceof PSFile && ((PSFile)data).markSupported()) {
            ((PSFile)data).mark(bufferLimit);
        }
        if (data instanceof PSDataSource) {
            if (this.dsc != null) {
                this.dsc.removeDSCEventListener(this.device);
            }
            this.dsc = ((PSDataSource)((Object)data)).getDSC();
            if (this.dsc != null) {
                this.dsc.addDSCEventListener(this.device);
            }
        }
    }

    public void setPageNo(long pageNo) {
        this.pageNo = pageNo;
    }

    public void setScale(double sx, double sy) {
        this.sx = sx;
        this.sy = sy;
        this.device.setTransform(new AffineTransform(sx, 0.0, 0.0, sy, this.tx, this.ty));
    }

    public void setTranslation(double tx, double ty) {
        this.tx = tx;
        this.ty = ty;
        this.device.setTransform(new AffineTransform(this.sx, 0.0, 0.0, this.sy, tx, ty));
    }

    public DictionaryStack dictStack() {
        return this.dictStack;
    }

    public ExecutableStack execStack() {
        return this.execStack;
    }

    public OperandStack operandStack() {
        return this.operandStack;
    }

    public GStateStack gstateStack() {
        return this.gstateStack;
    }

    public DSC getDSC() {
        return this.dsc;
    }

    @Override
    public boolean step() {
        return this.step(true);
    }

    public boolean step(boolean update) {
        if (this.execStack.isEmpty()) {
            return false;
        }
        PSObject obj = this.execStack.peekObject();
        try {
            boolean pop = obj.checkAndExecute(this.operandStack);
            if (pop && this.execStack.pop() instanceof ShowPage) {
                ++this.currentPageNo;
                if (this.currentPageNo == this.pageNo) {
                    return false;
                }
            }
        }
        catch (PostScriptError postScriptError) {
            // empty catch block
        }
        if (update && this.debugger != null) {
            this.debugger.update(this.dictStack, this.execStack, this.operandStack);
        }
        return true;
    }

    @Override
    public void go() {
        try {
            boolean go;
            do {
                try {
                    go = this.step(false);
                }
                catch (BreakException e) {
                    if (this.debugger != null) {
                        System.out.println("BreakPoint Found...");
                        go = false;
                        continue;
                    }
                    System.out.println("BreakPoint found but ignored, run with -debug to break.");
                    go = true;
                }
            } while (go);
        }
        catch (ClassCastException cce) {
            System.out.println("PS processing stopped due to ClassCastException");
            cce.printStackTrace();
        }
        if (this.debugger != null) {
            this.debugger.update(this.dictStack, this.execStack, this.operandStack);
        }
    }

    public void process() throws IOException {
        this.reset();
        this.go();
    }

    public void attach(PSDebugger debugger) {
        if (this.debugger != null) {
            this.debugger.removeDebuggerListener(this);
        }
        this.debugger = debugger;
        debugger.addDebuggerListener(this);
    }
}

