/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import org.freehep.postscript.FixedTexturePaint;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSComposite;
import org.freehep.postscript.PSDevice;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSFontDictionary;
import org.freehep.postscript.PSJavaGlyph;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.Pattern;

public class PSGState
extends PSComposite {
    private PSDevice device;
    private AffineTransform ctm;
    private GeneralPath path;
    private GeneralPath clipPath;
    private float lineWidth;
    private int cap;
    private int join;
    private float miterLimit;
    private float[] dash;
    private float dashPhase;
    private PSDictionary font;
    private double flat;
    private PSPackedArray transfer;
    private ColorSpace colorSpace;
    private String colorSpaceName;
    private PSPackedArray blackGeneration;
    private PSPackedArray underColorRemoval;
    private Rectangle2D boundingBox;

    private PSGState() {
        super("gstate", true);
    }

    public PSGState(PSDevice device) {
        super("gstate", true);
        this.device = device;
        this.font = new PSFontDictionary(device.getGraphics().getFont(), "STDLatin");
        this.flat = 0.5;
        this.transfer = new PSPackedArray(new PSObject[0]);
        this.transfer.setExecutable();
        this.blackGeneration = new PSPackedArray(0);
        this.blackGeneration.setExecutable();
        this.underColorRemoval = new PSPackedArray(0);
        this.underColorRemoval.setExecutable();
        this.boundingBox = null;
        this.initGraphics();
        this.erasePage();
    }

    public void initGraphics() {
        this.ctm = new AffineTransform();
        this.newPath();
        this.initClip();
        this.setColorSpace("DeviceGray");
        this.setColor(new float[]{0.0f});
        this.lineWidth = 1.0f;
        this.cap = 0;
        this.join = 0;
        this.miterLimit = 10.0f;
        this.dash = null;
        this.dashPhase = 0.0f;
        this.setStroke();
    }

    public BufferedImage convertToImage(int width, int height) {
        return this.device.convertToImage(width, height);
    }

    public void erasePage() {
        String oldSpace = this.colorSpace();
        float[] oldColor = this.color();
        this.setColorSpace("DeviceGray");
        this.setColor(new float[]{1.0f});
        this.device.erasePage();
        this.setColorSpace(oldSpace);
        this.setColor(oldColor);
    }

    public void copyInto(PSGState copy) {
        copy.device = this.device;
        copy.ctm = (AffineTransform)this.ctm.clone();
        copy.path = (GeneralPath)this.path.clone();
        copy.clipPath = this.clipPath == null ? null : (GeneralPath)this.clipPath.clone();
        copy.lineWidth = this.lineWidth;
        copy.cap = this.cap;
        copy.join = this.join;
        copy.miterLimit = this.miterLimit;
        if (this.dash == null) {
            copy.dash = null;
        } else {
            copy.dash = new float[this.dash.length];
            System.arraycopy(this.dash, 0, copy.dash, 0, this.dash.length);
        }
        copy.dashPhase = this.dashPhase;
        copy.font = new PSDictionary();
        this.font.copyInto(copy.font);
        copy.flat = this.flat;
        copy.transfer = (PSPackedArray)this.transfer.copy();
        copy.colorSpace = this.colorSpace;
        copy.colorSpaceName = this.colorSpaceName;
        copy.blackGeneration = (PSPackedArray)this.blackGeneration.copy();
        copy.underColorRemoval = (PSPackedArray)this.underColorRemoval.copy();
        copy.boundingBox = this.boundingBox;
    }

    @Override
    public PSObject copy() {
        PSGState copy = new PSGState();
        this.copyInto(copy);
        return copy;
    }

    private void setStroke() {
        BasicStroke stroke = new BasicStroke(this.lineWidth, this.cap, this.join, this.miterLimit, this.dash, this.dashPhase);
        this.device.getGraphics().setStroke(stroke);
    }

    public void fill() {
        this.fill(this.path);
    }

    public void stroke() {
        this.stroke(this.path);
    }

    public void strokePath() {
        this.path = new GeneralPath(this.device.getGraphics().getStroke().createStrokedShape(this.path));
    }

    public Shape charPath(int cc, float x, float y, boolean strokePath) {
        Shape path;
        switch (this.font.getInteger("FontType")) {
            case 1: {
                PSName name = this.font.getPackedArray("Encoding").getName(cc);
                PSObject obj = this.font.getDictionary("CharStrings").get(name);
                GlyphVector glyph = ((PSJavaGlyph)obj).getGlyph();
                path = glyph.getOutline(x, y);
                break;
            }
            default: {
                System.out.println(this.getClass() + ": CharPath failed for fonttype: " + this.font.getInteger("FontType"));
                return null;
            }
        }
        if (strokePath) {
            path = new GeneralPath(this.device.getGraphics().getStroke().createStrokedShape(path));
        }
        return path;
    }

    public void fill(Shape s) {
        Graphics2D g = (Graphics2D)this.device.getGraphics().create();
        g.transform(this.ctm);
        g.fill(s);
        g.dispose();
    }

    public void stroke(Shape s) {
        this.stroke(s, null);
    }

    public void stroke(Shape s, AffineTransform m) {
        AffineTransform at = (AffineTransform)this.ctm.clone();
        GeneralPath p = new GeneralPath(s);
        if (m != null) {
            try {
                AffineTransform pt = m.createInverse();
                p.transform(pt);
            }
            catch (NoninvertibleTransformException e) {
                System.err.println("Internal GState Error");
            }
            at.concatenate(m);
        }
        Graphics2D g = (Graphics2D)this.device.getGraphics().create();
        g.transform(at);
        g.draw(p);
        g.dispose();
    }

    public void show(GlyphVector gv, float x, float y) {
        Graphics2D g = (Graphics2D)this.device.getGraphics().create();
        g.transform(this.ctm);
        g.drawGlyphVector(gv, x, y);
        g.dispose();
    }

    public void image(RenderedImage image, AffineTransform at) {
        Graphics2D g = (Graphics2D)this.device.getGraphics().create();
        g.transform(this.ctm);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            System.err.println("Internal GState Error");
        }
        g.drawRenderedImage(image, at);
        g.dispose();
    }

    public Point2D position() {
        return this.path == null ? null : this.path.getCurrentPoint();
    }

    public void translate(double tx, double ty) {
        AffineTransform at = AffineTransform.getTranslateInstance(-tx, -ty);
        this.path.transform(at);
        this.ctm.translate(tx, ty);
    }

    public void rotate(double angle) {
        AffineTransform at = AffineTransform.getRotateInstance(-angle);
        this.path.transform(at);
        this.ctm.rotate(angle);
    }

    public void scale(double sx, double sy) {
        AffineTransform at = AffineTransform.getScaleInstance(1.0 / sx, 1.0 / sy);
        this.path.transform(at);
        this.ctm.scale(sx, sy);
    }

    public void setTransform(AffineTransform at) {
        try {
            AffineTransform pt = at.createInverse();
            pt.concatenate(this.ctm);
            this.path.transform(pt);
        }
        catch (NoninvertibleTransformException e) {
            System.err.println("Internal GState Error");
        }
        this.ctm.setTransform(at);
    }

    public void transform(AffineTransform at) {
        try {
            AffineTransform pt = at.createInverse();
            this.path.transform(pt);
        }
        catch (NoninvertibleTransformException e) {
            System.err.println("Internal GState Error");
        }
        this.ctm.concatenate(at);
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.ctm.clone();
    }

    public GeneralPath path() {
        return this.path;
    }

    public GeneralPath newPath() {
        this.path = new GeneralPath();
        this.path.transform(this.ctm);
        return this.path;
    }

    public void initClip() {
        this.device.getGraphics().setClip(null);
        try {
            AffineTransform inverse = this.ctm.createInverse();
            this.clipPath = new GeneralPath(new Rectangle(0, 0, (int)this.device.getWidth(), (int)this.device.getHeight()));
            this.clipPath.transform(inverse);
        }
        catch (NoninvertibleTransformException e) {
            System.out.println("Internal error in GState");
        }
    }

    public void clip(Shape p) {
        this.clipPath = new GeneralPath(p);
        Shape clip = this.clipPath.createTransformedShape(this.ctm);
        this.device.getGraphics().setClip(clip);
    }

    public void clipPath() {
        this.path = (GeneralPath)this.clipPath.clone();
        this.path.transform(this.ctm);
    }

    public float lineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double width) {
        this.lineWidth = (float)width;
        this.setStroke();
    }

    public float dashPhase() {
        return this.dashPhase;
    }

    public float[] dash() {
        return this.dash;
    }

    public void setDash(float[] dash, float dashPhase) {
        if (dash.length == 0) {
            this.dash = null;
            this.dashPhase = 0.0f;
        } else {
            this.dash = dash;
            this.dashPhase = dashPhase;
        }
        this.setStroke();
    }

    public void setLineCap(int cap) {
        this.cap = cap;
        this.setStroke();
    }

    public int lineCap() {
        return this.cap;
    }

    public void setLineJoin(int join) {
        this.join = join;
        this.setStroke();
    }

    public int lineJoin() {
        return this.join;
    }

    public void setMiterLimit(float miterLimit) {
        this.miterLimit = miterLimit;
        this.setStroke();
    }

    public float miterLimit() {
        return this.miterLimit;
    }

    public void setStrokeAdjust(boolean adjust) {
        this.device.getGraphics().setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    public boolean strokeAdjust() {
        Object value = this.device.getGraphics().getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        return value == RenderingHints.VALUE_STROKE_PURE;
    }

    @Override
    public boolean execute(OperandStack os) {
        os.push(this);
        return true;
    }

    public void setFont(PSDictionary font) {
        this.font = font;
    }

    public PSDictionary font() {
        return this.font;
    }

    public void setFlat(double f) {
        this.flat = f;
    }

    public double flat() {
        return this.flat;
    }

    public void flattenPath() {
        PathIterator iterator = this.path.getPathIterator(new AffineTransform(), this.flat);
        this.newPath();
        this.path.append(iterator, true);
    }

    public void setTransfer(PSPackedArray proc) {
        this.transfer = proc;
    }

    public PSPackedArray transfer() {
        return this.transfer;
    }

    private static ColorSpace toColorSpace(String name) {
        if (name.equals("DeviceGray")) {
            return ColorSpace.getInstance(1003);
        }
        if (name.equals("DeviceRGB")) {
            return ColorSpace.getInstance(1000);
        }
        if (name.equals("DeviceCMYK")) {
            return ColorSpace.getInstance(1000);
        }
        return null;
    }

    public boolean setColorSpace(String name) {
        return this.setColorSpace(name, null);
    }

    public boolean setColorSpace(String name, Object[] params) {
        ColorSpace space = PSGState.toColorSpace(name);
        if (space == null && name.equals("Pattern")) {
            space = params == null ? new Pattern(PSGState.toColorSpace("DeviceRGB")) : new Pattern(PSGState.toColorSpace(((PSName)params[1]).cvs()));
        }
        if (space != null) {
            this.colorSpaceName = name;
            this.colorSpace = space;
            return true;
        }
        return false;
    }

    public int getNumberOfColorSpaceComponents() {
        if (this.colorSpaceName.equals("DeviceGray")) {
            return 1;
        }
        if (this.colorSpaceName.equals("DeviceRGB")) {
            return 3;
        }
        if (this.colorSpaceName.equals("DeviceCMYK")) {
            return 4;
        }
        if (this.colorSpaceName.equals("Pattern")) {
            return this.colorSpace.getNumComponents();
        }
        return 0;
    }

    public String colorSpace() {
        return this.colorSpaceName;
    }

    private static String toColorSpaceName(ColorSpace space) {
        switch (space.getType()) {
            case 1003: {
                return "DeviceGray";
            }
            case 1000: {
                return "DeviceRGB";
            }
        }
        return "Unknown";
    }

    public void setColor(Paint paint) {
        this.setColorSpace("Pattern");
        this.setColor(paint, null);
    }

    public void setColor(Paint paint, Object[] params) {
        if (params != null) {
            FixedTexturePaint ftp = (FixedTexturePaint)paint;
            BufferedImage image = ftp.getImage();
            ColorConvertOp convert = new ColorConvertOp(ColorSpace.getInstance(1000), null);
            System.out.println(image.getSampleModel().getNumBands());
            BufferedImage filteredImage = convert.filter(image, null);
        }
        this.device.getGraphics().setPaint(paint);
    }

    public void setColor(float[] color) {
        float[] rgb = PSGState.toRGB(color, this.colorSpaceName);
        if (rgb != null) {
            this.device.getGraphics().setPaint(new Color(rgb[0], rgb[1], rgb[2]));
        } else {
            System.err.println("Unknown colorspace: " + this.colorSpaceName);
        }
    }

    public static float[] toRGB(float[] color, String space) {
        if (space.equals("DeviceGray")) {
            float c = Math.max(0.0f, Math.min(1.0f, color[0]));
            return new float[]{c, c, c};
        }
        if (space.equals("DeviceRGB")) {
            float r = Math.max(0.0f, Math.min(1.0f, color[0]));
            float g = Math.max(0.0f, Math.min(1.0f, color[1]));
            float b = Math.max(0.0f, Math.min(1.0f, color[2]));
            return new float[]{r, g, b};
        }
        if (space.equals("DeviceCMYK")) {
            float r = Math.max(0.0f, 1.0f - Math.min(1.0f, color[0] + color[3]));
            float g = Math.max(0.0f, 1.0f - Math.min(1.0f, color[1] + color[3]));
            float b = Math.max(0.0f, 1.0f - Math.min(1.0f, color[2] + color[3]));
            return new float[]{r, g, b};
        }
        return null;
    }

    public float[] color() {
        return this.color(this.colorSpaceName);
    }

    public float[] color(String space) {
        float[] rgb = this.device.getGraphics().getColor().getColorComponents(null);
        if (space.equals("Pattern")) {
            rgb = this.colorSpace.toRGB(rgb);
            space = PSGState.toColorSpaceName(this.colorSpace);
        }
        if ((rgb = PSGState.toColor(space, rgb)) == null) {
            System.err.println("Unknown colorspace: " + this.colorSpaceName);
        }
        return rgb;
    }

    public static float[] toColor(String space, float[] rgb) {
        if (space.equals("DeviceGray")) {
            float[] color = new float[]{(float)(0.3 * (double)rgb[0] + 0.59 * (double)rgb[1] + 0.11 * (double)rgb[2])};
            return color;
        }
        if (space.equals("DeviceRGB")) {
            return rgb;
        }
        if (space.equals("DeviceCMYK")) {
            float c = 1.0f - rgb[0];
            float m = 1.0f - rgb[1];
            float y = 1.0f - rgb[2];
            float k = Math.min(c, Math.min(m, y));
            float[] color = new float[]{Math.min(1.0f, Math.max(0.0f, c)), Math.min(1.0f, Math.max(0.0f, m)), Math.min(1.0f, Math.max(0.0f, y)), Math.min(1.0f, Math.max(0.0f, k))};
            return color;
        }
        return null;
    }

    public void setBlackGeneration(PSPackedArray p) {
        this.blackGeneration = p;
    }

    public PSPackedArray blackGeneration() {
        return this.blackGeneration;
    }

    public void setUnderColorRemoval(PSPackedArray p) {
        this.underColorRemoval = p;
    }

    public PSPackedArray underColorRemoval() {
        return this.underColorRemoval;
    }

    public void setBoundingBox(Rectangle2D bb) {
        if (this.boundingBox != null) {
            this.boundingBox.add(bb);
        } else {
            this.boundingBox = bb;
        }
    }

    public Rectangle2D boundingBox() {
        return this.boundingBox;
    }

    @Override
    public String getType() {
        return "gstatetype";
    }

    @Override
    public int hashCode() {
        return this.device.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PSGState) {
            return this.device == ((PSGState)o).device;
        }
        return false;
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public String cvs() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "--" + this.name + "--";
    }
}

