/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.util.Hashtable;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.Lookup;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSJavaFont;
import org.freehep.postscript.PSJavaGlyph;
import org.freehep.postscript.PSObject;

public class PSFontDictionary
extends PSDictionary {
    protected PSFontDictionary(Hashtable t) {
        super(t);
    }

    public PSFontDictionary(Font font, String encodingTable) {
        this.setName("fontdictionary");
        boolean antiAliasing = true;
        FontRenderContext fontRenderContext = new FontRenderContext(null, antiAliasing, true);
        CharTable table = Lookup.getInstance().getTable(encodingTable);
        this.put("javafont", (PSObject)new PSJavaFont(font));
        this.put("javaEncoding", encodingTable);
        this.put("FontType", 1);
        this.put("FontMatrix", (PSObject)new PSArray(new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}));
        this.put("FontName", font.getPSName());
        PSArray encoding = new PSArray(256);
        this.put("Encoding", (PSObject)encoding);
        this.put("FontBBox", (PSObject)new PSArray(new float[]{0.0f, 0.0f, 0.0f, 0.0f}));
        this.put("PaintType", 0);
        PSDictionary charStrings = new PSDictionary();
        this.put("CharStrings", (PSObject)charStrings);
        PSDictionary metrics = new PSDictionary();
        this.put("Metrics", (PSObject)metrics);
        this.put("Private", (PSObject)new PSDictionary());
        AffineTransform at = font.getTransform();
        AffineTransform upsideDown = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
        at.concatenate(upsideDown);
        font = font.deriveFont(at);
        char[] uc = new char[1];
        for (int cc = 0; cc < 256; ++cc) {
            String name = table.toName(cc);
            if (name != null) {
                uc[0] = table.toUnicode(name);
            } else {
                name = ".notdef";
                uc[0] = 9633;
            }
            GlyphVector gv = font.createGlyphVector(fontRenderContext, uc);
            GlyphMetrics m = gv.getGlyphMetrics(0);
            PSJavaGlyph glyph = new PSJavaGlyph(gv);
            encoding.set(cc, name);
            charStrings.put(name, (PSObject)glyph);
            metrics.put(name, m.getAdvance());
        }
    }

    @Override
    public String getType() {
        return "javafontdictionary";
    }

    @Override
    public Object clone() {
        return new PSFontDictionary(this.table);
    }

    @Override
    public String toString() {
        return "--" + (this.isExecutable() ? "*" : "") + this.name + " (" + this.size() + ")--";
    }
}

