/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.IOException;
import org.freehep.postscript.IOError;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSComposite;

public abstract class PSFile
extends PSComposite {
    protected String filename;
    protected boolean filter;

    protected PSFile(String name, boolean isFilter) {
        super("file", true);
        this.filter = isFilter;
        this.filename = name;
    }

    @Override
    public boolean execute(OperandStack os) {
        PSFile.error(os, new IOError());
        return true;
    }

    @Override
    public String getType() {
        return "filetype";
    }

    public abstract void close() throws IOException;

    public int read() throws IOException {
        throw new IOException();
    }

    public String readLine() throws IOException {
        throw new IOException();
    }

    public void write(int b, boolean secure) throws IOException {
        throw new IOException();
    }

    public void seek(long pos) throws IOException {
        throw new IOException();
    }

    public long getFilePointer() throws IOException {
        throw new IOException();
    }

    public int available() throws IOException {
        throw new IOException();
    }

    public void flush() throws IOException {
        throw new IOException();
    }

    public void reset() throws IOException {
        throw new IOException();
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
    }

    public abstract boolean isValid();

    @Override
    public String cvs() {
        return this.name;
    }

    @Override
    public String toString() {
        return "--" + (this.isExecutable() ? "*" : "") + this.name + " (" + this.filename + ") --";
    }
}

