/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.freehep.postscript.DSCEvent;
import org.freehep.postscript.DSCEventListener;

public abstract class PSDevice
implements DSCEventListener {
    private boolean valid = false;
    private AffineTransform mirror = null;
    private AffineTransform boundingBox = new AffineTransform();
    private AffineTransform pageBoundingBox = null;
    private AffineTransform transform = new AffineTransform();
    private Graphics2D graphics;
    private Collection listeners = new ArrayList();

    public void addComponentListener(ComponentListener l) {
        this.listeners.add(l);
    }

    public void removeComponentListener(ComponentListener l) {
        this.listeners.remove(l);
    }

    protected void fireComponentResizedEvent(ComponentEvent e) {
        this.valid = false;
        this.mirror = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, this.getHeight());
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ComponentListener)i.next()).componentResized(e);
        }
    }

    @Override
    public void dscCommentFound(DSCEvent event) {
        double s;
        Rectangle bb;
        if (event.getComment().equals("BoundingBox:")) {
            bb = (Rectangle)event.getArgs();
            s = Math.min(this.getWidth() / (double)bb.width, this.getHeight() / (double)bb.height);
            this.boundingBox = new AffineTransform(s, 0.0, 0.0, s, (double)(-bb.x) * s, (double)(-bb.y) * s);
            this.pageBoundingBox = null;
            this.valid = false;
        }
        if (event.getComment().equals("PageBoundingBox:")) {
            bb = (Rectangle)event.getArgs();
            s = Math.min(this.getWidth() / (double)bb.width, this.getHeight() / (double)bb.height);
            this.pageBoundingBox = new AffineTransform(s, 0.0, 0.0, s, (double)(-bb.x) * s, (double)(-bb.y) * s);
            this.valid = false;
        }
        if (event.getComment().equals("Page:")) {
            this.pageBoundingBox = null;
            this.valid = false;
        }
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform != null ? transform : new AffineTransform();
        this.valid = false;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public AffineTransform getMirrorTransform() {
        if (this.mirror == null) {
            this.mirror = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, this.getHeight());
        }
        return this.mirror;
    }

    public AffineTransform getBoundingBoxTransform() {
        return this.pageBoundingBox != null ? this.pageBoundingBox : this.boundingBox;
    }

    public Graphics2D getGraphics() {
        if (!this.valid) {
            this.graphics = (Graphics2D)this.getDeviceGraphics();
            this.graphics.setTransform(this.getDeviceTransform());
            this.graphics.transform(this.getTransform());
            this.graphics.transform(this.getMirrorTransform());
            this.graphics.transform(this.getBoundingBoxTransform());
            this.valid = true;
        }
        return this.graphics;
    }

    public void erasePage() {
        this.graphics = (Graphics2D)this.getDeviceGraphics();
        this.graphics.setTransform(this.getDeviceTransform());
        this.graphics.fillRect(0, 0, (int)this.getWidth(), (int)this.getHeight());
        this.valid = false;
    }

    public abstract AffineTransform getDeviceTransform();

    public abstract Graphics getDeviceGraphics();

    public abstract double getWidth();

    public abstract double getHeight();

    public abstract BufferedImage convertToImage(int var1, int var2);

    public abstract void refresh();
}

