/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.GeneralOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;
import org.freehep.postscript.Undefined;

class Get
extends GeneralOperator {
    Get() {
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSArray.class, PSInteger.class) || os.checkType(PSPackedArray.class, PSInteger.class)) {
            PSInteger i = os.popInteger();
            PSArray a = os.popArray();
            if (i.getValue() < 0 || i.getValue() >= a.size()) {
                Get.error(os, new RangeCheck());
            } else {
                os.push(a.get(i.getValue()));
            }
        } else if (os.checkType(PSDictionary.class, PSObject.class)) {
            PSObject key = os.popObject();
            PSDictionary d = os.popDictionary();
            PSObject o = d.get(key);
            if (o == null) {
                Get.error(os, new Undefined());
            } else {
                os.push(o);
            }
        } else if (os.checkType(PSString.class, PSInteger.class)) {
            PSInteger i = os.popInteger();
            PSString s = os.popString();
            if (i.getValue() < 0 || i.getValue() >= s.size()) {
                Get.error(os, new RangeCheck());
            } else {
                os.push(s.get(i.getValue()));
            }
        } else {
            Get.error(os, new TypeCheck());
        }
        return true;
    }
}

