/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.IOException;
import org.freehep.postscript.FileOperator;
import org.freehep.postscript.IOError;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSDataSource;
import org.freehep.postscript.PSDataTarget;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSInputFile;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSOutputFile;
import org.freehep.postscript.TypeCheck;
import org.freehep.postscript.Undefined;
import org.freehep.util.io.ASCII85InputStream;
import org.freehep.util.io.ASCII85OutputStream;
import org.freehep.util.io.ASCIIHexInputStream;
import org.freehep.util.io.ASCIIHexOutputStream;
import org.freehep.util.io.DCTInputStream;
import org.freehep.util.io.FlateInputStream;
import org.freehep.util.io.FlateOutputStream;
import org.freehep.util.io.RunLengthInputStream;
import org.freehep.util.io.RunLengthOutputStream;

class Filter
extends FileOperator {
    Filter() {
        this.operandTypes = new Class[]{PSName.class};
    }

    public boolean encode(OperandStack os, String filterName) throws IOException {
        if (filterName.equals("RunLengthEncode")) {
            int runLength = os.popInteger().getValue();
            if (os.checkType(PSDictionary.class)) {
                PSDictionary pSDictionary = os.popDictionary();
            }
            PSDataTarget target = os.popDataTarget();
            os.push(new PSOutputFile(new RunLengthOutputStream(target.getOutputStream())));
            Filter.error(os, new Undefined());
            return true;
        }
        if (os.checkType(PSDictionary.class)) {
            PSDictionary pSDictionary = os.popDictionary();
        }
        PSDataTarget target = os.popDataTarget();
        if (filterName.equals("ASCIIHexEncode")) {
            os.push(new PSOutputFile(new ASCIIHexOutputStream(target.getOutputStream())));
        } else if (filterName.equals("ASCII85Encode")) {
            os.push(new PSOutputFile(new ASCII85OutputStream(target.getOutputStream())));
        } else {
            if (filterName.equals("LZWEncode")) {
                Filter.error(os, new Undefined());
                return true;
            }
            if (filterName.equals("FlateEncode")) {
                os.push(new PSOutputFile(new FlateOutputStream(target.getOutputStream())));
            } else {
                if (filterName.equals("CCITTFaxEncode")) {
                    Filter.error(os, new Undefined());
                    return true;
                }
                if (filterName.equals("NullEncode")) {
                    os.push(new PSOutputFile(target.getOutputStream()));
                } else {
                    Filter.error(os, new Undefined());
                    return true;
                }
            }
        }
        return true;
    }

    public boolean decode(OperandStack os, String filterName) throws IOException {
        if (filterName.equals("SubFileDecode")) {
            Filter.error(os, new Undefined());
            return true;
        }
        if (os.checkType(PSDictionary.class)) {
            PSDictionary pSDictionary = os.popDictionary();
        }
        PSDataSource source = os.popDataSource();
        if (filterName.equals("ASCIIHexDecode")) {
            os.push(new PSInputFile(new ASCIIHexInputStream(source.getInputStream()), source.getDSC()));
        } else if (filterName.equals("ASCII85Decode")) {
            os.push(new PSInputFile(new ASCII85InputStream(source.getInputStream()), source.getDSC()));
        } else {
            if (filterName.equals("LZWDecode")) {
                Filter.error(os, new Undefined());
                return true;
            }
            if (filterName.equals("FlateDecode")) {
                os.push(new PSInputFile(new FlateInputStream(source.getInputStream()), source.getDSC()));
            } else if (filterName.equals("RunLengthDecode")) {
                os.push(new PSInputFile(new RunLengthInputStream(source.getInputStream()), source.getDSC()));
            } else {
                if (filterName.equals("CCITTFaxDecode")) {
                    Filter.error(os, new Undefined());
                    return true;
                }
                if (filterName.equals("DCTDecode")) {
                    os.push(new PSInputFile(new DCTInputStream(source.getInputStream()), source.getDSC()));
                    return true;
                }
                if (filterName.equals("ReusableStreamDecode")) {
                    Filter.error(os, new Undefined());
                    return true;
                }
                Filter.error(os, new Undefined());
                return true;
            }
        }
        if (!os.checkType(PSDataSource.class)) {
            Filter.error(os, new TypeCheck());
            return true;
        }
        return true;
    }

    @Override
    public boolean execute(OperandStack os) {
        String filterName = os.popName().getValue();
        try {
            return filterName.endsWith("Encode") ? this.encode(os, filterName) : this.decode(os, filterName);
        }
        catch (ClassCastException e) {
            Filter.error(os, new TypeCheck());
            return true;
        }
        catch (IOException e) {
            Filter.error(os, new IOError());
            return true;
        }
    }
}

