/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.File;
import java.util.ArrayList;
import org.freehep.postscript.FileOperator;
import org.freehep.postscript.LoopingContext;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.TypeCheck;
import org.freehep.postscript.Undefined;
import org.freehep.util.io.StandardFileFilter;

class FilenameForAll
extends FileOperator
implements LoopingContext {
    private int index;
    private String[] files;
    private PSPackedArray proc;
    private PSString scratch;

    public FilenameForAll() {
    }

    private FilenameForAll(String[] f, PSPackedArray p, PSString s) {
        this.files = f;
        this.proc = p;
        this.scratch = s;
        this.index = 0;
    }

    @Override
    public boolean execute(OperandStack os) {
        if (this.proc == null) {
            if (!os.checkType(PSString.class, PSPackedArray.class, PSString.class)) {
                FilenameForAll.error(os, new TypeCheck());
                return true;
            }
            PSString s = os.popString();
            PSPackedArray p = os.popPackedArray();
            PSString template = os.popString();
            String dir = template.getValue();
            if (dir.startsWith("%")) {
                System.err.println("%device%file currently not supported.");
                FilenameForAll.error(os, new Undefined());
                return true;
            }
            File directory = new File(dir.lastIndexOf("/") < 0 ? "./" : dir);
            StandardFileFilter filter = new StandardFileFilter(dir);
            File[] matchedFiles = directory.listFiles(filter);
            ArrayList<String> matchedFileNames = new ArrayList<String>();
            for (int i = 0; i < matchedFiles.length; ++i) {
                matchedFileNames.add(matchedFiles[i].getName());
            }
            String[] f = (String[])matchedFileNames.toArray();
            os.execStack().pop();
            os.execStack().push(new FilenameForAll(f, p, s));
            return false;
        }
        if (this.index >= this.files.length) {
            return true;
        }
        PSString name = this.scratch.set(this.files[this.index]);
        os.push(name);
        os.execStack().push(this.proc);
        ++this.index;
        return true;
    }
}

